/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.util.AvroValidator;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Assert;

public class VerifyRecord {
    private static final JsonConverter keyJsonConverter = new JsonConverter();
    private static final JsonConverter valueJsonConverter = new JsonConverter();
    private static final JsonDeserializer keyJsonDeserializer = new JsonDeserializer();
    private static final JsonDeserializer valueJsonDeserializer = new JsonDeserializer();
    private static final MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
    private static final AvroConverter avroKeyConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
    private static final AvroConverter avroValueConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);

    public static void isValidInsert(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
        Assertions.assertThat((Object)value.get("before")).isNull();
    }

    public static void isValidUpdate(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
    }

    public static void isValidDelete(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
        Assertions.assertThat((Object)value.get("before")).isNotNull();
        Assertions.assertThat((Object)value.get("after")).isNull();
    }

    public static void isValidTombstone(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.value()).isNull();
        Assertions.assertThat((Object)record.valueSchema()).isNull();
    }

    public static void hasValidKey(SourceRecord record, String pkField, int pk) {
        Struct key = (Struct)record.key();
        Assertions.assertThat((Object)key.get(pkField)).isEqualTo((Object)pk);
    }

    public static void isValidInsert(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidInsert(record);
    }

    public static void isValidUpdate(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidUpdate(record);
    }

    public static void isValidDelete(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidDelete(record);
    }

    public static void isValidTombstone(SourceRecord record, String pkField, int pk) {
        VerifyRecord.hasValidKey(record, pkField, pk);
        VerifyRecord.isValidTombstone(record);
    }

    public static void schemaMatchesStruct(SchemaAndValue schemaAndValue) {
        Object value = schemaAndValue.value();
        if (value == null) {
            Assertions.assertThat((Object)schemaAndValue.schema()).isNull();
        } else {
            Assertions.assertThat((Object)value).isInstanceOf(Struct.class);
            VerifyRecord.fieldsInSchema((Struct)value, schemaAndValue.schema());
        }
    }

    public static void schemaMatchesStruct(Struct struct, Schema schema) {
        try {
            struct.validate();
        }
        catch (DataException e) {
            throw new AssertionError("The struct '" + struct + "' failed to validate", e);
        }
        Schema actualSchema = struct.schema();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)schema);
        VerifyRecord.fieldsInSchema(struct, schema);
    }

    public static void fieldsInSchema(Struct struct, Schema schema) {
        schema.fields().forEach(field -> {
            Object val1 = struct.get(field);
            Object val2 = struct.get(field.name());
            Assertions.assertThat((Object)val1).isSameAs(val2);
            if (val1 instanceof Struct) {
                VerifyRecord.fieldsInSchema((Struct)val1, field.schema());
            }
        });
    }

    public static void print(SourceRecord record) {
        Testing.print(SchemaUtil.asString((SourceRecord)record));
    }

    public static void debug(SourceRecord record) {
        Testing.debug(SchemaUtil.asDetailedString((SourceRecord)record));
    }

    public static void isValid(SourceRecord record) {
        VerifyRecord.print(record);
        JsonNode keyJson = null;
        JsonNode valueJson = null;
        SchemaAndValue keyWithSchema = null;
        SchemaAndValue valueWithSchema = null;
        SchemaAndValue avroKeyWithSchema = null;
        SchemaAndValue avroValueWithSchema = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "serializing key using JSON converter";
            byte[] keyBytes = keyJsonConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            msg = "deserializing key using JSON deserializer";
            keyJson = keyJsonDeserializer.deserialize(record.topic(), keyBytes);
            msg = "deserializing key using JSON converter";
            keyWithSchema = keyJsonConverter.toConnectData(record.topic(), keyBytes);
            msg = "comparing key schema to that serialized/deserialized with JSON converter";
            Assertions.assertThat((Object)keyWithSchema.schema()).isEqualTo((Object)record.keySchema());
            msg = "comparing key to that serialized/deserialized with JSON converter";
            Assertions.assertThat((Object)keyWithSchema.value()).isEqualTo(record.key());
            msg = "comparing key to its schema";
            VerifyRecord.schemaMatchesStruct(keyWithSchema);
            msg = "serializing value using JSON converter";
            byte[] valueBytes = valueJsonConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using JSON deserializer";
            valueJson = valueJsonDeserializer.deserialize(record.topic(), valueBytes);
            msg = "deserializing value using JSON converter";
            valueWithSchema = valueJsonConverter.toConnectData(record.topic(), valueBytes);
            msg = "comparing value schema to that serialized/deserialized with JSON converter";
            VerifyRecord.assertEquals(valueWithSchema.schema(), record.valueSchema());
            msg = "comparing value to that serialized/deserialized with JSON converter";
            VerifyRecord.assertEquals(valueWithSchema.value(), record.value());
            msg = "comparing value to its schema";
            VerifyRecord.schemaMatchesStruct(valueWithSchema);
            VerifyRecord.validateSchemaNames(record.keySchema());
            VerifyRecord.validateSchemaNames(record.valueSchema());
            msg = "serializing key using Avro converter";
            byte[] avroKeyBytes = avroValueConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            msg = "deserializing key using Avro converter";
            avroKeyWithSchema = avroValueConverter.toConnectData(record.topic(), avroKeyBytes);
            msg = "comparing key schema to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(keyWithSchema.schema(), record.keySchema());
            msg = "comparing key to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(keyWithSchema.value(), record.key());
            msg = "comparing key to its schema";
            VerifyRecord.schemaMatchesStruct(keyWithSchema);
            msg = "serializing value using Avro converter";
            byte[] avroValueBytes = avroValueConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using Avro converter";
            avroValueWithSchema = avroValueConverter.toConnectData(record.topic(), avroValueBytes);
            msg = "comparing value schema to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(valueWithSchema.schema(), record.valueSchema());
            msg = "comparing value to that serialized/deserialized with Avro converter";
            VerifyRecord.assertEquals(valueWithSchema.value(), record.value());
            msg = "comparing value to its schema";
            VerifyRecord.schemaMatchesStruct(valueWithSchema);
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  key: " + SchemaUtil.asString((Object)record.key()));
            Testing.print("  key deserialized from JSON: " + VerifyRecord.prettyJson(keyJson));
            if (keyWithSchema != null) {
                Testing.print("  key to/from JSON: " + SchemaUtil.asString((Object)keyWithSchema.value()));
            }
            if (avroKeyWithSchema != null) {
                Testing.print("  key to/from Avro: " + SchemaUtil.asString((Object)avroKeyWithSchema.value()));
            }
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from JSON: " + VerifyRecord.prettyJson(valueJson));
            if (valueWithSchema != null) {
                Testing.print("  value to/from JSON: " + SchemaUtil.asString((Object)valueWithSchema.value()));
            }
            if (avroValueWithSchema != null) {
                Testing.print("  value to/from Avro: " + SchemaUtil.asString((Object)avroValueWithSchema.value()));
            }
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    protected static void validateSchemaNames(Schema schema) {
        if (schema == null) {
            return;
        }
        String schemaName = schema.name();
        if (schemaName != null && !AvroValidator.isValidFullname((String)schemaName)) {
            Assert.fail((String)("Kafka schema '" + schemaName + "' is not a valid Avro schema name"));
        }
        if (schema.type() == Schema.Type.STRUCT) {
            schema.fields().forEach(field -> VerifyRecord.validateSubSchemaNames(schema, field));
        }
    }

    protected static void validateSubSchemaNames(Schema parentSchema, Field field) {
        if (field == null) {
            return;
        }
        Schema subSchema = field.schema();
        String subSchemaName = subSchema.name();
        if (subSchemaName != null && !AvroValidator.isValidFullname((String)subSchemaName)) {
            Assert.fail((String)("Kafka schema '" + parentSchema.name() + "' contains a subschema for '" + field.name() + "' named '" + subSchema.name() + "' that is not a valid Avro schema name"));
        }
        if (subSchema.type() == Schema.Type.STRUCT) {
            subSchema.fields().forEach(child -> VerifyRecord.validateSubSchemaNames(parentSchema, child));
        }
    }

    protected static void printJson(SourceRecord record) {
        JsonNode keyJson = null;
        JsonNode valueJson = null;
        try {
            byte[] keyBytes = keyJsonConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            keyJson = keyJsonDeserializer.deserialize(record.topic(), keyBytes);
            byte[] valueBytes = valueJsonConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            valueJson = valueJsonDeserializer.deserialize(record.topic(), valueBytes);
            JsonNodeFactory nodeFactory = new JsonNodeFactory(false);
            ObjectNode message = nodeFactory.objectNode();
            message.set("key", keyJson);
            message.set("value", valueJson);
            Testing.print("Message on topic '" + record.topic() + "':");
            Testing.print(VerifyRecord.prettyJson((JsonNode)message));
        }
        catch (Throwable t) {
            Testing.printError(t);
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            if (keyJson != null) {
                Testing.print("valid key = " + VerifyRecord.prettyJson(keyJson));
            } else {
                Testing.print("invalid key");
            }
            if (valueJson != null) {
                Testing.print("valid value = " + VerifyRecord.prettyJson(valueJson));
            } else {
                Testing.print("invalid value");
            }
            Assert.fail((String)t.getMessage());
        }
    }

    protected static String prettyJson(JsonNode json) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        }
        catch (Throwable t) {
            Testing.printError(t);
            Assert.fail((String)t.getMessage());
            assert (false) : "Will not get here";
            return null;
        }
    }

    protected static void assertEquals(Object o1, Object o2) {
        if (!VerifyRecord.equals(o1, o2)) {
            Assert.fail((String)(SchemaUtil.asString((Object)o1) + " was not equal to " + SchemaUtil.asString((Object)o2)));
        }
    }

    protected static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof ByteBuffer) {
            o1 = ((ByteBuffer)o1).array();
        }
        if (o2 instanceof ByteBuffer) {
            o2 = ((ByteBuffer)o2).array();
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            boolean result = Arrays.equals((byte[])o1, (byte[])o2);
            return result;
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            boolean result = VerifyRecord.deepEquals((Object[])o1, (Object[])o2);
            return result;
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            if (!m1.keySet().equals(m2.keySet())) {
                return false;
            }
            for (Map.Entry entry : m1.entrySet()) {
                Object v2;
                Object v1 = entry.getValue();
                if (VerifyRecord.equals(v1, v2 = m2.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Collection && o2 instanceof Collection) {
            Collection m1 = (Collection)o1;
            Collection m2 = (Collection)o2;
            if (m1.size() != m2.size()) {
                return false;
            }
            Iterator iter1 = m1.iterator();
            Iterator iter2 = m2.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (VerifyRecord.equals(iter1.next(), iter2.next())) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Struct && o2 instanceof Struct) {
            Struct struct1 = (Struct)o1;
            Struct struct2 = (Struct)o2;
            if (!Objects.equals(struct1.schema(), struct2.schema())) {
                return false;
            }
            Object[] array1 = VerifyRecord.valuesFor(struct1);
            Object[] array2 = VerifyRecord.valuesFor(struct2);
            boolean result = VerifyRecord.deepEquals(array1, array2);
            return result;
        }
        return Objects.equals(o1, o2);
    }

    private static Object[] valuesFor(Struct struct) {
        Object[] array = new Object[struct.schema().fields().size()];
        int index = 0;
        for (Field field : struct.schema().fields()) {
            array[index] = struct.get(field);
            ++index;
        }
        return array;
    }

    private static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = VerifyRecord.deepEquals0(e1, e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEquals0(Object e1, Object e2) {
        assert (e1 != null);
        boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? VerifyRecord.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Arrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Arrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Arrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Arrays.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Arrays.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Arrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Arrays.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? Arrays.equals((boolean[])e1, (boolean[])e2) : VerifyRecord.equals(e1, e2)))))))));
        return eq;
    }

    static {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("schemas.enable", Boolean.TRUE.toString());
        config.put("schemas.cache.size", 100);
        keyJsonConverter.configure(config, true);
        keyJsonDeserializer.configure(config, true);
        valueJsonConverter.configure(config, false);
        valueJsonDeserializer.configure(config, false);
        config = new HashMap();
        config.put("schema.registry.url", "http://fake-url");
        avroKeyConverter.configure(config, false);
        avroValueConverter.configure(config, false);
    }
}

