/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.util.AvroValidator;
import java.sql.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableSchemaBuilderTest {
    private final String prefix = "";
    private final TableId id = new TableId("catalog", "schema", "table");
    private final Object[] data = new Object[]{"c1value", 3.142, Date.valueOf("2001-10-31"), 4};
    private Table table;
    private Column c1;
    private Column c2;
    private Column c3;
    private Column c4;
    private TableSchema schema;
    private AvroValidator validator;

    @Before
    public void beforeEach() {
        this.validator = AvroValidator.create((original, replacement, conflict) -> Assert.fail((String)"Should not have come across an invalid schema name"));
        this.schema = null;
        this.table = Table.editor().tableId(this.id).addColumns(new Column[]{Column.editor().name("C1").type("VARCHAR").jdbcType(12).length(10).optional(false).generated(true).create(), Column.editor().name("C2").type("NUMBER").jdbcType(2).length(5).scale(3).create(), Column.editor().name("C3").type("DATE").jdbcType(91).length(4).optional(true).create(), Column.editor().name("C4").type("COUNTER").jdbcType(4).autoIncremented(true).optional(true).create()}).setPrimaryKeyNames(new String[]{"C1", "C2"}).create();
        this.c1 = this.table.columnWithName("C1");
        this.c2 = this.table.columnWithName("C2");
        this.c3 = this.table.columnWithName("C3");
        this.c4 = this.table.columnWithName("C4");
    }

    @Test
    public void checkPreconditions() {
        Assertions.assertThat((Object)this.c1).isNotNull();
        Assertions.assertThat((Object)this.c2).isNotNull();
        Assertions.assertThat((Object)this.c3).isNotNull();
        Assertions.assertThat((Object)this.c4).isNotNull();
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToBuildTableSchemaFromNullTable() {
        new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), arg_0 -> ((AvroValidator)this.validator).validate(arg_0)).create("", null);
    }

    @Test
    public void shouldBuildTableSchemaFromTable() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), arg_0 -> ((AvroValidator)this.validator).validate(arg_0)).create("", this.table);
        Assertions.assertThat((Object)this.schema).isNotNull();
    }

    @Test
    public void shouldBuildTableSchemaFromTableWithoutPrimaryKey() {
        this.table = this.table.edit().setPrimaryKeyNames(new String[0]).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), arg_0 -> ((AvroValidator)this.validator).validate(arg_0)).create("", this.table);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((Object)this.schema.keySchema()).isNull();
        Assertions.assertThat((Object)this.schema.keyFromColumnData(this.data)).isNull();
        Schema values = this.schema.valueSchema();
        Assertions.assertThat((Object)values).isNotNull();
        Assertions.assertThat((String)values.field("C1").name()).isEqualTo((Object)"C1");
        Assertions.assertThat((int)values.field("C1").index()).isEqualTo(0);
        Assertions.assertThat((Object)values.field("C1").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((int)values.field("C2").index()).isEqualTo(1);
        Assertions.assertThat((Object)values.field("C2").schema()).isEqualTo((Object)Decimal.builder((int)3).optional().build());
        Assertions.assertThat((String)values.field("C3").name()).isEqualTo((Object)"C3");
        Assertions.assertThat((int)values.field("C3").index()).isEqualTo(2);
        Assertions.assertThat((Object)values.field("C3").schema()).isEqualTo((Object)io.debezium.time.Date.builder().optional().build());
        Assertions.assertThat((String)values.field("C4").name()).isEqualTo((Object)"C4");
        Assertions.assertThat((int)values.field("C4").index()).isEqualTo(3);
        Assertions.assertThat((Object)values.field("C4").schema()).isEqualTo((Object)SchemaBuilder.int32().optional().build());
        Struct value = this.schema.valueFromColumnData(this.data);
        Assertions.assertThat((Object)value).isNotNull();
    }
}

