/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Document;
import io.debezium.document.Path;
import io.debezium.document.Value;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DocumentTest {
    private Document doc;
    private Map<Path, Value> found = new LinkedHashMap<Path, Value>();
    private Iterator<Map.Entry<Path, Value>> iterator;

    @Before
    public void beforeEach() {
        this.doc = null;
        this.found = new LinkedHashMap<Path, Value>();
        this.iterator = null;
    }

    @Test
    public void shouldPerformForEachOnFlatDocument() {
        this.doc = Document.create((CharSequence)"a", (Object)"A", (CharSequence)"b", (Object)"B");
        this.doc.forEach((path, value) -> this.found.put((Path)path, (Value)value));
        this.iterator = this.found.entrySet().iterator();
        this.assertPair(this.iterator, "/a", "A");
        this.assertPair(this.iterator, "/b", "B");
        this.assertNoMore(this.iterator);
    }

    protected void assertPair(Iterator<Map.Entry<Path, Value>> iterator, String path, Object value) {
        Map.Entry<Path, Value> entry = iterator.next();
        Assertions.assertThat((Object)entry.getKey()).isEqualTo((Object)Path.parse((String)path));
        Assertions.assertThat((Object)entry.getValue()).isEqualTo((Object)Value.create((Object)value));
    }

    protected void assertNoMore(Iterator<Map.Entry<Path, Value>> iterator) {
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }
}

