/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationTest {
    private Configuration config;

    @Before
    public void beforeEach() {
        this.config = ((Configuration.Builder)Configuration.create().with("A", "a").with("B", "b").with("1", 1)).build();
    }

    @Test
    public void shouldConvertFromProperties() {
        Properties props = new Properties();
        props.setProperty("A", "a");
        props.setProperty("B", "b");
        props.setProperty("1", "1");
        this.config = Configuration.from((Properties)props);
        Assertions.assertThat((String)this.config.getString("A")).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.config.getString("B")).isEqualTo((Object)"b");
        Assertions.assertThat((String)this.config.getString("1")).isEqualTo((Object)"1");
        Assertions.assertThat((Integer)this.config.getInteger("1")).isEqualTo(1);
        Assertions.assertThat((Boolean)this.config.getBoolean("1")).isNull();
    }

    @Test
    public void shouldCallFunctionOnEachMatchingFieldUsingRegex() {
        this.config = Configuration.create().with("column.truncate.to.-10.chars", "should-not-be-matched").with("column.truncate.to.10.chars", "10-chars").with("column.truncate.to.20.chars", "20-chars").with("column.mask.with.20.chars", "20-mask").with("column.mask.with.0.chars", "0-mask").with("column.mask.with.chars", "should-not-be-matched").build();
        AtomicInteger counter = new AtomicInteger();
        this.config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-chars"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldNameWithInteger("column.mask.with.(\\d+).chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-mask"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.mask.with.(\\d+).chars", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith("column.mask.with.");
            Assertions.assertThat((String)name).endsWith(".chars");
            Assertions.assertThat((String)value).endsWith("-mask");
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.*", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith("column.");
            Assertions.assertThat((String)name).endsWith(".chars");
            Assertions.assertThat((String)value).isNotNull();
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(6);
    }
}

