/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.jdbc.TimeZoneAdapter;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TimeZoneAdapterTest {
    private TimeZoneAdapter adapter;

    @Before
    public void beforeEach() {
        this.adapter = TimeZoneAdapter.create().withLocalZoneForUtilDate().withLocalZoneForSqlDate().withLocalZoneForSqlTime().withLocalZoneForSqlTimestamp().withUtcTargetZone();
    }

    @Test
    public void shouldAdaptSqlDate() {
        java.sql.Date sqlDate = this.createSqlDate(2014, Month.SEPTEMBER, 8);
        ZonedDateTime expectedDateInTargetTZ = ZonedDateTime.ofInstant(Instant.ofEpochMilli(sqlDate.getTime()), this.adapter.targetZoneId());
        ZonedDateTime zdt = this.adapter.toZonedDateTime(sqlDate);
        LocalDate date = zdt.toLocalDate();
        Assertions.assertThat((int)date.getYear()).isEqualTo(2014);
        Assertions.assertThat((Object)date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
        Assertions.assertThat((int)date.getDayOfMonth()).isEqualTo(expectedDateInTargetTZ.get(ChronoField.DAY_OF_MONTH));
        LocalTime time = zdt.toLocalTime();
        Assertions.assertThat((int)time.getHour()).isEqualTo(0);
        Assertions.assertThat((int)time.getMinute()).isEqualTo(0);
        Assertions.assertThat((int)time.getSecond()).isEqualTo(0);
        Assertions.assertThat((int)time.getNano()).isEqualTo(0);
        Assertions.assertThat((Object)zdt.getZone()).isEqualTo((Object)this.adapter.targetZoneId());
    }

    @Test
    public void shouldAdaptSqlTime() {
        Time sqlTime = this.createSqlTime(17, 51, 4, 777);
        ZonedDateTime zdt = this.adapter.toZonedDateTime(sqlTime);
        LocalDate date = zdt.toLocalDate();
        Assertions.assertThat((int)date.getYear()).isEqualTo(1970);
        Assertions.assertThat((Object)date.getMonth()).isEqualTo((Object)Month.JANUARY);
        Assertions.assertThat((int)date.getDayOfMonth()).isEqualTo(1);
        LocalTime time = zdt.toLocalTime();
        Assertions.assertThat((int)time.getHour()).isEqualTo(17);
        Assertions.assertThat((int)time.getMinute()).isEqualTo(51);
        Assertions.assertThat((int)time.getSecond()).isEqualTo(4);
        Assertions.assertThat((int)time.getNano()).isEqualTo(777000000);
        Assertions.assertThat((Object)zdt.getZone()).isEqualTo((Object)this.adapter.targetZoneId());
    }

    @Test
    public void shouldAdaptSqlTimestamp() {
        this.adapter = TimeZoneAdapter.create().withLocalZoneForSqlTimestamp().withUtcTargetZone();
        Timestamp sqlTimestamp = this.createSqlTimestamp(2014, Month.SEPTEMBER, 8, 17, 51, 4, 777);
        ZonedDateTime zdt = this.adapter.toZonedDateTime(sqlTimestamp);
        LocalDate date = zdt.toLocalDate();
        Assertions.assertThat((int)date.getYear()).isEqualTo(2014);
        Assertions.assertThat((Object)date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
        Assertions.assertThat((int)date.getDayOfMonth()).isEqualTo(8);
        LocalTime time = zdt.toLocalTime();
        Assertions.assertThat((int)time.getHour()).isEqualTo(17);
        Assertions.assertThat((int)time.getMinute()).isEqualTo(51);
        Assertions.assertThat((int)time.getSecond()).isEqualTo(4);
        Assertions.assertThat((int)time.getNano()).isEqualTo(777000000);
        Assertions.assertThat((Object)zdt.getZone()).isEqualTo((Object)this.adapter.targetZoneId());
    }

    @Test
    public void shouldAdaptSqlTimestampViaSecondsAndMillis() {
        this.adapter = TimeZoneAdapter.create().withUtcZoneForSqlTimestamp().withUtcTargetZone();
        Timestamp sqlTimestamp = this.createSqlTimestamp(1410198664L, 777);
        ZonedDateTime zdt = this.adapter.toZonedDateTime(sqlTimestamp);
        LocalDate date = zdt.toLocalDate();
        Assertions.assertThat((int)date.getYear()).isEqualTo(2014);
        Assertions.assertThat((Object)date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
        Assertions.assertThat((int)date.getDayOfMonth()).isEqualTo(8);
        LocalTime time = zdt.toLocalTime();
        Assertions.assertThat((int)time.getHour()).isEqualTo(17);
        Assertions.assertThat((int)time.getMinute()).isEqualTo(51);
        Assertions.assertThat((int)time.getSecond()).isEqualTo(4);
        Assertions.assertThat((int)time.getNano()).isEqualTo(777000000);
        Assertions.assertThat((Object)zdt.getZone()).isEqualTo((Object)this.adapter.targetZoneId());
    }

    @Test
    public void shouldAdaptUtilDate() {
        Date utilDate = this.createUtilDate(2014, Month.SEPTEMBER, 8, 17, 51, 4, 777);
        ZonedDateTime zdt = this.adapter.toZonedDateTime(utilDate);
        LocalDate date = zdt.toLocalDate();
        Assertions.assertThat((int)date.getYear()).isEqualTo(2014);
        Assertions.assertThat((Object)date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
        Assertions.assertThat((int)date.getDayOfMonth()).isEqualTo(8);
        LocalTime time = zdt.toLocalTime();
        Assertions.assertThat((int)time.getHour()).isEqualTo(17);
        Assertions.assertThat((int)time.getMinute()).isEqualTo(51);
        Assertions.assertThat((int)time.getSecond()).isEqualTo(4);
        Assertions.assertThat((int)time.getNano()).isEqualTo(777000000);
        Assertions.assertThat((Object)zdt.getZone()).isEqualTo((Object)this.adapter.targetZoneId());
    }

    protected java.sql.Date createSqlDate(int year, Month month, int dayOfMonth) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month.getValue() - 1);
        cal.set(5, dayOfMonth);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    protected Time createSqlTime(int hourOfDay, int minute, int second, int milliseconds) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, milliseconds);
        return new Time(c.getTimeInMillis());
    }

    protected Timestamp createSqlTimestamp(long secondsFromEpoch, int millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(secondsFromEpoch * 1000L);
        c.set(14, millis);
        return new Timestamp(c.getTimeInMillis());
    }

    protected Timestamp createSqlTimestamp(int year, Month month, int dayOfMonth, int hourOfDay, int minute, int second, int milliseconds) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month.getValue() - 1);
        c.set(5, dayOfMonth);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, milliseconds);
        return new Timestamp(c.getTimeInMillis());
    }

    protected Date createUtilDate(int year, Month month, int dayOfMonth, int hourOfDay, int minute, int second, int milliseconds) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month.getValue() - 1);
        c.set(5, dayOfMonth);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, milliseconds);
        return c.getTime();
    }
}

