/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.relational.history.HistoryRecord;
import io.debezium.util.Collect;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class HistoryRecordTest {
    private Map<String, Object> source1;
    private Map<String, Object> position1;
    private HistoryRecord record1;
    private Map<String, Object> source2;
    private Map<String, Object> position2;
    private HistoryRecord record2;
    private Map<String, Object> source3;
    private Map<String, Object> position3;
    private HistoryRecord record3;

    @Before
    public void beforeEach() {
        this.source1 = Collect.linkMapOf((Object)"server", (Object)"abc");
        this.position1 = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"position", (Object)100L, (Object)"entry", (Object)1);
        this.record1 = new HistoryRecord(this.source1, this.position1, "db", "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );");
        this.source2 = Collect.linkMapOf((Object)"server", (Object)"abc");
        this.position2 = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"position", (Object)300L, (Object)"entry", (Object)2);
        this.record2 = new HistoryRecord(this.source2, this.position2, "db", "DROP TABLE foo;");
        this.source3 = Collect.linkMapOf((Object)"server", (Object)"xyx");
        this.position3 = Collect.linkMapOf((Object)"file", (Object)"y.log", (Object)"position", (Object)10000L, (Object)"entry", (Object)1);
        this.record3 = new HistoryRecord(this.source3, this.position3, "other", "DROP TABLE foo;");
    }

    @Test
    public void shouldConsiderOneSourceTheSame() {
        Assertions.assertThat((boolean)this.record1.hasSameSource(this.record1)).isTrue();
        Assertions.assertThat((boolean)this.record2.hasSameSource(this.record2)).isTrue();
        Assertions.assertThat((boolean)this.record3.hasSameSource(this.record3)).isTrue();
    }

    @Test
    public void shouldConsiderTwoDifferentSourcesNotSame() {
        Assertions.assertThat((boolean)this.record1.hasSameSource(null)).isFalse();
        Assertions.assertThat((boolean)this.record1.hasSameSource(this.record3)).isFalse();
        Assertions.assertThat((boolean)this.record2.hasSameSource(this.record3)).isFalse();
    }

    @Test
    public void shouldConsiderTwoDifferentSourcesTheSame() {
        Assertions.assertThat((boolean)this.record1.hasSameSource(this.record2)).isTrue();
    }

    @Test
    public void shouldConsiderOneDatabaseTheSame() {
        Assertions.assertThat((boolean)this.record1.hasSameDatabase(this.record1)).isTrue();
    }

    @Test
    public void shouldConsiderTwoDifferentDatabasesNotSame() {
        Assertions.assertThat((boolean)this.record1.hasSameDatabase(this.record3)).isFalse();
        Assertions.assertThat((boolean)this.record2.hasSameDatabase(this.record3)).isFalse();
    }

    @Test
    public void shouldCorrectlyComparePositions() {
        Assertions.assertThat((boolean)this.record1.isAtOrBefore(this.record1)).isTrue();
        Assertions.assertThat((boolean)this.record2.isAtOrBefore(this.record2)).isTrue();
        Assertions.assertThat((boolean)this.record1.isAtOrBefore(this.record2)).isTrue();
        Assertions.assertThat((boolean)this.record2.isAtOrBefore(this.record1)).isFalse();
    }
}

