/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.function.Predicates;
import java.util.function.Predicate;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class PredicatesTest {
    @Test
    public void shouldMatchCommaSeparatedRegexIncludes() {
        Predicate p = Predicates.includes((String)"1.*5,30");
        Assertions.assertThat((boolean)p.test("30")).isTrue();
        Assertions.assertThat((boolean)p.test("1005")).isTrue();
        Assertions.assertThat((boolean)p.test("105")).isTrue();
        Assertions.assertThat((boolean)p.test("15")).isTrue();
        Assertions.assertThat((boolean)p.test("215")).isFalse();
        Assertions.assertThat((boolean)p.test("150")).isFalse();
        Assertions.assertThat((boolean)p.test("015")).isFalse();
        Assertions.assertThat((boolean)p.test("5")).isFalse();
    }

    @Test
    public void shouldMatchCommaSeparatedLiteralIncludes() {
        Predicate p = Predicates.includes((String)"1,2,3,4,5", i -> i.toString());
        Assertions.assertThat((boolean)p.test(1)).isTrue();
        Assertions.assertThat((boolean)p.test(2)).isTrue();
        Assertions.assertThat((boolean)p.test(3)).isTrue();
        Assertions.assertThat((boolean)p.test(4)).isTrue();
        Assertions.assertThat((boolean)p.test(5)).isTrue();
        Assertions.assertThat((boolean)p.test(0)).isFalse();
        Assertions.assertThat((boolean)p.test(6)).isFalse();
        Assertions.assertThat((boolean)p.test(-1)).isFalse();
    }

    @Test
    public void shouldMatchCommaSeparatedLiteralExcludes() {
        Predicate p = Predicates.excludes((String)"1,2,3,4,5", i -> i.toString());
        Assertions.assertThat((boolean)p.test(1)).isFalse();
        Assertions.assertThat((boolean)p.test(2)).isFalse();
        Assertions.assertThat((boolean)p.test(3)).isFalse();
        Assertions.assertThat((boolean)p.test(4)).isFalse();
        Assertions.assertThat((boolean)p.test(5)).isFalse();
        Assertions.assertThat((boolean)p.test(0)).isTrue();
        Assertions.assertThat((boolean)p.test(6)).isTrue();
        Assertions.assertThat((boolean)p.test(-1)).isTrue();
    }
}

