/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StringsTest {
    public void compareSeparatedLines(Object ... lines) {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(content);
        for (Object line : lines) {
            stream.println(line);
        }
        List actualLines = Strings.splitLines((String)content.toString());
        Assert.assertArrayEquals((Object[])lines, (Object[])actualLines.toArray());
    }

    @Test
    public void splitLinesShouldWorkCorrectly() {
        this.compareSeparatedLines("Line 1", "Line 2", "Line 3", "Line 4");
    }

    @Test
    public void setLengthShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.setLength((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.setLength((String)"This", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldNotRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)" This     ", (Object)Strings.setLength((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"\tThis     ", (Object)Strings.setLength((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength((String)"", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength(null, (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.setLength((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyLeftShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyLeft((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft(null, (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyLeft((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyRightShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)" is the string", (Object)Strings.justifyRight((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"      This", (Object)Strings.justifyRight((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight(null, (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyRight((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyCenterShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyCenter((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependAndAppendSameNumberOfCharacterForStringsThatAreTooShortButOfAnEvenLength() {
        Assert.assertEquals((Object)"   This   ", (Object)Strings.justifyCenter((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependOneMoreCharacterThanAppendingForStringsThatAreTooShortButOfAnOddLength() {
        Assert.assertEquals((Object)"   Thing  ", (Object)Strings.justifyCenter((String)"Thing", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter(null, (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyCenter((String)"This is the string", (int)18, (char)' '));
    }
}

