/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TableTest {
    private final TableId id = new TableId("catalog", "schema", "table");
    private Table table;
    private Column c1;
    private Column c2;
    private Column c3;
    private Column c4;

    @Before
    public void beforeEach() {
        this.table = Table.editor().tableId(this.id).addColumns(new Column[]{Column.editor().name("C1").typeName("VARCHAR").jdbcType(12).length(10).generated(true).optional(false).create(), Column.editor().name("C2").typeName("NUMBER").jdbcType(2).length(5).optional(false).create(), Column.editor().name("C3").typeName("DATE").jdbcType(91).length(4).optional(true).create(), Column.editor().name("C4").typeName("COUNTER").jdbcType(4).autoIncremented(true).optional(true).create()}).setPrimaryKeyNames(new String[]{"C1", "C2"}).create();
        this.c1 = this.table.columnWithName("C1");
        this.c2 = this.table.columnWithName("C2");
        this.c3 = this.table.columnWithName("C3");
        this.c4 = this.table.columnWithName("C4");
    }

    @Test
    public void checkPreconditions() {
        Assertions.assertThat((Object)this.c1).isNotNull();
        Assertions.assertThat((Object)this.c2).isNotNull();
        Assertions.assertThat((Object)this.c3).isNotNull();
        Assertions.assertThat((Object)this.c4).isNotNull();
    }

    @Test
    public void shouldHaveColumnsWithNames() {
        Assertions.assertThat((String)this.c1.name()).isEqualTo((Object)"C1");
        Assertions.assertThat((String)this.c2.name()).isEqualTo((Object)"C2");
        Assertions.assertThat((String)this.c3.name()).isEqualTo((Object)"C3");
        Assertions.assertThat((String)this.c4.name()).isEqualTo((Object)"C4");
    }

    @Test
    public void shouldHaveColumnsWithProperPositions() {
        Assertions.assertThat((int)this.c1.position()).isEqualTo(1);
        Assertions.assertThat((int)this.c2.position()).isEqualTo(2);
        Assertions.assertThat((int)this.c3.position()).isEqualTo(3);
        Assertions.assertThat((int)this.c4.position()).isEqualTo(4);
    }

    @Test
    public void shouldHaveTableId() {
        Assertions.assertThat((Object)this.table.id()).isEqualTo((Object)this.id);
    }

    @Test
    public void shouldHaveColumns() {
        Assertions.assertThat((List)this.table.columnNames()).containsExactly(new Object[]{"C1", "C2", "C3", "C4"});
        Assertions.assertThat((List)this.table.columns()).containsExactly(new Object[]{this.c1, this.c2, this.c3, this.c4});
    }

    @Test
    public void shouldHaveColumnsThatAreNotPartOfThePrimaryKey() {
        Assertions.assertThat((List)this.table.nonPrimaryKeyColumns()).containsExactly(new Object[]{this.c3, this.c4});
    }

    @Test
    public void shouldFindColumnsByNameWithExactCase() {
        Assertions.assertThat((Object)this.table.columnWithName("C1")).isSameAs((Object)this.c1);
        Assertions.assertThat((Object)this.table.columnWithName("C2")).isSameAs((Object)this.c2);
        Assertions.assertThat((Object)this.table.columnWithName("C3")).isSameAs((Object)this.c3);
        Assertions.assertThat((Object)this.table.columnWithName("C4")).isSameAs((Object)this.c4);
    }

    @Test
    public void shouldFindColumnsByNameWithWrongCase() {
        Assertions.assertThat((Object)this.table.columnWithName("c1")).isSameAs((Object)this.c1);
        Assertions.assertThat((Object)this.table.columnWithName("c2")).isSameAs((Object)this.c2);
        Assertions.assertThat((Object)this.table.columnWithName("c3")).isSameAs((Object)this.c3);
        Assertions.assertThat((Object)this.table.columnWithName("c4")).isSameAs((Object)this.c4);
    }

    @Test
    public void shouldNotFindNonExistantColumnsByName() {
        Assertions.assertThat((Object)this.table.columnWithName("c1 ")).isNull();
        Assertions.assertThat((Object)this.table.columnWithName("wrong")).isNull();
    }

    @Test
    public void shouldHavePrimaryKeyColumns() {
        Assertions.assertThat((List)this.table.primaryKeyColumnNames()).containsExactly(new Object[]{"C1", "C2"});
        Assertions.assertThat((List)this.table.primaryKeyColumns()).containsExactly(new Object[]{this.c1, this.c2});
    }

    @Test
    public void shouldDetermineIfColumnIsPartOfPrimaryKeyUsingColumnNameWithExactMatch() {
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("C1")).isTrue();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("C2")).isTrue();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("C3")).isFalse();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("C4")).isFalse();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("non-existant")).isFalse();
    }

    @Test
    public void shouldDetermineIfColumnIsPartOfPrimaryKeyUsingColumnNameWithWrongCase() {
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("c1")).isTrue();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("c2")).isTrue();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("c3")).isFalse();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("c4")).isFalse();
        Assertions.assertThat((boolean)this.table.isPrimaryKeyColumn("non-existant")).isFalse();
    }

    @Test
    public void shouldDetermineIfColumnIsGeneratedUsingColumnName() {
        Assertions.assertThat((boolean)this.table.isGenerated("C1")).isTrue();
        Assertions.assertThat((boolean)this.table.isGenerated("C2")).isFalse();
        Assertions.assertThat((boolean)this.table.isGenerated("C3")).isFalse();
        Assertions.assertThat((boolean)this.table.isGenerated("C4")).isFalse();
        Assertions.assertThat((boolean)this.table.isGenerated("non-existant")).isFalse();
    }

    @Test
    public void shouldDetermineIfColumnIsAutoIncrementedUsingColumnName() {
        Assertions.assertThat((boolean)this.table.isAutoIncremented("C1")).isFalse();
        Assertions.assertThat((boolean)this.table.isAutoIncremented("C2")).isFalse();
        Assertions.assertThat((boolean)this.table.isAutoIncremented("C3")).isFalse();
        Assertions.assertThat((boolean)this.table.isAutoIncremented("C4")).isTrue();
        Assertions.assertThat((boolean)this.table.isAutoIncremented("non-existant")).isFalse();
    }

    @Test
    public void shouldDetermineIfColumnIsOptionalUsingColumnName() {
        Assertions.assertThat((boolean)this.table.isOptional("C1")).isFalse();
        Assertions.assertThat((boolean)this.table.isOptional("C2")).isFalse();
        Assertions.assertThat((boolean)this.table.isOptional("C3")).isTrue();
        Assertions.assertThat((boolean)this.table.isOptional("C4")).isTrue();
        Assertions.assertThat((boolean)this.table.isOptional("non-existant")).isFalse();
    }

    @Test
    public void shouldFilterColumnsUsingPredicate() {
        Assertions.assertThat((List)this.table.filterColumns(c -> c.isAutoIncremented())).containsExactly(new Object[]{this.c4});
        Assertions.assertThat((List)this.table.filterColumns(c -> c.isGenerated())).containsExactly(new Object[]{this.c1});
        Assertions.assertThat((List)this.table.filterColumns(c -> c.isOptional())).containsExactly(new Object[]{this.c3, this.c4});
    }

    @Test
    public void shouldHaveToStringMethod() {
        String msg = this.table.toString();
        Assertions.assertThat((String)msg).isNotNull();
        Assertions.assertThat((String)msg).isNotEmpty();
    }
}

