/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Document;
import io.debezium.document.JacksonReader;
import io.debezium.document.JacksonWriter;
import io.debezium.util.Testing;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class JacksonWriterTest
implements Testing {
    private Document doc;
    private Document after;
    private JacksonWriter writer = JacksonWriter.INSTANCE;
    private JacksonReader reader = JacksonReader.INSTANCE;

    @Before
    public void beforeEach() {
        this.doc = Document.create();
        this.after = null;
    }

    @Test
    public void shouldWriteDocumentWithSingleField() throws Exception {
        this.doc.set((CharSequence)"field", (Object)"value");
        this.after = this.reader.read(this.writer.write(this.doc));
        Assertions.assertThat((String)this.after.getString((CharSequence)"field")).isEqualTo((Object)"value");
        Assertions.assertThat((int)this.after.size()).isEqualTo(1);
    }

    @Test
    public void shouldWriteDocumentWithTwoFields() throws Exception {
        this.doc.set((CharSequence)"field1", (Object)"value");
        this.doc.set((CharSequence)"field2", (Object)22);
        this.after = this.reader.read(this.writer.write(this.doc));
        Assertions.assertThat((String)this.after.getString((CharSequence)"field1")).isEqualTo((Object)"value");
        Assertions.assertThat((Integer)this.after.getInteger((CharSequence)"field2")).isEqualTo(22);
        Assertions.assertThat((int)this.after.size()).isEqualTo(2);
    }

    @Test
    public void shouldWriteDocumentWithNestedDocument() throws Exception {
        this.doc.set((CharSequence)"field1", (Object)"value");
        this.doc.set((CharSequence)"field2", (Object)22);
        this.doc.set((CharSequence)"field3", (Object)Document.create((CharSequence)"a", (Object)"A", (CharSequence)"b", (Object)"B"));
        this.after = this.reader.read(this.writer.write(this.doc));
        Testing.print(this.after);
        Assertions.assertThat((String)this.after.getString((CharSequence)"field1")).isEqualTo((Object)"value");
        Assertions.assertThat((Integer)this.after.getInteger((CharSequence)"field2")).isEqualTo(22);
        Assertions.assertThat((int)this.after.size()).isEqualTo(3);
        Document nested = this.after.getDocument((CharSequence)"field3");
        Assertions.assertThat((String)nested.getString((CharSequence)"a")).isEqualTo((Object)"A");
        Assertions.assertThat((String)nested.getString((CharSequence)"b")).isEqualTo((Object)"B");
        Assertions.assertThat((int)nested.size()).isEqualTo(2);
    }

    @Test
    public void shouldWriteDocumentWithDeeplyNestedDocument() throws Exception {
        this.doc.set((CharSequence)"field1", (Object)"value");
        this.doc.set((CharSequence)"field2", (Object)22);
        this.doc.set((CharSequence)"field3", (Object)Document.create((CharSequence)"a", (Object)"A", (CharSequence)"b", (Object)"B", (CharSequence)"c", (Object)Document.create((CharSequence)"x", (Object)"X")));
        this.after = this.reader.read(this.writer.write(this.doc));
        Testing.print(this.after);
        Assertions.assertThat((String)this.after.getString((CharSequence)"field1")).isEqualTo((Object)"value");
        Assertions.assertThat((Integer)this.after.getInteger((CharSequence)"field2")).isEqualTo(22);
        Assertions.assertThat((int)this.after.size()).isEqualTo(3);
        Document nested = this.after.getDocument((CharSequence)"field3");
        Assertions.assertThat((String)nested.getString((CharSequence)"a")).isEqualTo((Object)"A");
        Assertions.assertThat((String)nested.getString((CharSequence)"b")).isEqualTo((Object)"B");
        Assertions.assertThat((int)nested.size()).isEqualTo(3);
        Document deepNested = nested.getDocument((CharSequence)"c");
        Assertions.assertThat((String)deepNested.getString((CharSequence)"x")).isEqualTo((Object)"X");
        Assertions.assertThat((int)deepNested.size()).isEqualTo(1);
    }
}

