/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.doc.FixFor;
import io.debezium.function.Predicates;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.DatabaseHistory;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigValue;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationTest {
    private Configuration config;

    @Before
    public void beforeEach() {
        this.config = ((Configuration.Builder)Configuration.create().with("A", "a").with("B", "b").with("1", 1)).build();
    }

    @Test
    public void shouldConvertFromProperties() {
        Properties props = new Properties();
        props.setProperty("A", "a");
        props.setProperty("B", "b");
        props.setProperty("1", "1");
        this.config = Configuration.from((Properties)props);
        Assertions.assertThat((String)this.config.getString("A")).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.config.getString("B")).isEqualTo((Object)"b");
        Assertions.assertThat((String)this.config.getString("1")).isEqualTo((Object)"1");
        Assertions.assertThat((Integer)this.config.getInteger("1")).isEqualTo(1);
        Assertions.assertThat((Boolean)this.config.getBoolean("1")).isNull();
    }

    @Test
    public void shouldCreateInternalFields() {
        this.config = ((Configuration.Builder)Configuration.create().with(Field.createInternal((String)"a"), "a1")).build();
        Assertions.assertThat((String)this.config.getString("internal.a")).isEqualTo((Object)"a1");
    }

    @Test
    public void shouldCallFunctionOnEachMatchingFieldUsingRegex() {
        this.config = Configuration.create().with("column.truncate.to.-10.chars", "should-not-be-matched").with("column.truncate.to.10.chars", "10-chars").with("column.truncate.to.20.chars", "20-chars").with("column.mask.with.20.chars", "20-mask").with("column.mask.with.0.chars", "0-mask").with("column.mask.with.chars", "should-not-be-matched").build();
        AtomicInteger counter = new AtomicInteger();
        this.config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-chars"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldNameWithInteger("column.mask.with.(\\d+).chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-mask"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.mask.with.(\\d+).chars", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith("column.mask.with.");
            Assertions.assertThat((String)name).endsWith(".chars");
            Assertions.assertThat((String)value).endsWith("-mask");
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.*", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith("column.");
            Assertions.assertThat((String)name).endsWith(".chars");
            Assertions.assertThat((String)value).isNotNull();
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(6);
    }

    @Test
    public void shouldMaskPasswords() {
        Pattern p = Pattern.compile(".*password$", 2);
        Assertions.assertThat((boolean)p.matcher("password").matches()).isTrue();
        Assertions.assertThat((boolean)p.matcher("otherpassword").matches()).isTrue();
        this.config = Configuration.create().with("column.password", "warning").with("column.Password.this.is.not", "value").with("column.truncate.to.20.chars", "20-chars").with("column.mask.with.20.chars", "20-mask").with("column.mask.with.0.chars", "0-mask").with("column.mask.with.chars", "should-not-be-matched").build();
        Assertions.assertThat((boolean)this.config.withMaskedPasswords().toString().contains("warning")).isFalse();
        Assertions.assertThat((boolean)this.config.toString().contains("warning")).isFalse();
        Assertions.assertThat((String)this.config.withMaskedPasswords().getString("column.password")).isEqualTo((Object)"********");
        Assertions.assertThat((String)this.config.getString("column.password")).isEqualTo((Object)"warning");
    }

    @Test
    @FixFor(value={"DBZ-469"})
    public void defaultDdlFilterShouldFilterOutRdsHeartbeatInsert() {
        String defaultDdlFilter = Configuration.create().build().getString(DatabaseHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter);
        Assertions.assertThat((boolean)ddlFilter.test("INSERT INTO mysql.rds_heartbeat2(id, value) values (1,1510678117058) ON DUPLICATE KEY UPDATE value = 1510678117058")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-661"})
    public void defaultDdlFilterShouldFilterOutFlushRelayLogs() {
        String defaultDdlFilter = Configuration.create().build().getString(DatabaseHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter);
        Assertions.assertThat((boolean)ddlFilter.test("FLUSH RELAY LOGS")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void testMsgKeyColumnsField() {
        this.config = Configuration.create().build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isNotEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1,C2;t2:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;(.*).t2:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1,t2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isNotEmpty();
    }
}

