/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.SkipLongRunning;
import io.debezium.junit.SkipOnOS;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestRule
extends AnnotationBasedTestRule {
    public Statement apply(Statement base, Description description) {
        String skipLongRunning;
        SkipLongRunning skipLongRunningAnnotation = this.hasAnnotation(description, SkipLongRunning.class);
        if (skipLongRunningAnnotation != null && ((skipLongRunning = System.getProperty("skipLongRunningTests")) == null || Boolean.valueOf(skipLongRunning).booleanValue())) {
            return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
        }
        SkipOnOS skipOnOSAnnotation = this.hasAnnotation(description, SkipOnOS.class);
        if (skipOnOSAnnotation != null) {
            String[] oses = skipOnOSAnnotation.value();
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.trim().isEmpty()) {
                for (String os : oses) {
                    if (!osName.toLowerCase().startsWith(os.toLowerCase())) continue;
                    return SkipTestRule.emptyStatement(skipOnOSAnnotation.description(), description);
                }
            }
        }
        return base;
    }
}

