/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.Arrays;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TokenStreamTest {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 4;
    public static final int SINGLE_QUOTED_STRING = 8;
    public static final int DOUBLE_QUOTED_STRING = 16;
    public static final int COMMENT = 32;
    private TokenStream.Tokenizer tokenizer;
    private String content;
    private TokenStream tokens;

    @Before
    public void beforeEach() {
        this.tokenizer = TokenStream.basicTokenizer((boolean)false);
        this.content = "Select all columns from this table";
        this.makeCaseInsensitive();
    }

    public void makeCaseSensitive() {
        this.tokens = new TokenStream(this.content, this.tokenizer, true);
        this.tokens.start();
    }

    public void makeCaseInsensitive() {
        this.tokens = new TokenStream(this.content, this.tokenizer, false);
        this.tokens.start();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowConsumeBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.consume("Select");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowHasNextBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.hasNext();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowMatchesBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.matches("Select");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowCanConsumeBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.canConsume("Select");
    }

    @Test
    public void shouldReturnTrueFromHasNextIfThereIsACurrentToken() {
        this.content = "word";
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.currentToken().matches("word")).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isTrue();
    }

    @Test
    public void shouldConsumeInCaseSensitiveMannerWithExpectedValuesWhenMatchingExactCase() {
        this.makeCaseSensitive();
        this.tokens.consume("Select");
        this.tokens.consume("all");
        this.tokens.consume("columns");
        this.tokens.consume("from");
        this.tokens.consume("this");
        this.tokens.consume("table");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToConsumeInCaseSensitiveMannerWithExpectedValuesWhenMatchingIncorrectCase() {
        this.makeCaseSensitive();
        this.tokens.consume("Select");
        this.tokens.consume("all");
        this.tokens.consume("Columns");
    }

    @Test
    public void shouldConsumeInCaseInsensitiveMannerWithExpectedValuesWhenMatchingNonExactCase() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT");
        this.tokens.consume("ALL");
        this.tokens.consume("COLUMNS");
        this.tokens.consume("FROM");
        this.tokens.consume("THIS");
        this.tokens.consume("TABLE");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToConsumeInCaseInsensitiveMannerWithExpectedValuesWhenMatchingStringIsInLowerCase() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT");
        this.tokens.consume("ALL");
        this.tokens.consume("columns");
    }

    @Test
    public void shouldHandleNonAsciiCharactersWhenCaseSensitive() {
        this.content = "\u00fc and";
        this.makeCaseSensitive();
        this.tokens.consume("\u00fc");
        this.tokens.consume("and");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldHandle\u00dfCharacterWhenCaseSensitive() {
        this.content = "\u00df and";
        this.makeCaseSensitive();
        this.tokens.consume("\u00df");
        this.tokens.consume("and");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldConsumeCaseInsensitiveStringInOriginalCase() {
        this.makeCaseInsensitive();
        String firstToken = this.tokens.consume();
        Assertions.assertThat((String)firstToken).isEqualTo((Object)"Select");
    }

    @Test
    public void shouldMatchUpperCaseVersionOf\u00dfCharacterWhenCaseInsensitive() {
        this.content = "\u00df";
        this.makeCaseInsensitive();
        this.tokens.consume("SS");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldHandleTokensAfter\u00dfCharacterWhenCaseInsensitive() {
        this.content = "\u00df and";
        this.makeCaseInsensitive();
        this.tokens.consume("any value");
        this.tokens.consume("AND");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("Select")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("all")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("columns")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("from")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("this")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("table")).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseSensitiveTokenStreamIfMatchStringDoesNotMatchCaseExactly() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("Select")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("all")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("Columns")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("COLUMNS")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("columns")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("from")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("THIS")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("table")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("this")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("table")).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseSensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseSensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(32)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(8)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(16)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(4)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(2)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromMatchesWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.matches("Select")).isTrue();
        Assertions.assertThat((boolean)this.tokens.matches("select")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("Select")).isTrue();
        Assertions.assertThat((boolean)this.tokens.matches("all")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("all")).isTrue();
    }

    @Test
    public void shouldReturnFalseFromMatchesWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assertions.assertThat((boolean)this.tokens.matches("select")).isFalse();
        Assertions.assertThat((boolean)this.tokens.matches("SElect")).isFalse();
        Assertions.assertThat((boolean)this.tokens.matches("Select")).isTrue();
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseInsensitiveTokenStreamIfMatchStringIsNotUppercase() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("Select")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("aLL")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("all")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("ALL")).isTrue();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseInsensitiveTokenStreamIfMatchStringDoesNotMatchCaseExactly() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("ALL")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("COLUMNS")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("FROM")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("THIS")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("TABLE")).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseInsensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseInsensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(32)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(8)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(16)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(4)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(2)).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(1)).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromMatchesWithCaseInsensitiveTokenStreamIfMatchStringIsUppercaseAndMatches() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matches("SELECT")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isTrue();
        Assertions.assertThat((boolean)this.tokens.matches("ALL")).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("ALL")).isTrue();
    }

    @Test
    public void shouldReturnFalseFromMatchesWithCaseInsensitiveTokenStreamIfMatchStringIsUppercaseAndDoesNotMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matches("ALL")).isFalse();
        Assertions.assertThat((boolean)this.tokens.matches("SElect")).isFalse();
        Assertions.assertThat((boolean)this.tokens.matches("SELECT")).isTrue();
    }

    @Test
    public void shouldConsumeMultipleTokensIfTheyMatch() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE"});
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToConsumeMultipleTokensIfTheyDoNotMatch() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "TABLE"});
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensIfTheyAllMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeArrayOfTokensIfTheyAllMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matches(new String[]{"SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume(new String[]{"SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensIfTheyDoNotAllMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FRM", "THIS", "TABLE"})).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE", "EXTRA"})).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "EXTRA", "THIS", "TABLE"})).isFalse();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.canConsume("FROM", new String[]{"THIS", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromMatchAnyOfIfAnyOfTheTokenValuesMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS"})).isFalse();
        Assertions.assertThat((boolean)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"})).isTrue();
        this.tokens.consume("SELECT");
        Assertions.assertThat((boolean)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"})).isTrue();
        this.tokens.consume("ALL");
        Assertions.assertThat((boolean)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"})).isTrue();
        this.tokens.consume("COLUMNS");
        Assertions.assertThat((boolean)this.tokens.canConsume("FROM", new String[]{"THIS", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromMatchIfAllTypeValuesMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matches(1, new int[]{1})).isTrue();
    }

    @Test
    public void shouldReturnFalseFromMatchIfAllTypeValuesDoNotMatch() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.matches(1, new int[]{4})).isFalse();
        Assertions.assertThat((boolean)this.tokens.matches(4, new int[]{1})).isFalse();
    }

    @Test
    public void shouldConsumeMultipleTokensWithAnyValueConstant() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "any value"});
        this.tokens.consume("FROM", new String[]{"THIS", "TABLE"});
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldConsumeTokenWithAnyValueConstant() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL"});
        this.tokens.consume("any value");
        this.tokens.consume("FROM", new String[]{"THIS", "TABLE"});
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensWithAnyValueConstant() {
        this.makeCaseInsensitive();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "any value", "FRM", "THIS", "TABLE"})).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "any value", "TABLE"})).isTrue();
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldCanConsumeSingleAfterTokensCompleteFromCanConsumeStringList() {
        this.makeCaseInsensitive();
        this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE"});
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("any value")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(2)).isFalse();
    }

    @Test
    public void shouldCanConsumeStringAfterTokensCompleteFromCanConsumeStringArray() {
        this.makeCaseInsensitive();
        this.tokens.canConsume(new String[]{"SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"});
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("any value")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(2)).isFalse();
    }

    @Test
    public void shouldCanConsumeStringAfterTokensCompleteFromCanConsumeStringIterator() {
        this.makeCaseInsensitive();
        this.tokens.canConsume(Arrays.asList("SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"));
        Assertions.assertThat((boolean)this.tokens.canConsume("SELECT")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume("any value")).isFalse();
        Assertions.assertThat((boolean)this.tokens.canConsume(2)).isFalse();
    }

    @Test
    public void shouldFindNextPositionStartIndex() {
        this.makeCaseInsensitive();
        this.tokens.consume();
        Assertions.assertThat((int)this.tokens.nextPosition().index()).isEqualTo(7);
        Assertions.assertThat((int)this.tokens.nextPosition().column()).isEqualTo(8);
        Assertions.assertThat((int)this.tokens.nextPosition().line()).isEqualTo(1);
    }

    @Test
    public void shouldFindPreviousPositionStartIndex() {
        this.makeCaseInsensitive();
        this.tokens.consume();
        this.tokens.consume();
        Assertions.assertThat((int)this.tokens.previousPosition().index()).isEqualTo(7);
        Assertions.assertThat((int)this.tokens.previousPosition().column()).isEqualTo(8);
        Assertions.assertThat((int)this.tokens.previousPosition().line()).isEqualTo(1);
    }

    @Test
    public void shouldParseMultiLineString() {
        this.makeCaseInsensitive();
        String content = "ALTER DATABASE \nDO SOMETHING; \nALTER DATABASE \n      SET DEFAULT BIGFILE TABLESPACE;";
        this.tokens = new TokenStream(content, this.tokenizer, true);
        this.tokens.start();
        this.tokens.consume();
        this.tokens.consume();
        this.tokens.consume();
        this.tokens.consume();
        this.tokens.consume();
        Assertions.assertThat((int)this.tokens.nextPosition().index()).isEqualTo(31);
        Assertions.assertThat((int)this.tokens.nextPosition().column()).isEqualTo(1);
        this.tokens.consume();
        Assertions.assertThat((int)this.tokens.nextPosition().index()).isEqualTo(37);
        Assertions.assertThat((int)this.tokens.nextPosition().column()).isEqualTo(7);
    }

    @Test
    public void shouldConsumeUntilWithoutRepeats() {
        this.makeCaseInsensitive();
        String content = "FOO BEGIN A1 A2 A3 END BAR";
        this.tokens = new TokenStream(content, this.tokenizer, true);
        this.tokens.start();
        this.tokens.consume();
        this.tokens.consume("BEGIN");
        this.tokens.consumeUntil("END");
        this.tokens.consume("END");
        this.tokens.consume("BAR");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldConsumeUntilWithRepeats() {
        this.makeCaseInsensitive();
        String content = "FOO BEGIN A1 A2 A3 BEGIN B1 B2 END A4 BEGIN C1 C2 END A5 END BAR";
        this.tokens = new TokenStream(content, this.tokenizer, true);
        this.tokens.start();
        this.tokens.consume();
        this.tokens.consume("BEGIN");
        this.tokens.consumeUntil("END", new String[]{"BEGIN"});
        this.tokens.consume("END");
        this.tokens.consume("BAR");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }

    @Test
    public void shouldConsumeUntilWithRepeatsAndMultipleSkipTokens() {
        this.makeCaseInsensitive();
        String content = "FOO BEGIN A1 A2 A3 IF B1 B2 END A4 REPEAT C1 C2 END A5 END BAR";
        this.tokens = new TokenStream(content, this.tokenizer, true);
        this.tokens.start();
        this.tokens.consume();
        this.tokens.consume("BEGIN");
        this.tokens.consumeUntil("END", new String[]{"BEGIN", "IF", "REPEAT"});
        this.tokens.consume("END");
        this.tokens.consume("BAR");
        Assertions.assertThat((boolean)this.tokens.hasNext()).isFalse();
    }
}

