/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.ddl.DdlParserSql2003;
import io.debezium.relational.ddl.LegacyDdlParser;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DdlChangesTest {
    private DdlChanges changes;
    private LegacyDdlParser parser;
    private Tables tables;

    @Before
    public void beforeEach() {
        this.changes = new DdlChanges();
        this.parser = new DdlParserSql2003();
        this.parser.addListener((DdlParserListener)this.changes);
        this.tables = new Tables();
    }

    @Test
    public void shouldParseMultipleStatementsWithDefaultDatabase() {
        this.parser.setCurrentSchema("mydb");
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator() + "-- This is a comment" + System.lineSeparator() + "DROP TABLE foo;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        this.changes.groupEventsByDatabase((dbName, list) -> {
            Assertions.assertThat((String)dbName).isEqualTo((Object)"mydb");
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((Object)((DdlParserListener.Event)list.get(0)).type()).isEqualTo((Object)DdlParserListener.EventType.CREATE_TABLE);
            Assertions.assertThat((Object)((DdlParserListener.Event)list.get(1)).type()).isEqualTo((Object)DdlParserListener.EventType.DROP_TABLE);
        });
    }

    @Test
    public void shouldParseMultipleStatementsWithFullyQualifiedDatabase() {
        this.parser.setCurrentSchema("mydb");
        String ddl = "CREATE TABLE other.foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator() + "-- This is a comment" + System.lineSeparator() + "DROP TABLE other.foo;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        this.changes.groupEventsByDatabase((dbName, list) -> {
            Assertions.assertThat((String)dbName).isEqualTo((Object)"other");
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((Object)((DdlParserListener.Event)list.get(0)).type()).isEqualTo((Object)DdlParserListener.EventType.CREATE_TABLE);
            Assertions.assertThat((Object)((DdlParserListener.Event)list.get(1)).type()).isEqualTo((Object)DdlParserListener.EventType.DROP_TABLE);
        });
    }

    @Test
    public void shouldParseMultipleStatementsWithNoCurrentSchemaAndFullyQualifiedDatabase() {
        String ddl = "CREATE TABLE other.foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator() + "-- This is a comment" + System.lineSeparator() + "DROP TABLE other.foo;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
        for (int i = 0; i != 5; ++i) {
            this.changes.groupEventsByDatabase((dbName, list) -> {
                Assertions.assertThat((String)dbName).isEqualTo((Object)"other");
                Assertions.assertThat((int)list.size()).isEqualTo(2);
                Assertions.assertThat((Object)((DdlParserListener.Event)list.get(0)).type()).isEqualTo((Object)DdlParserListener.EventType.CREATE_TABLE);
                Assertions.assertThat((Object)((DdlParserListener.Event)list.get(1)).type()).isEqualTo((Object)DdlParserListener.EventType.DROP_TABLE);
            });
        }
        this.changes.reset();
        this.changes.groupEventsByDatabase((dbName, list) -> Assert.fail((String)"Should not have any changes"));
    }
}

