/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecord;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseHistory
implements DatabaseHistory {
    protected Configuration config;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractDatabaseHistory() {
    }

    @Override
    public void configure(Configuration config) {
        this.config = config;
    }

    @Override
    public void start() {
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, Tables schema, String ddl) {
        this.storeRecord(new HistoryRecord(source, position, databaseName, ddl));
    }

    @Override
    public final void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        HistoryRecord stopPoint = new HistoryRecord(source, position, null, null);
        this.recoverRecords(schema, ddlParser, recovered -> {
            String ddl;
            if (recovered.isAtOrBefore(stopPoint) && (ddl = recovered.ddl()) != null) {
                ddlParser.setCurrentSchema(recovered.databaseName());
                ddlParser.parse(ddl, schema);
            }
        });
    }

    protected abstract void storeRecord(HistoryRecord var1);

    protected abstract void recoverRecords(Tables var1, DdlParser var2, Consumer<HistoryRecord> var3);

    @Override
    public void stop() {
    }
}

