/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@NotThreadSafe
public class DdlParserSql2003
extends DdlParser {
    public DdlParserSql2003() {
        super(";");
    }

    public DdlParserSql2003(boolean includeViews) {
        super(";", includeViews);
    }

    @Override
    protected void initializeDataTypes(DataTypeParser dataTypes) {
        dataTypes.register(1, "CHARACTER[(L)]");
        dataTypes.register(1, "CHAR[(L)]");
        dataTypes.register(12, "CHARACTER VARYING [(L)]");
        dataTypes.register(12, "CHAR VARYING [(L)]");
        dataTypes.register(12, "VARCHAR[(L)]");
        dataTypes.register(2005, "CHARACTER LARGE OBJECT [(L)]");
        dataTypes.register(2005, "CHAR LARGE OBJECT [(L)]");
        dataTypes.register(2005, "CLOB[(L)]");
        dataTypes.register(-15, "NATIONAL CHARACTER[(L)]");
        dataTypes.register(-15, "NCHAR[(L)]");
        dataTypes.register(-9, "NATIONAL CHARACTER VARYING [(L)]");
        dataTypes.register(-9, "NCHAR VARYING [(L)]");
        dataTypes.register(-9, "NVARCHAR[(L)]");
        dataTypes.register(2011, "NATIONAL CHARACTER LARGE OBJECT [(L)]");
        dataTypes.register(2011, "NCHAR LARGE OBJECT [(L)]");
        dataTypes.register(2011, "NCLOB[(L)]");
        dataTypes.register(2004, "BINARY LARGE OBJECT [(L)]");
        dataTypes.register(2004, "BLOB[(L)]");
        dataTypes.register(2, "NUMERIC[(M[,D])]");
        dataTypes.register(3, "DECIMAL[(M[,D])]");
        dataTypes.register(3, "DEC[(M[,D])]");
        dataTypes.register(5, "SMALLINT");
        dataTypes.register(4, "INTEGER");
        dataTypes.register(4, "INT");
        dataTypes.register(-5, "BIGINT");
        dataTypes.register(6, "FLOAT[(M,D)]");
        dataTypes.register(8, "REAL[(M,D)]");
        dataTypes.register(8, "DOUBLE PRECISION [(M,D)]");
        dataTypes.register(16, "BOOLEAN");
        dataTypes.register(91, "DATE");
        dataTypes.register(92, "TIME[(L)] [WITHOUT TIME ZONE]");
        dataTypes.register(2013, "TIME[(L)] [WITH TIME ZONE]");
        dataTypes.register(93, "TIMESTAMP[(L)] [WITHOUT TIME ZONE]");
        dataTypes.register(2014, "TIMESTAMP[(L)] [WITH TIME ZONE]");
    }

    @Override
    protected void initializeKeywords(DdlParser.TokenSet keywords) {
    }

    @Override
    protected void initializeStatementStarts(DdlParser.TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", "ALTER", "DROP", "INSERT", "SET", "GRANT", "REVOKE");
    }

    @Override
    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else if (this.tokens.matches("INSERT")) {
            this.parseInsert(marker);
        } else if (this.tokens.matches("SET")) {
            this.parseSet(marker);
        } else if (this.tokens.matches("GRANT")) {
            this.parseGrant(marker);
        } else if (this.tokens.matches("REVOKE")) {
            this.parseRevoke(marker);
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    @Override
    protected void parseCreate(TokenStream.Marker marker) {
        this.tokens.consume("CREATE");
        this.tokens.canConsume("OR", "REPLACE");
        if (this.tokens.matches("TABLE") || this.tokens.matches("GLOBAL", "TEMPORARY", "TABLE") || this.tokens.matches("LOCAL", "TEMPORARY", "TABLE")) {
            this.parseCreateTable(marker);
            this.debugParsed(marker);
        } else if (this.tokens.matches("VIEW") || this.tokens.matches("RECURSIVE", "VIEW")) {
            this.parseCreateView(marker);
            this.debugParsed(marker);
        } else {
            this.parseCreateUnknown(marker);
        }
    }

    protected void parseCreateTable(TokenStream.Marker start) {
        this.tokens.canConsumeAnyOf("GLOBAL", "LOCAL", "TEMPORARY");
        this.tokens.consume("TABLE");
        TableId tableId = this.parseQualifiedTableName(start);
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches('(')) {
            TokenStream.Marker tableContentStart = this.tokens.mark();
            try {
                this.parseAsSubqueryClause(start, table);
            }
            catch (ParsingException e) {
                this.tokens.rewind(tableContentStart);
                this.parseTableElementList(start, table);
            }
        } else if (this.tokens.canConsume("OF")) {
            this.parseSchemaQualifiedName(start);
            if (this.tokens.canConsume("UNDER")) {
                this.parseSchemaQualifiedName(start);
            }
            if (this.tokens.matches('(')) {
                this.parseTableElementList(start, table);
            }
        } else if (this.tokens.canConsume("AS")) {
            this.parseAsSubqueryClause(start, table);
        }
        if (this.tokens.canConsume("ON", "COMMIT")) {
            this.tokens.canConsume("PRESERVE");
            this.tokens.canConsume("DELETE");
            this.tokens.consume("ROWS");
        }
        this.databaseTables.overwriteTable(table.create());
    }

    protected void parseAsSubqueryClause(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.canConsume('(')) {
            this.tokens.consume();
            while (this.tokens.canConsume(',')) {
                this.tokens.consume();
            }
            this.tokens.canConsume(')');
        }
        this.tokens.consume("AS", "(");
        this.tokens.consumeThrough(')', '(');
        this.tokens.consume("WITH");
        this.tokens.canConsume("NO");
        this.tokens.consume("DATA");
    }

    protected void parseTableElementList(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume('(');
        this.parseTableElement(start, table);
        while (this.tokens.canConsume(',')) {
            this.parseTableElement(start, table);
        }
        this.tokens.consume(')');
    }

    protected List<String> parseColumnNameList(TokenStream.Marker start) {
        ArrayList<String> names = new ArrayList<String>();
        this.tokens.consume('(');
        names.add(this.tokens.consume());
        while (this.tokens.canConsume(',')) {
            names.add(this.tokens.consume());
        }
        this.tokens.consume(')');
        return names;
    }

    protected void parseTableElement(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.matchesAnyOf("CONSTRAINT", "UNIQUE", "PRIMARY", "FOREIGN", "CHECK")) {
            this.parseTableConstraintDefinition(start, table);
        } else if (this.tokens.matches("LIKE")) {
            this.parseTableLikeClause(start, table);
        } else if (this.tokens.matches("REF", "IS")) {
            this.parseSelfReferencingColumnSpec(start, table);
        } else {
            String columnName = this.tokens.consume();
            Column existingColumn = table.columnWithName(columnName);
            ColumnEditor column = existingColumn != null ? existingColumn.edit() : Column.editor().name(columnName);
            AtomicBoolean isPrimaryKey = new AtomicBoolean(false);
            if (this.tokens.matches("WITH", "OPTIONS")) {
                this.parseColumnOptions(start, columnName, this.tokens, column);
            } else {
                this.parseColumnDefinition(start, columnName, this.tokens, table, column, isPrimaryKey);
            }
            Column newColumnDefn = column.create();
            table.addColumns(newColumnDefn);
            if (isPrimaryKey.get()) {
                table.setPrimaryKeyNames(newColumnDefn.name());
            }
        }
    }

    protected void parseTableConstraintDefinition(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.canConsume("CONSTRAINT")) {
            this.parseSchemaQualifiedName(start);
        }
        if (this.tokens.canConsume("UNIQUE", "(", "VALUE", ")")) {
            table.setUniqueValues();
        } else if (this.tokens.canConsume("UNIQUE") || this.tokens.canConsume("PRIMARY", "KEY")) {
            List<String> pkColumnNames = this.parseColumnNameList(start);
            table.setPrimaryKeyNames(pkColumnNames);
        } else if (this.tokens.canConsume("FOREIGN", "KEY")) {
            this.parseColumnNameList(start);
            this.tokens.consume("REFERENCES");
            this.parseSchemaQualifiedName(start);
            if (this.tokens.canConsume('(')) {
                this.parseColumnNameList(start);
            }
            if (this.tokens.canConsume("MATCH")) {
                this.tokens.consumeAnyOf("FULL", "PARTIAL", "SIMPLE");
                if (this.tokens.canConsume("ON")) {
                    this.parseReferentialTriggeredActions(start);
                }
            }
        } else if (this.tokens.canConsume("CHECK", "(")) {
            this.tokens.consumeThrough(')', '(');
        }
    }

    protected void parseReferentialTriggeredActions(TokenStream.Marker start) {
        this.tokens.consume("ON");
        if (this.tokens.canConsume("UPDATE")) {
            this.parseReferentialAction(start);
            if (this.tokens.canConsume("ON", "DELETE")) {
                this.parseReferentialAction(start);
            }
        } else if (this.tokens.canConsume("DELETE")) {
            this.parseReferentialAction(start);
            if (this.tokens.canConsume("ON", "UPDATE")) {
                this.parseReferentialAction(start);
            }
        }
    }

    protected void parseReferentialAction(TokenStream.Marker start) {
        if (!(this.tokens.canConsume("CASCADE") || this.tokens.canConsume("SET", "NULL") || this.tokens.canConsume("SET", "DEFAULT") || this.tokens.canConsume("RESTRICT"))) {
            this.tokens.consume("NO", "ACTION");
        }
    }

    protected void parseTableLikeClause(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("LIKE");
        this.consumeRemainingStatement(start);
    }

    protected void parseSelfReferencingColumnSpec(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("REF", "IS");
        this.consumeRemainingStatement(start);
    }

    protected void parseColumnOptions(TokenStream.Marker start, String columnName, TokenStream tokens, ColumnEditor column) {
        tokens.consume("WITH", "OPTIONS");
        this.consumeRemainingStatement(start);
    }

    protected void parseColumnDefinition(TokenStream.Marker start, String columnName, TokenStream tokens, TableEditor table, ColumnEditor column, AtomicBoolean isPrimaryKey) {
        String dataTypeName;
        ArrayList<ParsingException> errors = new ArrayList<ParsingException>();
        TokenStream.Marker dataTypeStart = tokens.mark();
        DataType dataType = this.dataTypeParser.parse(tokens, errors::addAll);
        if (dataType == null && (dataTypeName = this.parseDomainName(start)) != null) {
            dataType = DataType.userDefinedType(dataTypeName);
        }
        if (dataType == null) {
            this.parsingFailed(dataTypeStart.position(), errors, "Unable to read the data type");
            return;
        }
        column.jdbcType(dataType.jdbcType());
        column.typeName(dataType.name());
        if (dataType.length() > -1L) {
            column.length((int)dataType.length());
        }
        if (dataType.scale() > -1) {
            column.scale(dataType.scale());
        }
        if (tokens.matches("REFERENCES", "ARE")) {
            this.parseReferencesScopeCheck(start, columnName, tokens, column);
        }
        if (tokens.matches("DEFAULT")) {
            this.parseDefaultClause(start, column);
        } else if (tokens.matches("GENERATED")) {
            this.parseIdentityColumnSpec(start, column);
        }
        while (tokens.matchesAnyOf("NOT", "UNIQUE", "PRIMARY", "CHECK", "REFERENCES", "CONSTRAINT")) {
            this.parseColumnConstraintDefinition(start, column, isPrimaryKey);
        }
        if (tokens.canConsume("COLLATE")) {
            this.parseSchemaQualifiedName(start);
        }
    }

    protected void parseColumnConstraintDefinition(TokenStream.Marker start, ColumnEditor column, AtomicBoolean isPrimaryKey) {
        if (this.tokens.canConsume("CONSTRAINT")) {
            this.parseSchemaQualifiedName(start);
        }
        if (this.tokens.canConsume("NOT", "NULL")) {
            column.optional(false);
        } else if (this.tokens.canConsume("UNIQUE") || this.tokens.canConsume("PRIMARY", "KEY")) {
            isPrimaryKey.set(true);
        } else if (this.tokens.canConsume("REFERENCES", "ARE")) {
            this.tokens.canConsume("NOT");
            this.tokens.consume("CHECKED");
            if (this.tokens.matches("ON", "DELETE")) {
                this.parseReferentialAction(start);
            }
        } else if (this.tokens.canConsume("CHECK", "(")) {
            this.tokens.consumeThrough(')', '(');
        }
        this.parseColumnConstraintCharacteristics(start, column);
    }

    protected void parseColumnConstraintCharacteristics(TokenStream.Marker start, ColumnEditor column) {
        if (this.tokens.canConsume("INITIALLY")) {
            this.tokens.consumeAnyOf("DEFERRED", "IMMEDIATE");
            if (!this.tokens.canConsume("NOT", "DEFERRABLE") && this.tokens.canConsume("DEFERRABLE")) {
                // empty if block
            }
        } else if ((this.tokens.canConsume("NOT", "DEFERRABLE") || this.tokens.canConsume("DEFERRABLE")) && this.tokens.canConsume("INITIALLY")) {
            this.tokens.consumeAnyOf("DEFERRED", "IMMEDIATE");
        }
    }

    protected void parseIdentityColumnSpec(TokenStream.Marker start, ColumnEditor column) {
        column.generated(true);
        column.autoIncremented(true);
        column.optional(false);
        this.tokens.consume("GENERATED");
        if (this.tokens.canConsume("BY")) {
            this.tokens.consume("DEFAULT");
        } else {
            this.tokens.consume("ALWAYS");
            if (this.tokens.canConsume("AS", "(")) {
                this.tokens.consumeThrough(')', '(');
                return;
            }
        }
        this.tokens.consume("AS", "IDENTITY");
        if (this.tokens.canConsume('(')) {
            this.tokens.consumeThrough(')', '(');
        }
    }

    protected void parseDefaultClause(TokenStream.Marker start, ColumnEditor column) {
        this.tokens.consume("DEFAULT");
        if (!this.tokens.canConsume("CURRENT", "DATE")) {
            if (this.tokens.canConsume("CURRENT", "TIME") || this.tokens.canConsume("CURRENT", "TIMESTAMP") || this.tokens.canConsume("LOCALTIME") || this.tokens.canConsume("LOCALTIMESTAMP")) {
                if (this.tokens.canConsume('(')) {
                    this.tokens.consumeInteger();
                    this.tokens.consume(')');
                }
            } else if (!(this.tokens.canConsume("USER") || this.tokens.canConsume("CURRENT", "USER") || this.tokens.canConsume("CURRENT", "ROLE") || this.tokens.canConsume("SESSION", "USER") || this.tokens.canConsume("SYSTEM", "USER") || this.tokens.canConsume("CURRENT", "PATH") || this.tokens.canConsume("NULL") || this.tokens.canConsume("ARRAY", "[", "]") || this.tokens.canConsume("MULTISET", "[", "]"))) {
                this.parseLiteral(start);
            }
        }
    }

    protected String parseDomainName(TokenStream.Marker start) {
        return this.parseSchemaQualifiedName(start);
    }

    @Override
    protected Object parseLiteral(TokenStream.Marker start) {
        if (this.tokens.canConsume("INTERVAL")) {
            return this.parseIntervalLiteral(start);
        }
        return super.parseLiteral(start);
    }

    protected String parseIntervalLiteral(TokenStream.Marker start) {
        this.tokens.consume("INTERVAL");
        boolean negative = false;
        if (this.tokens.canConsume('+')) {
            negative = false;
        } else if (this.tokens.canConsume('-')) {
            negative = true;
        }
        String str = this.parseIntervalString(start);
        String qual = this.parseIntervalQualifier(start);
        return (negative ? "-" : "+") + str + " " + qual;
    }

    protected String parseIntervalString(TokenStream.Marker start) {
        return this.tokens.consumeAnyOf(8, 16);
    }

    protected String parseIntervalQualifier(TokenStream.Marker start) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tokens.consumeAnyOf("YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"));
        if (this.tokens.canConsume('(')) {
            int precision = this.tokens.consumeInteger();
            sb.append(" (").append(precision);
            if (this.tokens.canConsume(',')) {
                int scale = this.tokens.consumeInteger();
                sb.append(",").append(scale);
            }
            this.tokens.consume(')');
            sb.append(")");
        }
        if (this.tokens.canConsume("TO")) {
            sb.append(" TO ");
            sb.append(this.tokens.consumeAnyOf("YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"));
            if (this.tokens.canConsume('(')) {
                sb.append("(").append(this.tokens.consumeInteger()).append(")");
                this.tokens.consume(')');
            }
        }
        return sb.toString();
    }

    protected void parseReferencesScopeCheck(TokenStream.Marker start, String columnName, TokenStream tokens, ColumnEditor column) {
        tokens.consume("REFERENCES", "ARE");
        tokens.canConsume("NOT");
        tokens.consume("CHECKED");
        if (!(!tokens.canConsume("ON", "DELETE") || tokens.canConsume("CASCADE") || tokens.canConsume("SET", "NULL") || tokens.canConsume("SET", "DEFAULT") || tokens.canConsume("RESTRICT"))) {
            tokens.consume("NO", "ACTION");
        }
    }

    protected void parseCreateView(TokenStream.Marker start) {
        if (this.skipViews) {
            this.consumeRemainingStatement(start);
            this.debugSkipped(start);
            return;
        }
        this.tokens.canConsume("RECURSIVE");
        this.tokens.consume("VIEW");
        TableId tableId = this.parseQualifiedTableName(start);
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        List<String> columnNames = null;
        if (this.tokens.canConsume("OF")) {
            this.parseSchemaQualifiedName(start);
            if (this.tokens.canConsume("UNDER")) {
                this.parseSchemaQualifiedName(start);
            }
            if (this.tokens.matches('(')) {
                columnNames = this.parseColumnNameList(start);
            }
        } else if (this.tokens.matches('(')) {
            columnNames = this.parseColumnNameList(start);
        }
        this.tokens.canConsume("AS");
        this.consumeRemainingStatement(start);
        if (columnNames != null) {
            columnNames.forEach(name -> table.addColumn(Column.editor().name((String)name).create()));
        }
        this.databaseTables.overwriteTable(table.create());
    }

    protected void parseCreateUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
    }

    @Override
    protected void parseAlter(TokenStream.Marker marker) {
        this.tokens.consume("ALTER");
        if (this.tokens.matches("TABLE") || this.tokens.matches("IGNORE", "TABLE")) {
            this.parseAlterTable(marker);
            this.debugParsed(marker);
        } else {
            this.parseAlterUnknown(marker);
        }
    }

    protected void parseAlterTable(TokenStream.Marker start) {
        this.tokens.canConsume("IGNORE");
        this.tokens.consume("TABLE");
        TableId tableId = this.parseQualifiedTableName(start);
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches("ADD", "CONSTRAINT") || this.tokens.matches("ADD", "UNIQUE") || this.tokens.matches("ADD", "PRIMARY") || this.tokens.matches("ADD", "FOREIGN") || this.tokens.matches("ADD", "CHECK")) {
            this.tokens.consume("ADD");
            this.parseTableConstraintDefinition(start, table);
        } else if (this.tokens.canConsume("ADD", "COLUMN") || this.tokens.canConsume("ADD")) {
            String columnName = this.tokens.consume();
            ColumnEditor column = Column.editor().name(columnName);
            AtomicBoolean isPrimaryKey = new AtomicBoolean(false);
            this.parseColumnDefinition(start, columnName, this.tokens, table, column, isPrimaryKey);
            Column newColumnDefn = column.create();
            table.addColumn(newColumnDefn);
            if (isPrimaryKey.get()) {
                table.setPrimaryKeyNames(newColumnDefn.name());
            }
        } else if (this.tokens.canConsume("ALTER", "COLUMN") || this.tokens.canConsume("ALTER")) {
            String columnName = this.tokens.consume();
            Column existingColumn = table.columnWithName(columnName);
            ColumnEditor column = existingColumn != null ? existingColumn.edit() : Column.editor().name(columnName);
            this.parseAlterColumn(start, column);
            Column newColumnDefn = column.create();
            table.setColumns(newColumnDefn);
        } else if (this.tokens.matches("DROP", "CONSTRAINT")) {
            this.parseDropTableConstraint(start, table);
        } else if (this.tokens.canConsume("DROP", "COLUMN") || this.tokens.canConsume("DROP")) {
            this.parseDropColumn(start, table);
        }
        this.databaseTables.overwriteTable(table.create());
    }

    protected void parseDropColumn(TokenStream.Marker start, TableEditor table) {
        String columnName = this.tokens.consume();
        table.removeColumn(columnName);
        this.tokens.consumeAnyOf("CASCADE", "RESTRICT");
    }

    protected void parseDropTableConstraint(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("DROP", "CONSTRAINT");
        this.tokens.consume();
        this.tokens.consumeAnyOf("CASCADE", "RESTRICT");
    }

    protected void parseAlterColumn(TokenStream.Marker start, ColumnEditor column) {
        if (this.tokens.canConsume("SET", "INCREMENT", "BY")) {
            this.parseNumericLiteral(start, true);
        } else if (this.tokens.canConsume("SET", "MAXVALUE")) {
            this.parseNumericLiteral(start, true);
        } else if (!this.tokens.canConsume("SET", "NO", "MAXVALUE")) {
            if (this.tokens.canConsume("SET", "MINVALUE")) {
                this.parseNumericLiteral(start, true);
            } else if (!this.tokens.canConsume("SET", "NO", "MINVALUE")) {
                if (!this.tokens.canConsume("SET", "CYCLE")) {
                    if (!this.tokens.canConsume("SET", "NO", "CYCLE")) {
                        if (!this.tokens.canConsume("DROP", "DEFAULT")) {
                            if (this.tokens.canConsume("ADD", "SCOPE")) {
                                this.parseSchemaQualifiedName(start);
                            } else if (this.tokens.canConsume("DROP", "SCOPE")) {
                                this.tokens.consumeAnyOf("CASCADE", "RESTRICT");
                            } else if (this.tokens.canConsume("SET")) {
                                this.parseDefaultClause(start, column);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void parseAlterUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    @Override
    protected void parseDrop(TokenStream.Marker marker) {
        this.tokens.consume("DROP");
        if (this.tokens.matches("TABLE") || this.tokens.matches("TEMPORARY", "TABLE")) {
            this.parseDropTable(marker);
            this.debugParsed(marker);
        } else if (this.tokens.matches("VIEW")) {
            this.parseDropView(marker);
            this.debugParsed(marker);
        } else {
            this.parseDropUnknown(marker);
        }
    }

    protected void parseDropTable(TokenStream.Marker start) {
        this.tokens.canConsume("TEMPORARY");
        this.tokens.consume("TABLE");
        this.tokens.canConsume("IF", "EXISTS");
        TableId tableId = this.parseQualifiedTableName(start);
        this.databaseTables.removeTable(tableId);
        this.consumeRemainingStatement(start);
    }

    protected void parseDropView(TokenStream.Marker start) {
        this.tokens.consume("VIEW");
        this.tokens.canConsume("IF", "EXISTS");
        TableId tableId = this.parseQualifiedTableName(start);
        this.databaseTables.removeTable(tableId);
        this.consumeRemainingStatement(start);
    }

    protected void parseDropUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    protected void parseInsert(TokenStream.Marker marker) {
        this.consumeStatement();
        this.debugSkipped(marker);
    }

    protected void parseSet(TokenStream.Marker marker) {
        this.consumeStatement();
        this.debugSkipped(marker);
    }

    protected void parseGrant(TokenStream.Marker marker) {
        this.consumeStatement();
        this.debugSkipped(marker);
    }

    protected void parseRevoke(TokenStream.Marker marker) {
        this.consumeStatement();
        this.debugSkipped(marker);
    }
}

