/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.text.Position;
import io.debezium.text.TokenStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DdlParser {
    private final Set<String> keywords = new HashSet<String>();
    private final Set<String> statementStarts = new HashSet<String>();
    private final String terminator;
    private String currentSchema = null;
    protected final boolean skipViews;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final DataTypeParser dataTypeParser = new DataTypeParser();
    protected Tables databaseTables;
    protected TokenStream tokens;

    public DdlParser(String terminator) {
        this(terminator, false);
    }

    public DdlParser(String terminator, boolean includeViews) {
        this.terminator = terminator != null ? terminator : ";";
        this.skipViews = !includeViews;
        this.initializeDataTypes(this.dataTypeParser);
        this.initializeKeywords(this.keywords::add);
        this.initializeStatementStarts(this.statementStarts::add);
    }

    protected void initializeDataTypes(DataTypeParser dataTypeParser) {
    }

    protected void initializeKeywords(TokenSet keywords) {
    }

    protected void initializeStatementStarts(TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", "ALTER", "DROP", "INSERT", "SET", "GRANT", "REVOKE");
    }

    protected final String terminator() {
        return this.terminator;
    }

    protected int determineTokenType(int type, String token) {
        if (this.statementStarts.contains(token)) {
            type |= 0x80;
        }
        if (this.keywords.contains(token)) {
            type |= 0x40;
        }
        if (this.terminator.equals(token)) {
            type |= 0x100;
        }
        return type;
    }

    public void setCurrentSchema(String name) {
        this.currentSchema = name;
    }

    public String currentSchema() {
        return this.currentSchema;
    }

    protected String parseSchemaQualifiedName(TokenStream.Marker start) {
        String first = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String second = this.tokens.consume();
            return first + "." + second;
        }
        if (this.currentSchema() != null) {
            return this.currentSchema() + "." + first;
        }
        return first;
    }

    protected TableId parseQualifiedTableName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String tableName = this.tokens.consume();
            return this.resolveTableId(name, tableName);
        }
        return this.resolveTableId(this.currentSchema(), name);
    }

    protected TableId resolveTableId(String schemaName, String tableName) {
        return new TableId(schemaName, null, tableName);
    }

    protected boolean skipComments() {
        return true;
    }

    public final void parse(String ddlContent, Tables databaseTables) {
        TokenStream stream = new TokenStream(ddlContent, new DdlTokenizer(!this.skipComments(), this::determineTokenType), false);
        stream.start();
        this.parse(stream, databaseTables);
    }

    public final void parse(TokenStream ddlContent, Tables databaseTables) throws ParsingException, IllegalStateException {
        this.tokens = ddlContent;
        this.databaseTables = databaseTables;
        TokenStream.Marker marker = ddlContent.mark();
        try {
            while (ddlContent.hasNext()) {
                this.parseNextStatement(ddlContent.mark());
                this.tokens.canConsume(256);
            }
        }
        catch (ParsingException e) {
            ddlContent.rewind(marker);
            throw e;
        }
        catch (Throwable t) {
            this.parsingFailed(ddlContent.nextPosition(), "Unexpected exception (" + t.getMessage() + ") parsing", t);
        }
    }

    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    protected void parseComment(TokenStream.Marker marker) {
        String comment = this.tokens.consume();
        this.logger.trace("COMMENT: {}", (Object)comment);
    }

    protected void parseCreate(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseAlter(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseDrop(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseUnknownStatement(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void debugParsed(TokenStream.Marker statementStart) {
        if (this.logger.isTraceEnabled()) {
            String statement = this.removeLineFeeds(this.tokens.getContentFrom(statementStart));
            this.logger.trace("PARSED:  {}", (Object)statement);
        }
    }

    protected void debugSkipped(TokenStream.Marker statementStart) {
        if (this.logger.isTraceEnabled()) {
            String statement = this.removeLineFeeds(this.tokens.getContentFrom(statementStart));
            this.logger.trace("SKIPPED: {}", (Object)statement);
        }
    }

    private String removeLineFeeds(String input) {
        return input.replaceAll("[\\n|\\t]", "");
    }

    protected void consumeStatement() throws ParsingException {
        TokenStream.Marker start = this.tokens.mark();
        this.tokens.consume(128);
        this.consumeRemainingStatement(start);
    }

    protected void consumeRemainingStatement(TokenStream.Marker start) {
        while (this.tokens.hasNext() && !this.tokens.matches(128)) {
            if (this.tokens.canConsume("BEGIN")) {
                this.tokens.consumeThrough("END");
            } else if (this.tokens.matches(256)) {
                this.tokens.consume();
                break;
            }
            this.tokens.consume();
        }
    }

    protected String consumeSingleQuotedString() {
        return this.tokens.consumeAnyOf(8);
    }

    protected String consumeDoubleQuotedString() {
        return this.tokens.consumeAnyOf(16);
    }

    protected String consumeQuotedString() {
        return this.tokens.consumeAnyOf(8, 16);
    }

    protected void parsingFailed(Position position, String msg) {
        this.parsingFailed(position, msg);
    }

    protected void parsingFailed(Position position, String msg, Throwable t) {
        throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column(), t);
    }

    protected void parsingFailed(Position position, Collection<ParsingException> errors, String msg) {
        if (errors == null || errors.isEmpty()) {
            throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column());
        }
        throw new MultipleParsingExceptions(msg + " at line " + position.line() + ", column " + position.column(), errors);
    }

    protected Object parseLiteral(TokenStream.Marker start) {
        if (this.tokens.canConsume('_')) {
            this.parseCharacterSetName(start);
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume('N')) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("U", "&")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume('X')) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.matchesAnyOf(16, 8)) {
            return this.tokens.consume();
        }
        if (this.tokens.canConsume("DATE")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIME")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIMESTAMP")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TRUE")) {
            return Boolean.TRUE;
        }
        if (this.tokens.canConsume("FALSE")) {
            return Boolean.FALSE;
        }
        if (this.tokens.canConsume("UNKNOWN")) {
            return Boolean.FALSE;
        }
        return this.parseNumericLiteral(start, true);
    }

    protected Object parseNumericLiteral(TokenStream.Marker start, boolean signed) {
        StringBuilder sb = new StringBuilder();
        boolean decimal = false;
        if (signed && this.tokens.matches("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        if (!this.tokens.canConsume('.')) {
            sb.append(this.tokens.consumeInteger());
        }
        if (this.tokens.canConsume('.')) {
            sb.append(this.tokens.consumeInteger());
            decimal = true;
        }
        if (!this.tokens.canConsume('E')) {
            if (decimal) {
                return Double.parseDouble(sb.toString());
            }
            return Integer.parseInt(sb.toString());
        }
        sb.append('E');
        if (this.tokens.matches("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        sb.append(this.tokens.consumeInteger());
        return new BigDecimal(sb.toString());
    }

    protected String parseCharacterLiteral(TokenStream.Marker start) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.tokens.matches(32)) {
                this.parseComment(start);
                continue;
            }
            if (!this.tokens.matchesAnyOf(8, 16)) break;
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(this.tokens.consume());
        }
        if (this.tokens.canConsume("ESCAPE")) {
            this.tokens.consume();
        }
        return sb.toString();
    }

    protected String parseCharacterSetName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String id = this.tokens.consume();
            return name + "." + id;
        }
        return name;
    }

    protected String parseDateLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimeLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimestampLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected Map<String, Column> parseColumnsInSelectClause(TokenStream.Marker start) {
        LinkedHashMap<String, String> tableAliasByColumnAlias = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> columnNameByAliases = new LinkedHashMap<String, String>();
        this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        while (this.tokens.canConsume(',')) {
            this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        }
        TokenStream.Marker startOfFrom = this.tokens.mark();
        LinkedHashMap<String, Column> columnsByName = new LinkedHashMap<String, Column>();
        Map<String, Table> fromTablesByAlias = this.parseSelectFromClause(start);
        Table singleTable = fromTablesByAlias.size() == 1 ? fromTablesByAlias.values().stream().findFirst().get() : null;
        tableAliasByColumnAlias.forEach((columnAlias, tableAlias) -> {
            String columnName = columnNameByAliases.getOrDefault(columnAlias, (String)columnAlias);
            Column column = null;
            if (tableAlias == null) {
                column = singleTable == null ? null : singleTable.columnWithName(columnName);
            } else {
                Table table = (Table)fromTablesByAlias.get(tableAlias);
                Column column2 = column = table == null ? null : table.columnWithName(columnName);
            }
            if (column == null) {
                column = this.createColumnFromConstant((String)columnAlias, columnName);
            }
            columnsByName.put((String)columnAlias, column);
        });
        this.tokens.rewind(startOfFrom);
        return columnsByName;
    }

    protected Column createColumnFromConstant(String columnName, String constantValue) {
        ColumnEditor column = Column.editor().name(columnName);
        try {
            if (constantValue.startsWith("'") || constantValue.startsWith("\"")) {
                column.typeName("CHAR");
                column.jdbcType(1);
                column.length(constantValue.length() - 2);
            } else if (constantValue.equalsIgnoreCase("TRUE") || constantValue.equalsIgnoreCase("FALSE")) {
                column.typeName("BOOLEAN");
                column.jdbcType(16);
            } else {
                this.setTypeInfoForConstant(constantValue, column);
            }
        }
        catch (Throwable t) {
            this.logger.debug("Unable to create an artificial column for the constant: " + constantValue);
        }
        return column.create();
    }

    protected void setTypeInfoForConstant(String constantValue, ColumnEditor column) {
        try {
            Integer.parseInt(constantValue);
            column.typeName("INTEGER");
            column.jdbcType(4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Long.parseLong(constantValue);
            column.typeName("BIGINT");
            column.jdbcType(-5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Float.parseFloat(constantValue);
            column.typeName("FLOAT");
            column.jdbcType(6);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Double.parseDouble(constantValue);
            column.typeName("DOUBLE");
            column.jdbcType(8);
            int precision = 0;
            int scale = 0;
            boolean foundDecimalPoint = false;
            for (int i = 0; i < constantValue.length(); ++i) {
                char c = constantValue.charAt(i);
                if (c == '+' || c == '-') continue;
                if (c == '.') {
                    foundDecimalPoint = true;
                    continue;
                }
                if (!Character.isDigit(c)) break;
                if (foundDecimalPoint) {
                    ++scale;
                    continue;
                }
                ++precision;
            }
            column.length(precision);
            column.scale(scale);
        }
        catch (NumberFormatException precision) {
            // empty catch block
        }
        try {
            BigDecimal decimal = new BigDecimal(constantValue);
            column.typeName("DECIMAL");
            column.jdbcType(3);
            column.length(decimal.precision());
            column.scale(decimal.precision());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String determineTypeNameForConstant(long value) {
        return "BIGINT";
    }

    protected String determineTypeNameForConstant(float value) {
        return "FLOAT";
    }

    protected String determineTypeNameForConstant(double value) {
        return "DECIMAL";
    }

    protected String determineTypeNameForConstant(BigDecimal value) {
        return "BIGINT";
    }

    protected void parseColumnName(TokenStream.Marker start, Map<String, String> tableAliasByColumnAliases, Map<String, String> columnNameByAliases) {
        try {
            String tableName = this.tokens.consume();
            String columnName = null;
            if (this.tokens.canConsume('.')) {
                columnName = this.tokens.consume();
            } else {
                columnName = tableName;
                tableName = null;
            }
            String alias = columnName;
            if (this.tokens.canConsume("AS")) {
                alias = this.tokens.consume();
            }
            columnNameByAliases.put(alias, columnName);
            tableAliasByColumnAliases.put(alias, tableName);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    protected Map<String, Table> parseSelectFromClause(TokenStream.Marker start) {
        HashMap<String, Table> tablesByAlias = new HashMap<String, Table>();
        if (this.tokens.canConsume("FROM")) {
            try {
                this.parseAliasedTableInFrom(start, tablesByAlias);
                while (this.tokens.canConsume(',') || this.canConsumeJoin(start)) {
                    this.parseAliasedTableInFrom(start, tablesByAlias);
                    this.canConsumeJoinCondition(start);
                }
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return tablesByAlias;
    }

    protected boolean canConsumeJoin(TokenStream.Marker start) {
        return this.tokens.canConsume("JOIN") || this.tokens.canConsume("INNER", "JOIN") || this.tokens.canConsume("OUTER", "JOIN") || this.tokens.canConsume("CROSS", "JOIN") || this.tokens.canConsume("RIGHT", "OUTER", "JOIN") || this.tokens.canConsume("LEFT", "OUTER", "JOIN") || this.tokens.canConsume("FULL", "OUTER", "JOIN");
    }

    protected boolean canConsumeJoinCondition(TokenStream.Marker start) {
        if (this.tokens.canConsume("ON")) {
            try {
                this.parseSchemaQualifiedName(start);
                while (this.tokens.canConsume(2)) {
                }
                this.parseSchemaQualifiedName(start);
                return true;
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return false;
    }

    private void parseAliasedTableInFrom(TokenStream.Marker start, Map<String, Table> tablesByAlias) {
        Table fromTable = this.databaseTables.forTable(this.parseQualifiedTableName(start));
        if (this.tokens.matches("AS", "any value", "ON") || this.tokens.matches("any value", "ON")) {
            this.tokens.canConsume("AS");
            String alias = this.tokens.consume();
            if (fromTable != null) {
                tablesByAlias.put(alias, fromTable);
                return;
            }
        }
        if (fromTable != null) {
            tablesByAlias.put(fromTable.id().table(), fromTable);
        }
    }

    protected static interface TokenSet {
        public void add(String var1);

        default public void add(String firstToken, String ... additionalTokens) {
            this.add(firstToken);
            for (String token : additionalTokens) {
                this.add(token);
            }
        }
    }
}

