/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.Immutable;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.function.Consumer;
import java.util.function.Function;

@Immutable
public class DataTypeGrammarParser {
    private final DdlTokenizer tokenizer = new DdlTokenizer(true);

    public DataTypePattern parse(int jdbcType, String dataTypeDefn) throws ParsingException {
        TokenStream stream = new TokenStream(dataTypeDefn, this.tokenizer, false);
        stream.start();
        Pattern pattern = this.parseMultiple(stream);
        return pattern != null ? new DataTypePattern(pattern, jdbcType) : null;
    }

    protected Pattern parseMultiple(TokenStream stream) throws ParsingException {
        Pattern pattern = null;
        while (stream.hasNext()) {
            Pattern inner = this.parsePattern(stream);
            if (inner == null) {
                return pattern;
            }
            if (stream.canConsume('|')) {
                Pattern orPattern = this.parseMultiple(stream);
                inner = new OrPattern(inner, orPattern);
            }
            pattern = pattern == null ? inner : new AndPattern(pattern, inner);
        }
        return pattern;
    }

    protected Pattern parsePattern(TokenStream stream) throws ParsingException {
        if (stream.matches('[')) {
            return this.parseOptional(stream, this::parseMultiple);
        }
        if (stream.matches('(')) {
            return this.parseLength(stream);
        }
        if (stream.matches('{')) {
            return this.parseArrayDimensions(stream);
        }
        if (stream.matchesAnyOf(64, 1)) {
            String literal = stream.consume();
            if (literal.toLowerCase().equals(literal)) {
                return new VariablePattern(literal);
            }
            return new LiteralPattern(literal);
        }
        return null;
    }

    protected Pattern parseOptional(TokenStream stream, Function<TokenStream, Pattern> inside) throws ParsingException {
        stream.consume('[');
        Pattern pattern = inside.apply(stream);
        stream.consume(']');
        return new OptionalPattern(pattern);
    }

    protected Pattern parseArrayDimensions(TokenStream stream) throws ParsingException {
        stream.consume('{').consume('n').consume('}');
        return new ArrayDimensionsPattern();
    }

    protected Pattern parseLength(TokenStream stream) throws ParsingException {
        stream.consume('(');
        Pattern result = new LiteralPattern("(", false);
        if (stream.canConsume(".", ".", ".")) {
            result = new AndPattern(result, new ListPattern());
        } else if (stream.canConsumeAnyOf("L", "M", "P", "N")) {
            result = new AndPattern(result, new LengthPattern());
        } else {
            Pattern literal = this.parseLengthLiteral(stream);
            while (stream.canConsume('|')) {
                literal = new OrPattern(literal, this.parseLengthLiteral(stream));
            }
            result = new AndPattern(result, literal);
        }
        Pattern scale = null;
        if (stream.matches(',')) {
            scale = this.parseScale(stream);
        } else if (stream.matches('[')) {
            scale = this.parseOptional(stream, this::parseScale);
        }
        if (scale != null) {
            result = new AndPattern(result, scale);
        }
        stream.consume(')');
        return new AndPattern(result, new LiteralPattern(")", false));
    }

    protected Pattern parseScale(TokenStream stream) throws ParsingException {
        stream.consume(',');
        Pattern result = new LiteralPattern(",", false);
        if (stream.canConsume('S') || stream.canConsume('D')) {
            result = new AndPattern(result, new ScalePattern());
        } else {
            Pattern literal = this.parseScaleLiteral(stream);
            while (stream.canConsume('|')) {
                literal = new OrPattern(literal, this.parseScaleLiteral(stream));
            }
            result = new AndPattern(result, literal);
        }
        return result;
    }

    protected Pattern parseLengthLiteral(TokenStream stream) throws ParsingException {
        long lengthLiteral = stream.consumeLong();
        return new LiteralLengthPattern(lengthLiteral);
    }

    protected Pattern parseScaleLiteral(TokenStream stream) throws ParsingException {
        int scaleLiteral = stream.consumeInteger();
        return new LiteralScalePattern(scaleLiteral);
    }

    protected static class ArrayDimensionsPattern
    implements Pattern {
        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            while (stream.canConsume('[')) {
                int dimension = stream.consumeInteger();
                stream.consume(']');
                builder.addArrayDimension(dimension);
            }
            return true;
        }

        public String toString() {
            return "arrayDims";
        }
    }

    protected static class LiteralScalePattern
    implements Pattern {
        private final int literal;

        public LiteralScalePattern(int literal) {
            this.literal = literal;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            if (stream.consumeInteger() == this.literal) {
                builder.scale(this.literal);
                return true;
            }
            return false;
        }

        public String toString() {
            return Integer.toString(this.literal);
        }
    }

    protected static class LiteralLengthPattern
    implements Pattern {
        private final long literal;

        public LiteralLengthPattern(long literal) {
            this.literal = literal;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            if (stream.consumeLong() == this.literal) {
                builder.length(this.literal);
                return true;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.literal);
        }
    }

    protected static class ScalePattern
    implements Pattern {
        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            builder.scale(stream.consumeInteger());
            return true;
        }

        public String toString() {
            return "S";
        }
    }

    protected static class LengthPattern
    implements Pattern {
        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            TokenStream.Marker marker = stream.mark();
            long value = stream.consumeLong();
            if (value >= 0L) {
                builder.length(value);
                return true;
            }
            stream.rewind(marker);
            return false;
        }

        public String toString() {
            return "L";
        }
    }

    protected static class OptionalPattern
    implements Pattern {
        private final Pattern pattern;

        public OptionalPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            if (stream.hasNext()) {
                TokenStream.Marker marker = stream.mark();
                try {
                    if (!this.pattern.match(stream, builder, error)) {
                        stream.rewind(marker);
                    }
                }
                catch (ParsingException e) {
                    error.accept(e);
                    stream.rewind(marker);
                }
            }
            return true;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            return this.pattern.determineFirstTokens(tokens);
        }

        public String toString() {
            return "[" + this.pattern.toString() + "]";
        }
    }

    protected static class ListPattern
    implements Pattern {
        private final String delimiter;

        public ListPattern() {
            this.delimiter = ",";
        }

        public ListPattern(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            if (stream.matches(')')) {
                return true;
            }
            stream.consume();
            while (stream.canConsume(this.delimiter)) {
                stream.consume();
            }
            return true;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            return false;
        }

        public String toString() {
            return "LIST";
        }
    }

    protected static class VariablePattern
    extends LiteralPattern {
        public VariablePattern(String variableName) {
            this(variableName, true);
        }

        public VariablePattern(String variableName, boolean addToBuilder) {
            super(variableName, addToBuilder);
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            String variableName = stream.consume();
            if (this.addToBuilder) {
                builder.addToName(variableName);
            }
            return true;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            return false;
        }

        @Override
        public String toString() {
            return this.literal;
        }
    }

    protected static class LiteralPattern
    implements Pattern {
        protected final String literal;
        protected final boolean addToBuilder;

        public LiteralPattern(String literal) {
            this(literal, true);
        }

        public LiteralPattern(String literal, boolean addToBuilder) {
            this.literal = literal;
            this.addToBuilder = addToBuilder;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            stream.consume(this.literal);
            if (this.addToBuilder) {
                builder.addToName(this.literal);
            }
            return true;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            tokens.accept(this.literal);
            return false;
        }

        public String toString() {
            return this.literal;
        }
    }

    protected static class OrPattern
    implements Pattern {
        private final Pattern pattern1;
        private final Pattern pattern2;

        public OrPattern(Pattern pattern1, Pattern pattern2) {
            this.pattern1 = pattern1;
            this.pattern2 = pattern2;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            TokenStream.Marker marker = stream.mark();
            try {
                if (this.pattern1.match(stream, builder, error)) {
                    return true;
                }
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            stream.rewind(marker);
            try {
                if (this.pattern2.match(stream, builder, error)) {
                    return true;
                }
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            stream.rewind(marker);
            return false;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            return false;
        }

        public String toString() {
            return this.pattern1.toString() + " | " + this.pattern2.toString();
        }
    }

    protected static class AndPattern
    implements Pattern {
        private final Pattern pattern1;
        private final Pattern pattern2;

        public AndPattern(Pattern pattern1, Pattern pattern2) {
            this.pattern1 = pattern1;
            this.pattern2 = pattern2;
        }

        @Override
        public boolean match(TokenStream stream, DataTypeBuilder builder, Consumer<ParsingException> error) {
            TokenStream.Marker marker = stream.mark();
            try {
                if (this.pattern1.match(stream, builder, error) && this.pattern2.match(stream, builder, error)) {
                    return true;
                }
            }
            catch (ParsingException e) {
                stream.rewind(marker);
            }
            return false;
        }

        @Override
        public boolean determineFirstTokens(Consumer<String> tokens) {
            if (!this.pattern1.determineFirstTokens(tokens)) {
                return false;
            }
            return this.pattern2.determineFirstTokens(tokens);
        }

        public String toString() {
            return this.pattern1.toString() + " " + this.pattern2.toString();
        }
    }

    protected static interface Pattern {
        public boolean match(TokenStream var1, DataTypeBuilder var2, Consumer<ParsingException> var3);

        default public boolean isOptional() {
            return false;
        }

        default public boolean determineFirstTokens(Consumer<String> tokens) {
            return false;
        }
    }

    protected static class DataTypeBuilder {
        private StringBuilder prefix = new StringBuilder();
        private StringBuilder suffix = new StringBuilder();
        private int jdbcType = 0;
        private long length = -1L;
        private int scale = -1;
        private int arrayDimsLength = 0;
        private final int[] arrayDims = new int[40];

        protected DataTypeBuilder() {
        }

        public void addToName(String str) {
            if (this.length == -1L) {
                if (this.prefix.length() != 0) {
                    this.prefix.append(' ');
                }
                this.prefix.append(str);
            } else {
                if (this.suffix.length() != 0) {
                    this.suffix.append(' ');
                }
                this.suffix.append(str);
            }
        }

        public DataTypeBuilder length(long length) {
            this.length = length;
            return this;
        }

        public DataTypeBuilder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public DataTypeBuilder addArrayDimension(int dimension) {
            this.arrayDims[this.arrayDimsLength++] = dimension;
            return this;
        }

        public DataTypeBuilder reset() {
            this.length = -1L;
            this.scale = -1;
            this.arrayDimsLength = 0;
            this.prefix.setLength(0);
            this.suffix.setLength(0);
            return this;
        }

        public DataType create() {
            StringBuilder name = new StringBuilder(this.prefix);
            StringBuilder expression = new StringBuilder(this.prefix);
            if (this.length != -1L) {
                expression.append('(');
                expression.append(this.length);
                if (this.scale != -1) {
                    expression.append(',');
                    expression.append(this.scale);
                }
                expression.append(')');
            }
            if (this.arrayDimsLength != 0) {
                for (int i = 0; i != this.arrayDimsLength; ++i) {
                    expression.append('[');
                    expression.append(this.arrayDims[i]);
                    expression.append(']');
                }
            }
            if (this.suffix.length() != 0) {
                expression.append(' ');
                expression.append((CharSequence)this.suffix);
                name.append(' ');
                name.append((CharSequence)this.suffix);
            }
            return new DataType(expression.toString(), name.toString(), this.jdbcType, this.length, this.scale, this.arrayDims, this.arrayDimsLength);
        }
    }

    public static class DataTypePattern {
        private final Pattern pattern;
        private final DataTypeBuilder builder = new DataTypeBuilder();
        private final int jdbcType;

        protected DataTypePattern(Pattern pattern, int jdbcType) {
            this.pattern = pattern;
            this.jdbcType = jdbcType;
        }

        public int jdbcType() {
            return this.jdbcType;
        }

        public DataType match(TokenStream stream) {
            return this.match(stream, null);
        }

        public DataType match(TokenStream stream, Consumer<ParsingException> errors) {
            this.builder.reset();
            this.builder.jdbcType = this.jdbcType;
            if (this.pattern.match(stream, this.builder, errors != null ? errors : e -> {})) {
                return this.builder.create();
            }
            return null;
        }

        public void forEachFirstToken(Consumer<String> tokens) {
            this.pattern.determineFirstTokens(tokens);
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

