/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.TableImpl;
import io.debezium.util.Collect;
import io.debezium.util.FunctionalReadWriteLock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

@ThreadSafe
public class Tables {
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    private final Map<TableId, TableImpl> tablesByTableId = new ConcurrentHashMap<TableId, TableImpl>();
    private final Set<TableId> changes = new HashSet<TableId>();

    public int size() {
        return this.lock.read(this.tablesByTableId::size);
    }

    public Set<TableId> drainChanges() {
        return this.lock.write(() -> {
            HashSet<TableId> result = new HashSet<TableId>(this.changes);
            this.changes.clear();
            return result;
        });
    }

    public Table overwriteTable(TableId tableId, List<Column> columnDefs, List<String> primaryKeyColumnNames) {
        return this.lock.write(() -> {
            TableImpl updated = new TableImpl(tableId, columnDefs, primaryKeyColumnNames);
            try {
                TableImpl tableImpl = this.tablesByTableId.put(tableId, updated);
                return tableImpl;
            }
            finally {
                this.changes.add(tableId);
            }
        });
    }

    public Table overwriteTable(Table table) {
        return this.lock.write(() -> {
            TableImpl updated = new TableImpl(table);
            try {
                TableImpl tableImpl = this.tablesByTableId.put(updated.id(), updated);
                return tableImpl;
            }
            finally {
                this.changes.add(updated.id());
            }
        });
    }

    public Table renameTable(TableId existingTableId, TableId newTableId) {
        return this.lock.write(() -> {
            Table existing = this.forTable(existingTableId);
            if (existing == null) {
                return null;
            }
            this.tablesByTableId.remove(existing);
            TableImpl updated = new TableImpl(newTableId, existing.columns(), existing.primaryKeyColumnNames());
            try {
                TableImpl tableImpl = this.tablesByTableId.put(updated.id(), updated);
                return tableImpl;
            }
            finally {
                this.changes.add(existingTableId);
                this.changes.add(updated.id());
            }
        });
    }

    public Table updateTable(TableId tableId, Function<Table, Table> changer) {
        return this.lock.write(() -> {
            TableImpl existing = this.tablesByTableId.get(tableId);
            Table updated = (Table)changer.apply(existing);
            if (updated != existing) {
                this.tablesByTableId.put(tableId, new TableImpl(tableId, updated.columns(), updated.primaryKeyColumnNames()));
            }
            this.changes.add(tableId);
            return existing;
        });
    }

    public Table updateTable(TableId tableId, TableChanger changer) {
        return this.lock.write(() -> {
            TableImpl existing = this.tablesByTableId.get(tableId);
            ArrayList<Column> columns = new ArrayList<Column>(existing.columns());
            ArrayList<String> pkColumnNames = new ArrayList<String>(existing.primaryKeyColumnNames());
            changer.rewrite(columns, pkColumnNames);
            TableImpl updated = new TableImpl(tableId, columns, pkColumnNames);
            this.tablesByTableId.put(tableId, updated);
            this.changes.add(tableId);
            return existing;
        });
    }

    public Table removeTable(TableId tableId) {
        return this.lock.write(() -> {
            this.changes.add(tableId);
            return this.tablesByTableId.remove(tableId);
        });
    }

    public Table forTable(TableId tableId) {
        return this.lock.read(() -> this.tablesByTableId.get(tableId));
    }

    public Table forTable(String catalogName, String schemaName, String tableName) {
        return this.forTable(new TableId(catalogName, schemaName, tableName));
    }

    public Set<TableId> tableIds() {
        return this.lock.read(() -> Collect.unmodifiableSet(this.tablesByTableId.keySet()));
    }

    public TableEditor editTable(TableId tableId) {
        Table table = this.forTable(tableId);
        return table == null ? null : table.edit();
    }

    public TableEditor editTable(String catalogName, String schemaName, String tableName) {
        return this.editTable(new TableId(catalogName, schemaName, tableName));
    }

    public TableEditor editOrCreateTable(TableId tableId) {
        Table table = this.forTable(tableId);
        return table == null ? Table.editor().tableId(tableId) : table.edit();
    }

    public TableEditor editOrCreateTable(String catalogName, String schemaName, String tableName) {
        return this.editOrCreateTable(new TableId(catalogName, schemaName, tableName));
    }

    public int hashCode() {
        return this.tablesByTableId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Tables) {
            Tables that = (Tables)obj;
            return this.tablesByTableId.equals(that.tablesByTableId);
        }
        return false;
    }

    public Tables subset(Predicate<TableId> filter) {
        if (filter == null) {
            return this;
        }
        return this.lock.read(() -> {
            Tables result = new Tables();
            this.tablesByTableId.forEach((tableId, table) -> {
                if (filter.test((TableId)tableId)) {
                    result.overwriteTable((Table)table);
                }
            });
            return result;
        });
    }

    public String toString() {
        return this.lock.read(() -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Tables {");
            if (!this.tablesByTableId.isEmpty()) {
                sb.append(System.lineSeparator());
                this.tablesByTableId.forEach((tableId, table) -> {
                    sb.append("  ").append(tableId).append(": {").append(System.lineSeparator());
                    table.toString(sb, "    ");
                    sb.append("  }").append(System.lineSeparator());
                });
            }
            sb.append("}");
            return sb.toString();
        });
    }

    public static interface TableChanger {
        public void rewrite(List<Column> var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface ColumnFilter {
        public boolean test(String var1, String var2, String var3, String var4);
    }

    @FunctionalInterface
    public static interface TableFilter {
        public boolean test(String var1, String var2, String var3);
    }
}

