/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.data.Bits;
import io.debezium.data.IsoTime;
import io.debezium.data.IsoTimestamp;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableSchema;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public class TableSchemaBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchemaBuilder.class);
    private static final LocalDate EPOCH_DAY = LocalDate.ofEpochDay(0L);

    public TableSchema create(ResultSet resultSet, String name) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        JdbcConnection.columnsFor(resultSet, columns::add);
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(name);
        columns.forEach(column -> this.addField(schemaBuilder, (Column)column));
        Schema valueSchema = schemaBuilder.build();
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valueSchema, name, columns);
        return new TableSchema(null, null, valueSchema, valueGenerator);
    }

    public TableSchema create(Table table) {
        String tableId = table.id().toString();
        SchemaBuilder valSchemaBuilder = SchemaBuilder.struct().name(tableId);
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct().name(tableId + "/pk");
        AtomicBoolean hasPrimaryKey = new AtomicBoolean(false);
        table.columns().forEach(column -> {
            if (table.isPrimaryKeyColumn(column.name())) {
                this.addField(keySchemaBuilder, (Column)column);
                hasPrimaryKey.set(true);
            }
            this.addField(valSchemaBuilder, (Column)column);
        });
        Schema valSchema = valSchemaBuilder.build();
        Schema keySchema = hasPrimaryKey.get() ? keySchemaBuilder.build() : null;
        Function<Object[], Object> keyGenerator = this.createKeyGenerator(keySchema, tableId, table.primaryKeyColumns());
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valSchema, tableId, table.columns());
        return new TableSchema(keySchema, keyGenerator, valSchema, valueGenerator);
    }

    protected Function<Object[], Object> createKeyGenerator(Schema schema, String columnSetName, List<Column> columns) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, columns);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    value = value == null ? value : converters[i].convert(value);
                    try {
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (DataException e) {
                        Column col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert key value for '" + columnSetName + "." + col.name() + "' of type " + col.typeName() + ":", (Throwable)e);
                    }
                }
                return result;
            };
        }
        return null;
    }

    protected Function<Object[], Struct> createValueGenerator(Schema schema, String columnSetName, List<Column> columns) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, columns);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    if (value != null) {
                        value = converters[i].convert(value);
                    }
                    try {
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (DataException e) {
                        Column col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert data value for '" + columnSetName + "." + col.name() + "' of type " + col.typeName() + ":", (Throwable)e);
                    }
                }
                return result;
            };
        }
        return null;
    }

    protected int[] indexesForColumns(List<Column> columns) {
        int[] recordIndexes = new int[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            recordIndexes[i.getAndIncrement()] = column.position() - 1;
        });
        return recordIndexes;
    }

    protected Field[] fieldsForColumns(Schema schema, List<Column> columns) {
        Field[] fields = new Field[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field = schema.field(column.name());
            assert (field != null);
            fields[i.getAndIncrement()] = field;
        });
        return fields;
    }

    protected ValueConverter[] convertersForColumns(Schema schema, List<Column> columns) {
        ValueConverter[] converters = new ValueConverter[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field = schema.field(column.name());
            ValueConverter converter = this.createValueConverterFor((Column)column, field);
            assert (converter != null);
            converters[i.getAndIncrement()] = converter;
        });
        return converters;
    }

    protected void addField(SchemaBuilder builder, Column column) {
        this.addField(builder, column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale(), column.isOptional());
    }

    protected void addField(SchemaBuilder builder, String columnName, int jdbcType, String typeName, int columnLength, int columnScale, boolean optional) {
        switch (jdbcType) {
            case 0: {
                LOGGER.warn("Unexpected JDBC type: NULL");
                break;
            }
            case -7: {
                if (columnLength > 1) {
                    SchemaBuilder bitBuilder = Bits.builder();
                    if (optional) {
                        bitBuilder.optional();
                    }
                    builder.field(columnName, bitBuilder.build());
                    break;
                }
            }
            case 16: {
                builder.field(columnName, optional ? Schema.OPTIONAL_BOOLEAN_SCHEMA : Schema.BOOLEAN_SCHEMA);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                builder.field(columnName, optional ? Schema.OPTIONAL_BYTES_SCHEMA : Schema.BYTES_SCHEMA);
                break;
            }
            case -6: {
                builder.field(columnName, optional ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA);
                break;
            }
            case 5: {
                builder.field(columnName, optional ? Schema.OPTIONAL_INT16_SCHEMA : Schema.INT16_SCHEMA);
                break;
            }
            case 4: {
                builder.field(columnName, optional ? Schema.OPTIONAL_INT32_SCHEMA : Schema.INT32_SCHEMA);
                break;
            }
            case -5: {
                builder.field(columnName, optional ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA);
                break;
            }
            case 7: {
                builder.field(columnName, optional ? Schema.OPTIONAL_FLOAT32_SCHEMA : Schema.FLOAT32_SCHEMA);
                break;
            }
            case 6: 
            case 8: {
                builder.field(columnName, optional ? Schema.OPTIONAL_FLOAT64_SCHEMA : Schema.OPTIONAL_FLOAT64_SCHEMA);
                break;
            }
            case 2: 
            case 3: {
                SchemaBuilder decBuilder = Decimal.builder((int)columnScale);
                if (optional) {
                    decBuilder.optional();
                }
                builder.field(columnName, decBuilder.build());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                builder.field(columnName, optional ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA);
                break;
            }
            case 91: {
                SchemaBuilder dateBuilder = org.apache.kafka.connect.data.Date.builder();
                if (optional) {
                    dateBuilder.optional();
                }
                builder.field(columnName, dateBuilder.build());
                break;
            }
            case 92: {
                SchemaBuilder timeBuilder = Time.builder();
                if (optional) {
                    timeBuilder.optional();
                }
                builder.field(columnName, timeBuilder.build());
                break;
            }
            case 93: {
                SchemaBuilder timestampBuilder = org.apache.kafka.connect.data.Timestamp.builder();
                if (optional) {
                    timestampBuilder.optional();
                }
                builder.field(columnName, timestampBuilder.build());
                break;
            }
            case 2013: {
                SchemaBuilder offsetTimeBuilder = IsoTime.builder();
                if (optional) {
                    offsetTimeBuilder.optional();
                }
                builder.field(columnName, offsetTimeBuilder.build());
                break;
            }
            case 2014: {
                SchemaBuilder tsWithTzBuilder = IsoTimestamp.builder();
                if (optional) {
                    tsWithTzBuilder.optional();
                }
                builder.field(columnName, tsWithTzBuilder.build());
                break;
            }
            case -8: {
                builder.field(columnName, optional ? Schema.OPTIONAL_BYTES_SCHEMA : Schema.BYTES_SCHEMA);
                break;
            }
            default: {
                this.addOtherField(builder, columnName, jdbcType, typeName, columnLength, columnScale, optional);
            }
        }
    }

    protected void addOtherField(SchemaBuilder builder, String columnName, int jdbcType, String typeName, int columnLength, int columnScale, boolean optional) {
        LOGGER.warn("Unexpected JDBC type: {}", (Object)jdbcType);
    }

    protected ValueConverter createValueConverterFor(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case 0: {
                return data -> null;
            }
            case -7: 
            case 16: {
                return data -> {
                    if (data instanceof Boolean) {
                        return (Boolean)data;
                    }
                    if (data instanceof Short) {
                        return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (data instanceof Integer) {
                        return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (data instanceof Long) {
                        return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> (byte[])data;
            }
            case -6: {
                return data -> {
                    if (data instanceof Byte) {
                        return (Byte)data;
                    }
                    if (data instanceof Boolean) {
                        return (Boolean)data != false ? (byte)1 : (byte)0;
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case 5: {
                return data -> {
                    if (data instanceof Short) {
                        return (Short)data;
                    }
                    if (data instanceof Integer) {
                        return new Short(((Integer)data).shortValue());
                    }
                    if (data instanceof Long) {
                        return new Short(((Long)data).shortValue());
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case 4: {
                return data -> {
                    if (data instanceof Integer) {
                        return (Integer)data;
                    }
                    if (data instanceof Short) {
                        return new Integer(((Short)data).intValue());
                    }
                    if (data instanceof Long) {
                        return new Integer(((Long)data).intValue());
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case -5: {
                return data -> {
                    if (data instanceof Long) {
                        return (Long)data;
                    }
                    if (data instanceof Integer) {
                        return new Long(((Integer)data).longValue());
                    }
                    if (data instanceof Short) {
                        return new Long(((Short)data).longValue());
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case 6: 
            case 8: {
                return data -> {
                    if (data instanceof Double) {
                        return (Double)data;
                    }
                    if (data instanceof Float) {
                        return new Double(((Float)data).doubleValue());
                    }
                    if (data instanceof Integer) {
                        return new Double(((Integer)data).doubleValue());
                    }
                    if (data instanceof Long) {
                        return new Double(((Long)data).doubleValue());
                    }
                    if (data instanceof Short) {
                        return new Double(((Short)data).doubleValue());
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case 7: {
                return data -> {
                    if (data instanceof Float) {
                        return (Float)data;
                    }
                    if (data instanceof Double) {
                        return new Float(((Double)data).floatValue());
                    }
                    if (data instanceof Integer) {
                        return new Float(((Integer)data).floatValue());
                    }
                    if (data instanceof Long) {
                        return new Float(((Long)data).floatValue());
                    }
                    if (data instanceof Short) {
                        return new Float(((Short)data).floatValue());
                    }
                    return this.handleUnknownData(column, fieldDefn, data);
                };
            }
            case 2: 
            case 3: {
                return data -> {
                    BigDecimal decimal = null;
                    if (data instanceof BigDecimal) {
                        decimal = (BigDecimal)data;
                    } else if (data instanceof Boolean) {
                        decimal = new BigDecimal((Boolean)data != false ? 1 : 0);
                    } else if (data instanceof Short) {
                        decimal = new BigDecimal(((Short)data).intValue());
                    } else if (data instanceof Integer) {
                        decimal = new BigDecimal((Integer)data);
                    } else if (data instanceof Long) {
                        decimal = BigDecimal.valueOf((Long)data);
                    } else if (data instanceof Float) {
                        decimal = BigDecimal.valueOf(((Float)data).doubleValue());
                    } else if (data instanceof Double) {
                        decimal = BigDecimal.valueOf((Double)data);
                    } else {
                        this.handleUnknownData(column, fieldDefn, data);
                    }
                    return decimal;
                };
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return data -> data.toString();
            }
            case 91: {
                return data -> this.convertDate(fieldDefn, data);
            }
            case 92: {
                return data -> this.convertTime(fieldDefn, data);
            }
            case 93: {
                return data -> this.convertTimestamp(fieldDefn, data);
            }
            case 2013: {
                return data -> this.convertTimeWithZone(fieldDefn, data);
            }
            case 2014: {
                return data -> this.convertTimestampWithZone(fieldDefn, data);
            }
            case -8: {
                return data -> {
                    RowId rowId = (RowId)data;
                    return rowId.getBytes();
                };
            }
        }
        return data -> this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        LOGGER.warn("Unexpected value for JDBC type {} and column {}: class={}, value={}", new Object[]{column.jdbcType(), column, data.getClass(), data});
        return null;
    }

    protected Object convertTimestampWithZone(Field fieldDefn, Object data) {
        OffsetDateTime dateTime = null;
        if (data instanceof OffsetDateTime) {
            dateTime = (OffsetDateTime)data;
        } else if (data instanceof Timestamp) {
            Timestamp sqlTime = (Timestamp)data;
            dateTime = sqlTime.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof Date) {
            java.sql.Time sqlTime = (java.sql.Time)data;
            dateTime = sqlTime.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)data;
            dateTime = date.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            dateTime = local.atTime(OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            dateTime = local.atOffset(ZoneOffset.UTC);
        } else {
            dateTime = this.unexpectedTimestampWithZone(data, fieldDefn);
        }
        return dateTime;
    }

    protected OffsetDateTime unexpectedTimestampWithZone(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIMESTAMP_WITH_TIMEZONE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTimeWithZone(Field fieldDefn, Object data) {
        OffsetTime time = null;
        if (data instanceof OffsetTime) {
            time = (OffsetTime)data;
        } else if (data instanceof java.sql.Time) {
            java.sql.Time sqlTime = (java.sql.Time)data;
            time = OffsetTime.of(sqlTime.toLocalTime(), ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)data;
            time = OffsetTime.ofInstant(date.toInstant(), ZoneOffset.UTC.normalized());
        } else if (data instanceof LocalTime) {
            LocalTime local = (LocalTime)data;
            time = local.atOffset(ZoneOffset.UTC);
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            time = local.toLocalTime().atOffset(ZoneOffset.UTC);
        } else {
            time = this.unexpectedTimeWithZone(data, fieldDefn);
        }
        return time;
    }

    protected OffsetTime unexpectedTimeWithZone(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIME_WITH_TIMEZONE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTimestamp(Field fieldDefn, Object data) {
        java.util.Date date = null;
        if (data instanceof Timestamp) {
            date = (java.util.Date)data;
        } else if (data instanceof Date) {
            date = (java.util.Date)data;
        } else if (data instanceof java.util.Date) {
            date = (java.util.Date)data;
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            date = java.util.Date.from(local.atStartOfDay().toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedTimestamp(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedTimestamp(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIMESTAMP value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTime(Field fieldDefn, Object data) {
        java.util.Date date = null;
        if (data instanceof java.sql.Time) {
            date = (Date)data;
        } else if (data instanceof java.util.Date) {
            date = (java.util.Date)data;
            Instant instant = Instant.ofEpochMilli(date.getTime()).with(ChronoField.EPOCH_DAY, 0L);
            date = new java.util.Date(instant.toEpochMilli());
        } else if (data instanceof LocalTime) {
            LocalTime local = (LocalTime)data;
            date = java.util.Date.from(local.atDate(EPOCH_DAY).toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.with(ChronoField.EPOCH_DAY, 0L).toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedTime(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedTime(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIME value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertDate(Field fieldDefn, Object data) {
        java.util.Date date = null;
        if (data instanceof Date) {
            date = (Date)data;
        } else if (data instanceof java.util.Date) {
            date = (java.util.Date)data;
            Instant instant = Instant.ofEpochMilli(date.getTime()).truncatedTo(ChronoUnit.DAYS);
            date = new java.util.Date(instant.toEpochMilli());
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            date = java.util.Date.from(local.atStartOfDay().toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.truncatedTo(ChronoUnit.DAYS).toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedDate(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedDate(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected static interface ValueConverter {
        public Object convert(Object var1);
    }
}

