/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.function.Predicates;
import java.util.function.Predicate;

@Immutable
public final class TableId
implements Comparable<TableId> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String id;

    public static Predicate<TableId> filter(String dbWhitelist, String dbBlacklist, String tableWhitelist, String tableBlacklist) {
        Predicate<String> dbFilter;
        Predicate<TableId> tableExclusions = tableBlacklist == null ? null : Predicates.blacklist(tableBlacklist, TableId::parse);
        Predicate<TableId> tableInclusions = tableWhitelist == null ? null : Predicates.whitelist(tableWhitelist, TableId::parse);
        Predicate<TableId> tableFilter = tableInclusions != null ? tableInclusions : tableExclusions;
        Predicate<String> dbExclusions = dbBlacklist == null ? null : Predicates.blacklist(dbBlacklist);
        Predicate<String> dbInclusions = dbWhitelist == null ? null : Predicates.whitelist(dbWhitelist);
        Predicate<String> predicate = dbFilter = dbInclusions != null ? dbInclusions : dbExclusions;
        if (dbFilter != null) {
            if (tableFilter != null) {
                return id -> dbFilter.test(id.catalog()) && tableFilter.test((TableId)id);
            }
            return id -> dbFilter.test(id.catalog());
        }
        if (tableFilter != null) {
            return tableFilter;
        }
        return id -> true;
    }

    public static TableId parse(String str) {
        return TableId.parse(str, '.', true);
    }

    public static TableId parse(String str, char delimiter, boolean useCatalogBeforeSchema) {
        String[] parts = str.split("[\\" + delimiter + "]");
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return new TableId(null, null, parts[0]);
        }
        if (parts.length == 2) {
            if (useCatalogBeforeSchema) {
                return new TableId(parts[0], null, parts[1]);
            }
            return new TableId(null, parts[0], parts[1]);
        }
        return new TableId(parts[0], parts[1], parts[2]);
    }

    public TableId(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        assert (this.tableName != null);
        this.id = TableId.tableId(this.catalogName, this.schemaName, this.tableName);
    }

    public String catalog() {
        return this.catalogName;
    }

    public String schema() {
        return this.schemaName;
    }

    public String table() {
        return this.tableName;
    }

    @Override
    public int compareTo(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public int compareToIgnoreCase(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareToIgnoreCase(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableId) {
            return this.compareTo((TableId)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    private static String tableId(String catalog, String schema, String table) {
        if (catalog == null || catalog.length() == 0) {
            if (schema == null || schema.length() == 0) {
                return table;
            }
            return schema + "." + table;
        }
        if (schema == null || schema.length() == 0) {
            return catalog + "." + table;
        }
        return catalog + "." + schema + "." + table;
    }
}

