/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;

public class Predicates {
    public static <T> Predicate<T> whitelist(String input, Function<String, String[]> splitter, Function<String, T> factory) {
        if (input == null) {
            return str -> false;
        }
        HashSet<T> matches = new HashSet<T>();
        for (String item : splitter.apply(input)) {
            T obj = factory.apply(item);
            if (obj == null) continue;
            matches.add(obj);
        }
        return matches::contains;
    }

    public static <T> Predicate<T> whitelist(String input, char delimiter, Function<String, T> factory) {
        return Predicates.whitelist(input, str -> str.split("[" + delimiter + "]"), factory);
    }

    public static <T> Predicate<T> whitelist(String input, Function<String, T> factory) {
        return Predicates.whitelist(input, str -> str.split("[\\,]"), factory);
    }

    public static Predicate<String> whitelist(String input) {
        return Predicates.whitelist(input, str -> str);
    }

    public static <T> Predicate<T> blacklist(String input, Function<String, String[]> splitter, Function<String, T> factory) {
        return Predicates.whitelist(input, splitter, factory).negate();
    }

    public static <T> Predicate<T> blacklist(String input, char delimiter, Function<String, T> factory) {
        return Predicates.whitelist(input, delimiter, factory).negate();
    }

    public static <T> Predicate<T> blacklist(String input, Function<String, T> factory) {
        return Predicates.whitelist(input, factory).negate();
    }

    public static Predicate<String> blacklist(String input) {
        return Predicates.whitelist(input).negate();
    }

    public static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> notNull() {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return t != null;
            }
        };
    }

    private Predicates() {
    }
}

