/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.annotation.Immutable;
import io.debezium.config.Field;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public interface Configuration {
    public static Builder create() {
        return new Builder();
    }

    public static Builder copy(Configuration config) {
        return new Builder(config.asProperties());
    }

    public static Configuration fromSystemProperties(String prefix) {
        return Configuration.empty().withSystemProperties(prefix);
    }

    public static Configuration empty() {
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collections.emptySet();
            }

            @Override
            public String getString(String key) {
                return null;
            }

            public String toString() {
                return "{}";
            }
        };
    }

    public static Configuration from(final Properties properties) {
        final Properties props = new Properties();
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        return new Configuration(){

            @Override
            public String getString(String key) {
                return properties.getProperty(key);
            }

            @Override
            public Set<String> keys() {
                return properties.stringPropertyNames();
            }

            public String toString() {
                return props.toString();
            }
        };
    }

    public static Configuration from(final Map<String, String> properties) {
        final HashMap<String, String> props = new HashMap<String, String>();
        if (properties != null) {
            props.putAll(properties);
        }
        return new Configuration(){

            @Override
            public String getString(String key) {
                return (String)properties.get(key);
            }

            @Override
            public Set<String> keys() {
                return properties.keySet();
            }

            public String toString() {
                return props.toString();
            }
        };
    }

    public static Configuration load(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            Configuration configuration = Configuration.load(stream);
            return configuration;
        }
    }

    public static Configuration load(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Configuration configuration = Configuration.load(stream);
            return configuration;
        }
    }

    public static Configuration load(InputStream stream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            Configuration configuration = Configuration.from(properties);
            return configuration;
        }
        finally {
            stream.close();
        }
    }

    public static Configuration load(Reader reader) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(reader);
            Configuration configuration = Configuration.from(properties);
            return configuration;
        }
        finally {
            reader.close();
        }
    }

    public static Configuration load(String path, Class<?> clazz) throws IOException {
        return Configuration.load(path, clazz.getClassLoader());
    }

    public static Configuration load(String path, ClassLoader classLoader) throws IOException {
        Logger logger = LoggerFactory.getLogger(Configuration.class);
        return Configuration.load(path, classLoader, arg_0 -> ((Logger)logger).debug(arg_0));
    }

    public static Configuration load(String path, ClassLoader classLoader, Consumer<String> logger) throws IOException {
        try (InputStream stream = IoUtil.getResourceAsStream(path, classLoader, null, null, logger);){
            Properties props = new Properties();
            if (stream != null) {
                props.load(stream);
            }
            Configuration configuration = Configuration.from(props);
            return configuration;
        }
    }

    default public Builder edit() {
        return Configuration.copy(this);
    }

    default public boolean hasKey(String key) {
        return this.getString(key) != null;
    }

    public Set<String> keys();

    public String getString(String var1);

    default public String getString(String key, String defaultValue) {
        return this.getString(key, () -> defaultValue);
    }

    default public String getString(String key, Supplier<String> defaultValueSupplier) {
        String value = this.getString(key);
        return value != null ? value : (defaultValueSupplier != null ? defaultValueSupplier.get() : null);
    }

    default public String getString(Field field) {
        return this.getString(field.name(), field.defaultValue());
    }

    default public String getString(Field field, String defaultValue) {
        return this.getString(field.name(), () -> field.defaultValue());
    }

    default public List<String> getStrings(String key, String regex) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Collect.arrayListOf(value.split(regex));
    }

    default public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    default public Long getLong(String key) {
        return this.getLong(key, null);
    }

    default public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    default public int getInteger(String key, int defaultValue) {
        return this.getInteger(key, () -> defaultValue);
    }

    default public long getLong(String key, long defaultValue) {
        return this.getLong(key, () -> defaultValue);
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, () -> defaultValue);
    }

    default public Integer getInteger(String key, IntSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValueSupplier != null ? Integer.valueOf(defaultValueSupplier.getAsInt()) : null;
    }

    default public Long getLong(String key, LongSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValueSupplier != null ? Long.valueOf(defaultValueSupplier.getAsLong()) : null;
    }

    default public Boolean getBoolean(String key, BooleanSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            if (Boolean.valueOf(value = value.trim().toLowerCase()).booleanValue()) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValueSupplier != null ? Boolean.valueOf(defaultValueSupplier.getAsBoolean()) : null;
    }

    default public int getInteger(Field field) {
        return this.getInteger(field.name(), () -> Integer.valueOf(field.defaultValue()));
    }

    default public long getLong(Field field) {
        return this.getLong(field.name(), () -> Long.valueOf(field.defaultValue()));
    }

    default public boolean getBoolean(Field field) {
        return this.getBoolean(field.name(), () -> Boolean.valueOf(field.defaultValue()));
    }

    default public int getInteger(Field field, int defaultValue) {
        return this.getInteger(field.name(), defaultValue);
    }

    default public long getLong(Field field, long defaultValue) {
        return this.getLong(field.name(), defaultValue);
    }

    default public boolean getBoolean(Field field, boolean defaultValue) {
        return this.getBoolean(field.name(), defaultValue);
    }

    default public Integer getInteger(Field field, IntSupplier defaultValueSupplier) {
        return this.getInteger(field.name(), defaultValueSupplier);
    }

    default public Long getLong(Field field, LongSupplier defaultValueSupplier) {
        return this.getLong(field.name(), defaultValueSupplier);
    }

    default public Boolean getBoolean(Field field, BooleanSupplier defaultValueSupplier) {
        return this.getBoolean(field.name(), defaultValueSupplier);
    }

    default public String getString(Field field, Supplier<String> defaultValueSupplier) {
        return this.getString(field.name(), defaultValueSupplier);
    }

    default public <T> T getInstance(String key, Class<T> type) {
        return this.getInstance(key, type, () -> this.getClass().getClassLoader());
    }

    default public <T> T getInstance(String key, Class<T> type, Supplier<ClassLoader> classloaderSupplier) {
        String className = this.getString(key);
        if (className != null) {
            ClassLoader classloader = classloaderSupplier != null ? classloaderSupplier.get() : this.getClass().getClassLoader();
            try {
                Class<?> clazz = classloader.loadClass(className);
                return (T)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to find class {}", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to instantiate class {}", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to access class {}", (Object)className, (Object)e);
            }
        }
        return null;
    }

    default public <T> T getInstance(Field field, Class<T> clazz) {
        return this.getInstance(field, clazz, () -> this.getClass().getClassLoader());
    }

    default public <T> T getInstance(Field field, Class<T> type, Supplier<ClassLoader> classloaderSupplier) {
        String className = this.getString(field);
        if (className != null) {
            ClassLoader classloader = classloaderSupplier != null ? classloaderSupplier.get() : this.getClass().getClassLoader();
            try {
                Class<?> clazz = classloader.loadClass(className);
                return (T)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to find class {}", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to instantiate class {}", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to access class {}", (Object)className, (Object)e);
            }
        }
        return null;
    }

    default public Configuration subset(String prefix, boolean removePrefix) {
        if (prefix == null) {
            return this;
        }
        if ((prefix = prefix.trim()).isEmpty()) {
            return this;
        }
        String prefixWithSeparator = prefix.endsWith(".") ? prefix : prefix + ".";
        int minLength = prefixWithSeparator.length();
        Function<String, String> prefixRemover = removePrefix ? key -> key.substring(minLength) : key -> key;
        return this.filter(key -> key != null && key.startsWith(prefixWithSeparator)).map(prefixRemover);
    }

    default public Configuration map(Function<String, String> mapper) {
        if (mapper == null) {
            return this;
        }
        final HashMap newToOld = new HashMap();
        this.keys().stream().filter((? super T k) -> k != null).forEach(oldKey -> {
            String newKey = (String)mapper.apply((String)oldKey);
            if (newKey != null) {
                newToOld.put(newKey, oldKey);
            }
        });
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collect.unmodifiableSet(newToOld.keySet());
            }

            @Override
            public String getString(String key) {
                String oldKey = (String)newToOld.get(key);
                return Configuration.this.getString(oldKey);
            }

            public String toString() {
                return this.asProperties().toString();
            }
        };
    }

    default public Configuration filter(final Predicate<? super String> matcher) {
        if (matcher == null) {
            return this;
        }
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collect.unmodifiableSet(Configuration.this.keys().stream().filter((? super T k) -> k != null).filter(matcher).collect(Collectors.toSet()));
            }

            @Override
            public String getString(String key) {
                return matcher.test(key) ? Configuration.this.getString(key) : null;
            }

            public String toString() {
                return this.asProperties().toString();
            }
        };
    }

    default public boolean isEmpty() {
        return this.keys().isEmpty();
    }

    default public Properties asProperties() {
        Properties props = new Properties();
        this.keys().forEach(key -> {
            String value = this.getString((String)key);
            if (key != null && value != null) {
                props.setProperty((String)key, value);
            }
        });
        return props;
    }

    default public Map<String, String> asMap() {
        HashMap<String, String> props = new HashMap<String, String>();
        this.keys().forEach(key -> {
            String value = this.getString((String)key);
            if (key != null && value != null) {
                props.put((String)key, value);
            }
        });
        return props;
    }

    default public Configuration withSystemProperties(String prefix) {
        int prefixLength = prefix.length();
        return this.withSystemProperties((String input) -> {
            String withoutPrefix;
            if (input.startsWith(prefix) && (withoutPrefix = input.substring(prefixLength).trim()).length() > 0) {
                return withoutPrefix.toLowerCase().replaceAll("[_]", ".");
            }
            return null;
        });
    }

    default public Configuration withSystemProperties(Function<String, String> propertyNameConverter) {
        Properties props = this.asProperties();
        Properties systemProperties = System.getProperties();
        for (String key : systemProperties.stringPropertyNames()) {
            String propName = propertyNameConverter.apply(key);
            if (propName == null || propName.length() <= 0) continue;
            String value = systemProperties.getProperty(key);
            props.setProperty(propName, value);
        }
        return Configuration.from(props);
    }

    default public boolean validate(Iterable<Field> fields, Consumer<String> problems) {
        boolean valid = true;
        for (Field field : fields) {
            if (field.validate(this, problems)) continue;
            valid = false;
        }
        return valid;
    }

    default public boolean validate(Field[] fields, Consumer<String> problems) {
        boolean valid = true;
        for (Field field : fields) {
            if (field.validate(this, problems)) continue;
            valid = false;
        }
        return valid;
    }

    public static class Builder
    implements ConfigBuilder<Configuration, Builder> {
        private final Properties props = new Properties();

        protected Builder() {
        }

        protected Builder(Properties props) {
            this.props.putAll((Map<?, ?>)props);
        }

        @Override
        public Builder with(String key, String value) {
            this.props.setProperty(key, value);
            return this;
        }

        @Override
        public Builder withDefault(String key, String value) {
            if (!this.props.containsKey(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        @Override
        public Builder apply(Consumer<Builder> function) {
            function.accept(this);
            return this;
        }

        @Override
        public Configuration build() {
            return Configuration.from(this.props);
        }
    }

    public static interface ConfigBuilder<C extends Configuration, B extends ConfigBuilder<C, B>> {
        public B with(String var1, String var2);

        default public B with(String key, Object value) {
            return this.with(key, value != null ? value.toString() : null);
        }

        default public B with(String key, int value) {
            return this.with(key, Integer.toString(value));
        }

        default public B with(String key, float value) {
            return this.with(key, Float.toString(value));
        }

        default public B with(String key, double value) {
            return this.with(key, Double.toString(value));
        }

        default public B with(String key, long value) {
            return this.with(key, Long.toString(value));
        }

        default public B with(String key, boolean value) {
            return this.with(key, Boolean.toString(value));
        }

        default public B with(String key, Class<?> value) {
            return this.with(key, value != null ? value.getName() : null);
        }

        public B withDefault(String var1, String var2);

        default public B withDefault(String key, Object value) {
            return this.withDefault(key, value != null ? value.toString() : null);
        }

        default public B withDefault(String key, int value) {
            return this.withDefault(key, Integer.toString(value));
        }

        default public B withDefault(String key, float value) {
            return this.withDefault(key, Float.toString(value));
        }

        default public B withDefault(String key, double value) {
            return this.withDefault(key, Double.toString(value));
        }

        default public B withDefault(String key, long value) {
            return this.withDefault(key, Long.toString(value));
        }

        default public B withDefault(String key, boolean value) {
            return this.withDefault(key, Boolean.toString(value));
        }

        default public B withDefault(String key, Class<?> value) {
            return this.withDefault(key, value != null ? value.getName() : null);
        }

        default public B with(Field field, String value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, Object value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, int value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, float value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, double value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, long value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, boolean value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, Class<?> value) {
            return this.with(field.name(), value);
        }

        default public B withDefault(Field field, String value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, Object value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, int value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, float value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, double value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, long value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, boolean value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, Class<?> value) {
            return this.withDefault(field.name(), value != null ? value.getName() : null);
        }

        public B apply(Consumer<B> var1);

        public C build();
    }
}

