/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.kafka.KafkaCluster;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserSql2003;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.io.File;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class KafkaDatabaseHistoryTest {
    private Configuration config;
    private KafkaDatabaseHistory history;
    private KafkaCluster kafka;
    private File dataDir;
    private Map<String, String> source;
    private Map<String, Object> position;
    private String topicName;
    private String ddl;

    @Before
    public void beforeEach() throws Exception {
        this.source = Collect.hashMapOf((Object)"server", (Object)"my-server");
        this.setLogPosition(0);
        this.topicName = "schema-changes-topic";
        this.dataDir = Testing.Files.createTestingDirectory("cluster");
        Testing.Files.delete(this.dataDir);
        this.kafka = new KafkaCluster().usingDirectory(this.dataDir).deleteDataPriorToStartup(true).deleteDataUponShutdown(true).addBrokers(1).startup();
        this.history = new KafkaDatabaseHistory();
    }

    @After
    public void afterEach() {
        try {
            if (this.history != null) {
                this.history.stop();
            }
        }
        finally {
            this.history = null;
            try {
                if (this.kafka != null) {
                    this.kafka.shutdown();
                }
            }
            finally {
                this.kafka = null;
            }
        }
    }

    @Test
    public void shouldStartWithEmptyTopicAndStoreDataAndRecoverAllState() throws Exception {
        this.kafka.createTopic(this.topicName, 1, 1);
        this.config = ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, this.kafka.brokerList())).with(KafkaDatabaseHistory.TOPIC, this.topicName)).build();
        this.history.configure(this.config);
        this.history.start();
        DdlParserSql2003 recoveryParser = new DdlParserSql2003();
        DdlParserSql2003 ddlParser = new DdlParserSql2003();
        ddlParser.setCurrentSchema("db1");
        Tables tables1 = new Tables();
        Tables tables2 = new Tables();
        Tables tables3 = new Tables();
        this.setLogPosition(0);
        this.history.recover(this.source, this.position, tables1, (DdlParser)recoveryParser);
        Assertions.assertThat((int)tables1.size()).isEqualTo(0);
        this.setLogPosition(10);
        this.ddl = "CREATE TABLE foo ( name VARCHAR(255) NOT NULL PRIMARY KEY); \nCREATE TABLE customers ( id INTEGER NOT NULL PRIMARY KEY, name VARCHAR(100) NOT NULL ); \nCREATE TABLE products ( productId INTEGER NOT NULL PRIMARY KEY, desc VARCHAR(255) NOT NULL); \n";
        this.history.record(this.source, this.position, "db1", tables1, this.ddl);
        ddlParser.parse(this.ddl, tables1);
        Assertions.assertThat((int)tables1.size()).isEqualTo(3);
        ddlParser.parse(this.ddl, tables2);
        Assertions.assertThat((int)tables2.size()).isEqualTo(3);
        ddlParser.parse(this.ddl, tables3);
        Assertions.assertThat((int)tables3.size()).isEqualTo(3);
        this.setLogPosition(39);
        this.ddl = "DROP TABLE foo;";
        this.history.record(this.source, this.position, "db1", tables2, this.ddl);
        ddlParser.parse(this.ddl, tables2);
        Assertions.assertThat((int)tables2.size()).isEqualTo(2);
        ddlParser.parse(this.ddl, tables3);
        Assertions.assertThat((int)tables3.size()).isEqualTo(2);
        this.setLogPosition(10003);
        this.ddl = "CREATE TABLE suppliers ( supplierId INTEGER NOT NULL PRIMARY KEY, name VARCHAR(255) NOT NULL);";
        this.history.record(this.source, this.position, "db1", tables3, this.ddl);
        ddlParser.parse(this.ddl, tables3);
        Assertions.assertThat((int)tables3.size()).isEqualTo(3);
        this.history.stop();
        this.history = new KafkaDatabaseHistory();
        this.history.configure(this.config);
        Tables recoveredTables = new Tables();
        this.setLogPosition(15);
        this.history.recover(this.source, this.position, recoveredTables, (DdlParser)recoveryParser);
        Assertions.assertThat((Object)recoveredTables).isEqualTo((Object)tables1);
        recoveredTables = new Tables();
        this.setLogPosition(50);
        this.history.recover(this.source, this.position, recoveredTables, (DdlParser)recoveryParser);
        Assertions.assertThat((Object)recoveredTables).isEqualTo((Object)tables2);
        recoveredTables = new Tables();
        this.setLogPosition(10010);
        this.history.recover(this.source, this.position, recoveredTables, (DdlParser)recoveryParser);
        Assertions.assertThat((Object)recoveredTables).isEqualTo((Object)tables3);
        recoveredTables = new Tables();
        this.setLogPosition(100000010);
        this.history.recover(this.source, this.position, recoveredTables, (DdlParser)recoveryParser);
        Assertions.assertThat((Object)recoveredTables).isEqualTo((Object)tables3);
    }

    protected void setLogPosition(int index) {
        this.position = Collect.hashMapOf((Object)"filename", (Object)"my-txn-file.log", (Object)"position", (Object)index);
    }
}

