/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.TableId;
import java.util.function.Predicate;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class TableIdTest {
    private Predicate<TableId> filter;

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndTableWhitelist() {
        this.filter = TableId.filter((String)"db1,db2", null, (String)"db1.A,db1.B,db2.C", null);
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndTableBlacklist() {
        this.filter = TableId.filter((String)"db1,db2", null, null, (String)"db1.A,db1.B,db2.C");
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndTableWhitelist() {
        this.filter = TableId.filter(null, (String)"db3,db4", (String)"db1.A,db1.B,db2.C", null);
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndTableBlacklist() {
        this.filter = TableId.filter(null, (String)"db3,db4", null, (String)"db1.A,db1.B,db2.C");
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithNoDatabaseFilterAndTableWhitelist() {
        this.filter = TableId.filter(null, null, (String)"db1.A,db1.B,db2.C", null);
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithNoDatabaseFilterAndTableBlacklist() {
        this.filter = TableId.filter(null, null, null, (String)"db1.A,db1.B,db2.C");
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertAllowed(this.filter, "db3", "A");
        this.assertAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndNoTableFilter() {
        this.filter = TableId.filter((String)"db1,db2", null, null, null);
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db2", "A");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndNoTableFilter() {
        this.filter = TableId.filter(null, (String)"db1,db2", null, null);
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db2", "A");
        this.assertAllowed(this.filter, "db3", "A");
        this.assertAllowed(this.filter, "db4", "A");
    }

    protected void assertAllowed(Predicate<TableId> filter, String dbName, String tableName) {
        TableId id = new TableId(dbName, null, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isTrue();
    }

    protected void assertNotAllowed(Predicate<TableId> filter, String dbName, String tableName) {
        TableId id = new TableId(dbName, null, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isFalse();
    }
}

