package io.debezium.annotation;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PACKAGE;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation that can be used to specify that the target field, method, constructor, package or type is read-only.
 * 
 * @see Immutable
 */
@Documented
@Retention( RUNTIME )
@Target( {FIELD, METHOD, CONSTRUCTOR, PACKAGE, TYPE} )
public @interface ReadOnly {

}