/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.rest.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.Config;

public class ValidationResults {
    public Status status;
    public final List<ValidationResult> validationResults;

    public ValidationResults(Config validatedConfig) {
        this.validationResults = this.convertConfigToValidationResults(validatedConfig);
        this.status = this.validationResults.isEmpty() ? Status.VALID : Status.INVALID;
    }

    private List<ValidationResult> convertConfigToValidationResults(Config result) {
        return result.configValues().stream().filter(cv -> !cv.errorMessages().isEmpty()).filter(cv -> !((String)cv.errorMessages().get(0)).equals(cv.name() + " is referred in the dependents, but not defined.")).map(cv -> new ValidationResult(cv.name(), (String)cv.errorMessages().get(0))).collect(Collectors.toList());
    }

    public static enum Status {
        VALID,
        INVALID;

    }

    public static class ValidationResult {
        public String property;
        public String message;

        public ValidationResult(String property, String message) {
            this.property = property;
            this.message = message;
        }
    }
}

