/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.AbstractSnapshotTest;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IncrementalSnapshotCollationSortOrderMismatchIT
extends AbstractSnapshotTest<SqlServerConnector> {
    private static final int POLLING_INTERVAL = 1;
    private static final String SQL_COLLATION = "SQL_Latin1_General_CP1_CI_AS";
    private static final List<String> ALL_IDS = new ArrayList<String>();
    private static final List<String> SKIPPED_IDS = new ArrayList<String>();
    private SqlServerConnection connection;
    private boolean isSendStringParametersAsUnicode;

    @BeforeClass
    public static void beforeClass() throws IOException {
        IoUtil.readLines((String)"dbz-7359-ids.txt", (ClassLoader)IncrementalSnapshotCollationSortOrderMismatchIT.class.getClassLoader(), IncrementalSnapshotCollationSortOrderMismatchIT.class, ALL_IDS::add);
        SKIPPED_IDS.addAll(ALL_IDS.subList(ALL_IDS.indexOf("Y-11-3-4") + 1, ALL_IDS.indexOf("Y1-01-1-1")));
    }

    @Test
    public void orderMismatchPkCharValueIntParamsAsUnicodeFalse() throws Exception {
        this.orderMismatchPkTypecharValueInt(false, ALL_IDS.size(), "char(50) COLLATE SQL_Latin1_General_CP1_CI_AS");
    }

    @Test
    public void orderMismatchPkCharValueIntParamsAsUnicodeTrueSkip36() throws Exception {
        this.orderMismatchPkTypecharValueInt(true, ALL_IDS.size() - SKIPPED_IDS.size(), "char(50) COLLATE SQL_Latin1_General_CP1_CI_AS");
    }

    @Test
    public void orderMismatchPkVarcharValueIntParamsAsUnicodeFalse() throws Exception {
        this.orderMismatchPkTypecharValueInt(false, ALL_IDS.size(), "varchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS");
    }

    @Test
    public void orderMismatchPkVarcharValueIntParamsAsUnicodeTrueSkip36() throws Exception {
        this.orderMismatchPkTypecharValueInt(true, ALL_IDS.size() - SKIPPED_IDS.size(), "varchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS");
    }

    @Test
    public void orderMismatchPkVarcharValueNvarcharParamsAsUnicodeFalse() throws Exception {
        this.orderMismatchPkVarcharValueNvarchar(false, ALL_IDS.size());
    }

    @Test
    public void orderMismatchPkVarcharValueNvarcharParamsAsUnicodeTrueSkip36() throws Exception {
        this.orderMismatchPkVarcharValueNvarchar(true, ALL_IDS.size() - SKIPPED_IDS.size());
    }

    @Test
    public void orderMismatchPkNcharValueNvarcharParamsAsUnicodeFalse() throws Exception {
        this.orderMismatchPkNtypeValueNvarchar(false, ALL_IDS.size(), "nchar(50)");
    }

    @Test
    public void orderMismatchPkNcharValueNvarcharParamsAsUnicodeTrue() throws Exception {
        this.orderMismatchPkNtypeValueNvarchar(true, ALL_IDS.size(), "nchar(50)");
    }

    @Test
    public void orderMismatchPkNvarcharValueNvarcharParamsAsUnicodeFalse() throws Exception {
        this.orderMismatchPkNtypeValueNvarchar(false, ALL_IDS.size(), "nvarchar(50)");
    }

    @Test
    public void orderMismatchPkNvarcharValueNvarcharParamsAsUnicodeTrue() throws Exception {
        this.orderMismatchPkNtypeValueNvarchar(true, ALL_IDS.size(), "nvarchar(50)");
    }

    protected void orderMismatchPkTypecharValueInt(boolean isSendStringParametersAsUnicode, int expectedRecordCount, String pkDataType) throws Exception {
        this.runTest(isSendStringParametersAsUnicode, expectedRecordCount, pkDataType, (pk, _idx) -> String.format("'%s'", pk), pk -> pk.getString(this.pkFieldName()).trim(), "int", (_pk, idx) -> String.format("%d", idx), record -> ((Struct)record.value()).getStruct("after").getInt32(this.valueFieldName()), dbChanges -> {
            boolean result = true;
            for (int i = 0; i < ALL_IDS.size(); ++i) {
                Integer val;
                String id = ALL_IDS.get(i);
                if (isSendStringParametersAsUnicode && SKIPPED_IDS.contains(id) || (val = (Integer)dbChanges.get(id)) != null && val == i) continue;
                result = false;
                Testing.printError((Object)(ALL_IDS.get(i) + " value is not = " + i + ", is = " + val));
                break;
            }
            return result;
        });
    }

    protected void orderMismatchPkVarcharValueNvarchar(boolean isSendStringParametersAsUnicode, int expectedRecordCount) throws Exception {
        this.runTest(isSendStringParametersAsUnicode, expectedRecordCount, "varchar(50) COLLATE SQL_Latin1_General_CP1_CI_AS", (pk, _idx) -> String.format("'%s'", pk), pk -> pk.getString(this.pkFieldName()), "nvarchar(100) not null", (_pk, idx) -> String.format("N'%d Hiragana: \u306e, \u306f, \u3067\u3057\u305f, Katakana: \u30b3\u30f3\u30b5\u30fc\u30c8, Kanji: \u6628\u591c, \u6700\u9ad8'", idx), record -> ((Struct)record.value()).getStruct("after").getString(this.valueFieldName()), dbChanges -> {
            boolean result = true;
            for (int i = 0; i < ALL_IDS.size(); ++i) {
                String val;
                String expectedVal;
                String id = ALL_IDS.get(i);
                if (isSendStringParametersAsUnicode && SKIPPED_IDS.contains(id) || (expectedVal = String.format("%d Hiragana: \u306e, \u306f, \u3067\u3057\u305f, Katakana: \u30b3\u30f3\u30b5\u30fc\u30c8, Kanji: \u6628\u591c, \u6700\u9ad8", i)).equals(val = (String)dbChanges.get(ALL_IDS.get(i)))) continue;
                result = false;
                Testing.printError((Object)(ALL_IDS.get(i) + " value is not = " + expectedVal + ", is = " + val));
                break;
            }
            return result;
        });
    }

    protected void orderMismatchPkNtypeValueNvarchar(boolean isSendStringParametersAsUnicode, int expectedRecordCount, String pkDataType) throws Exception {
        this.runTest(isSendStringParametersAsUnicode, expectedRecordCount, pkDataType, (pk, _idx) -> String.format("N'\u306e %s'", pk), pk -> pk.getString(this.pkFieldName()).trim(), "nvarchar(100) not null", (_pk, idx) -> String.format("N'%d Hiragana: \u306e, \u306f, \u3067\u3057\u305f, Katakana: \u30b3\u30f3\u30b5\u30fc\u30c8, Kanji: \u6628\u591c, \u6700\u9ad8'", idx), record -> ((Struct)record.value()).getStruct("after").getString(this.valueFieldName()), dbChanges -> {
            boolean result = true;
            for (int i = 0; i < ALL_IDS.size(); ++i) {
                String expectedVal = String.format("%d Hiragana: \u306e, \u306f, \u3067\u3057\u305f, Katakana: \u30b3\u30f3\u30b5\u30fc\u30c8, Kanji: \u6628\u591c, \u6700\u9ad8", i);
                String val = (String)dbChanges.get(String.format("\u306e %s", ALL_IDS.get(i)));
                if (expectedVal.equals(val)) continue;
                result = false;
                System.err.println(ALL_IDS.get(i) + " value is not = " + expectedVal + ", is = " + val);
                break;
            }
            return result;
        });
    }

    protected <P, V> void runTest(boolean isSendStringParametersAsUnicode, int expectedRecordCount, String pkDataType, BiFunction<String, Integer, String> pkInsValFn, Function<Struct, P> pkConverter, String valueDataType, BiFunction<String, Integer, String> valueInsValFn, Function<SourceRecord, V> valueConverter, Predicate<Map<P, V>> validateDbChanges) throws Exception {
        this.isSendStringParametersAsUnicode = isSendStringParametersAsUnicode;
        TestHelper.createTestDatabase();
        try (SqlServerConnection connection = TestHelper.testConnection("testDB1");){
            this.connection = connection;
            connection.execute(new String[]{String.format("CREATE TABLE %s (%s %s primary key, %s %s)", this.tableName(), this.pkFieldName(), pkDataType, this.valueFieldName(), valueDataType), "CREATE TABLE debezium_signal (id varchar(64), type varchar(32), data varchar(2048))"});
            TestHelper.enableTableCdc(connection, "debezium_signal");
            TestHelper.adjustCdcPollingInterval((JdbcConnection)connection, 1);
            this.initializeConnectorTestFramework();
            Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
            this.populateTable(connection, pkInsValFn, valueInsValFn);
            TestHelper.enableTableCdc(connection, this.tableName());
            this.startConnector();
            this.sendAdHocSnapshotSignal(new String[]{this.tableName()});
            this.testIncrementalSnapshotConsumed(expectedRecordCount, pkConverter, valueConverter, validateDbChanges);
        }
    }

    protected void populateTable(SqlServerConnection connection, BiFunction<String, Integer, String> pkInsValFn, BiFunction<String, Integer, String> valueInsValFn) throws SQLException {
        connection.setAutoCommit(false);
        for (int i = 0; i < ALL_IDS.size(); ++i) {
            String id = ALL_IDS.get(i);
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, %s) VALUES(%s, %s)", this.tableName(), this.pkFieldName(), this.valueFieldName(), pkInsValFn.apply(id, i), valueInsValFn.apply(id, i))});
        }
        connection.commit();
    }

    protected <P, V> void testIncrementalSnapshotConsumed(int expectedRecordCount, Function<Struct, P> pkConverter, Function<SourceRecord, V> valueConverter, Predicate<Map<P, V>> validateDbChanges) throws InterruptedException {
        Map<P, V> dbChanges = this.consumeIncrementalSnapshot(expectedRecordCount, x -> true, pkConverter, valueConverter, this.topicName(), null, true);
        Assertions.assertThat(dbChanges).hasSize(expectedRecordCount);
        Assert.assertTrue((boolean)validateDbChanges.test(dbChanges));
    }

    protected <P, V> Map<P, V> consumeIncrementalSnapshot(int recordCount, Predicate<Map.Entry<P, V>> dataCompleted, Function<Struct, P> pkConverter, Function<SourceRecord, V> valueConverter, String topicName, Consumer<List<SourceRecord>> recordConsumer, boolean assertRecords) throws InterruptedException {
        HashMap dbChanges = new HashMap();
        int noRecords = 0;
        while (true) {
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1, assertRecords);
            List dataRecords = records.recordsForTopic(topicName);
            if (records.allRecordsInOrder().isEmpty()) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)(++noRecords)).describedAs(String.format("Too many no data record results, %d < %d", dbChanges.size(), recordCount), new Object[0])).isLessThanOrEqualTo(5);
                continue;
            }
            noRecords = 0;
            if (dataRecords == null || dataRecords.isEmpty()) continue;
            dataRecords.forEach(record -> {
                Object id = pkConverter.apply((Struct)record.key());
                Object value = valueConverter.apply((SourceRecord)record);
                dbChanges.put(id, value);
            });
            if (recordConsumer != null) {
                recordConsumer.accept(dataRecords);
            }
            if (dbChanges.size() >= recordCount && dbChanges.entrySet().stream().noneMatch(dataCompleted.negate())) break;
        }
        return dbChanges;
    }

    protected Class<SqlServerConnector> connectorClass() {
        return SqlServerConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "server1.testDB1.dbo.c";
    }

    protected String tableName() {
        return "testDB1.dbo.c";
    }

    protected List<String> topicNames() {
        throw new UnsupportedOperationException();
    }

    protected List<String> tableNames() {
        throw new UnsupportedOperationException();
    }

    protected String signalTableName() {
        return "dbo.debezium_signal";
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with("database.sendStringParametersAsUnicode", this.isSendStringParametersAsUnicode)).with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.SIGNAL_DATA_COLLECTION, "testDB1.dbo.debezium_signal")).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        throw new UnsupportedOperationException();
    }

    protected String connector() {
        return "sql_server";
    }

    protected String server() {
        return "server1";
    }
}

