/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerJdbcConfiguration;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorConfigTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorConfigTest.class);

    @Test
    public void nullDatabaseNames() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(this.defaultConfig().build());
        Assert.assertFalse((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void emptyDatabaseNames() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.DATABASE_NAMES, "")).build());
        Assert.assertFalse((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void nonEmptyDatabaseNames() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.DATABASE_NAMES, "testDB1")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void hostnameAndDefaultPortConnectionUrl() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.HOSTNAME, "example.com")).build());
        Assert.assertEquals((Object)this.connectionUrl(connectorConfig), (Object)"jdbc:sqlserver://${hostname}:${port}");
    }

    @Test
    public void hostnameAndPortConnectionUrl() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.HOSTNAME, "example.com")).with(SqlServerConnectorConfig.PORT, "11433")).build());
        Assert.assertEquals((Object)this.connectionUrl(connectorConfig), (Object)"jdbc:sqlserver://${hostname}:${port}");
    }

    @Test
    public void hostnameAndInstanceConnectionUrl() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.HOSTNAME, "example.com")).with(SqlServerConnectorConfig.INSTANCE, "instance")).build());
        Assert.assertEquals((Object)this.connectionUrl(connectorConfig), (Object)"jdbc:sqlserver://${hostname}\\instance");
    }

    @Test
    public void hostnameAndInstanceAndPortConnectionUrl() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.HOSTNAME, "example.com")).with(SqlServerConnectorConfig.INSTANCE, "instance")).with(SqlServerConnectorConfig.PORT, "11433")).build());
        Assert.assertEquals((Object)this.connectionUrl(connectorConfig), (Object)"jdbc:sqlserver://${hostname}\\instance:${port}");
    }

    @Test
    public void validQueryFetchSizeDefaults() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(CommonConnectorConfig.TOPIC_PREFIX, "myserver")).build());
        Assert.assertEquals((long)connectorConfig.getQueryFetchSize(), (long)10000L);
    }

    @Test
    public void validQueryFetchSizeAvailable() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)((Configuration.Builder)this.defaultConfig().with(CommonConnectorConfig.TOPIC_PREFIX, "myserver")).with(SqlServerConnectorConfig.QUERY_FETCH_SIZE, 20000)).build());
        Assert.assertEquals((long)connectorConfig.getQueryFetchSize(), (long)20000L);
    }

    private Configuration.Builder defaultConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server")).with(SqlServerConnectorConfig.HOSTNAME, "localhost")).with(SqlServerConnectorConfig.USER, "debezium")).with(KafkaSchemaHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaSchemaHistory.TOPIC, "history");
    }

    private String connectionUrl(SqlServerConnectorConfig connectorConfig) {
        SqlServerJdbcConfiguration jdbcConfig = connectorConfig.getJdbcConfig();
        return SqlServerConnection.createUrlPattern((SqlServerJdbcConfiguration)jdbcConfig, (boolean)false);
    }
}

