/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.bean.StandardBeanNames;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.snapshot.query.SelectAllSnapshotQuery;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CustomTestSnapshot
extends SelectAllSnapshotQuery
implements Snapshotter,
BeanRegistryAware {
    private boolean hasState;

    public String name() {
        return CustomTestSnapshot.class.getName();
    }

    public void injectBeanRegistry(BeanRegistry beanRegistry) {
        Offsets sqlServerOffsetContextOffsets = (Offsets)beanRegistry.lookupByName(StandardBeanNames.OFFSETS, Offsets.class);
        for (SqlServerOffsetContext offset : sqlServerOffsetContextOffsets.getOffsets().values()) {
            this.hasState = offset != null;
        }
    }

    public boolean shouldSnapshotData(boolean offsetExists, boolean snapshotInProgress) {
        return true;
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshotSchema(boolean offsetExists, boolean snapshotInProgress) {
        return true;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }

    public Optional<String> snapshotQuery(String tableId, List<String> snapshotSelectColumns) {
        if (!this.hasState && tableId.contains("tableb")) {
            return Optional.empty();
        }
        String query = snapshotSelectColumns.stream().collect(Collectors.joining(", ", "SELECT ", " FROM " + tableId));
        return Optional.of(query);
    }
}

