/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.AbstractSnapshotProvider;
import io.debezium.snapshot.spi.SnapshotQuery;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotQueryProvider
extends AbstractSnapshotProvider
implements ServiceProvider<SnapshotQuery> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotQueryProvider.class);
    final List<SnapshotQuery> snapshotQueryImplementations;

    public SnapshotQueryProvider() {
        this.snapshotQueryImplementations = StreamSupport.stream(ServiceLoader.load(SnapshotQuery.class).spliterator(), false).collect(Collectors.toList());
    }

    public SnapshotQueryProvider(List<SnapshotQuery> snapshotQueryImplementations) {
        this.snapshotQueryImplementations = snapshotQueryImplementations;
    }

    @Override
    public SnapshotQuery createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        Predicate<SnapshotQuery> byNameFilter;
        Predicate<SnapshotQuery> byNameAndConnectorFilter;
        String snapshotQueryMode;
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        EnumeratedValue configuredSnapshotQueryMode = commonConnectorConfig.snapshotQueryMode();
        String snapshotQueryModeCustomName = commonConnectorConfig.snapshotQueryModeCustomName();
        if (CommonConnectorConfig.SnapshotQueryMode.CUSTOM.equals(configuredSnapshotQueryMode) && !snapshotQueryModeCustomName.isEmpty()) {
            snapshotQueryMode = snapshotQueryModeCustomName;
            byNameAndConnectorFilter = snapshotQueryImplementation -> snapshotQueryImplementation.name().equals(snapshotQueryMode);
            byNameFilter = byNameAndConnectorFilter;
        } else {
            snapshotQueryMode = configuredSnapshotQueryMode.getValue();
            byNameFilter = snapshotQueryImplementation -> snapshotQueryImplementation.name().equals(snapshotQueryMode);
            byNameAndConnectorFilter = byNameFilter.and(snapshotQueryImplementation -> this.isForCurrentConnector(configuration, snapshotQueryImplementation.getClass()));
        }
        Optional<SnapshotQuery> snapshotQuery = this.snapshotQueryImplementations.stream().filter(byNameAndConnectorFilter).findAny();
        if (snapshotQuery.isEmpty()) {
            snapshotQuery = this.snapshotQueryImplementations.stream().filter(byNameFilter).findAny();
            snapshotQuery.ifPresent(QueryImpl -> LOGGER.warn("Found a not connector specific implementation {} for query mode {}", (Object)QueryImpl.getClass().getName(), (Object)snapshotQueryMode));
        }
        return snapshotQuery.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)((Object)s)).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot query mode. Please check your configuration.", snapshotQueryMode)));
    }

    @Override
    public Class<SnapshotQuery> getServiceClass() {
        return SnapshotQuery.class;
    }
}

