/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.time.Date;
import io.debezium.time.MicroTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractSqlServerDatatypesTest
extends AbstractConnectorTest {
    static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    private static final String DDL_STRING = "create table type_string (  id int not null,   val_char char(3),   val_varchar varchar(1000),   val_text text,   val_nchar nchar(3),   val_nvarchar nvarchar(1000),   val_ntext ntext,   primary key (id))";
    private static final String DDL_FP = "create table type_fp (  id int not null,   val_decimal decimal(6,3),   val_numeric numeric,   val_float float,   val_real real,   val_smallmoney smallmoney,   val_money money   primary key (id))";
    private static final String DDL_INT = "create table type_int (  id int not null,   val_bit bit,   val_tinyint tinyint,   val_smallint smallint,   val_int int,   val_bigint bigint,   primary key (id))";
    private static final String DDL_TIME = "create table type_time (  id int not null,   val_date date,   val_time_p2 time(2),   val_time time(4),   val_datetime2 datetime2,   val_datetimeoffset datetimeoffset,   val_datetime datetime,   val_smalldatetime smalldatetime,   primary key (id))";
    private static final String DDL_XML = "create table type_xml (  id int not null,   val_xml xml,   primary key (id))";
    private static final List<SchemaAndValueField> EXPECTED_INT = Arrays.asList(new SchemaAndValueField("val_bit", Schema.OPTIONAL_BOOLEAN_SCHEMA, (Object)true), new SchemaAndValueField("val_tinyint", Schema.OPTIONAL_INT16_SCHEMA, (Object)22), new SchemaAndValueField("val_smallint", Schema.OPTIONAL_INT16_SCHEMA, (Object)333), new SchemaAndValueField("val_int", Schema.OPTIONAL_INT32_SCHEMA, (Object)4444), new SchemaAndValueField("val_bigint", Schema.OPTIONAL_INT64_SCHEMA, (Object)55555L));
    private static final List<SchemaAndValueField> EXPECTED_FP = Arrays.asList(new SchemaAndValueField("val_decimal", Decimal.builder((int)3).parameter("connect.decimal.precision", "6").optional().build(), (Object)new BigDecimal("1.123")), new SchemaAndValueField("val_numeric", Decimal.builder((int)0).parameter("connect.decimal.precision", "18").optional().build(), (Object)new BigDecimal("2")), new SchemaAndValueField("val_float", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)3.323), new SchemaAndValueField("val_real", Schema.OPTIONAL_FLOAT32_SCHEMA, (Object)Float.valueOf(4.323f)), new SchemaAndValueField("val_smallmoney", Decimal.builder((int)4).parameter("connect.decimal.precision", "10").optional().build(), (Object)new BigDecimal("5.3230")), new SchemaAndValueField("val_money", Decimal.builder((int)4).parameter("connect.decimal.precision", "19").optional().build(), (Object)new BigDecimal("6.3230")));
    private static final List<SchemaAndValueField> EXPECTED_STRING = Arrays.asList(new SchemaAndValueField("val_char", Schema.OPTIONAL_STRING_SCHEMA, (Object)"cc "), new SchemaAndValueField("val_varchar", Schema.OPTIONAL_STRING_SCHEMA, (Object)"vcc"), new SchemaAndValueField("val_text", Schema.OPTIONAL_STRING_SCHEMA, (Object)"tc"), new SchemaAndValueField("val_nchar", Schema.OPTIONAL_STRING_SCHEMA, (Object)"c\u010d "), new SchemaAndValueField("val_nvarchar", Schema.OPTIONAL_STRING_SCHEMA, (Object)"vc\u010d"), new SchemaAndValueField("val_ntext", Schema.OPTIONAL_STRING_SCHEMA, (Object)"t\u010d"));
    private static final List<SchemaAndValueField> EXPECTED_DATE_TIME = Arrays.asList(new SchemaAndValueField("val_date", Date.builder().optional().build(), (Object)17725), new SchemaAndValueField("val_time_p2", io.debezium.time.Time.builder().optional().build(), (Object)37425680), new SchemaAndValueField("val_time", MicroTime.builder().optional().build(), (Object)37425678900L), new SchemaAndValueField("val_datetime2", NanoTimestamp.builder().optional().build(), (Object)1531481025340000000L), new SchemaAndValueField("val_datetimeoffset", ZonedTimestamp.builder().optional().build(), (Object)"2018-07-13T12:23:45.456+11:00"), new SchemaAndValueField("val_datetime", Timestamp.builder().optional().build(), (Object)1531488225780L), new SchemaAndValueField("val_smalldatetime", Timestamp.builder().optional().build(), (Object)1531491840000L));
    private static final List<SchemaAndValueField> EXPECTED_DATE_TIME_AS_CONNECT = Arrays.asList(new SchemaAndValueField("val_date", org.apache.kafka.connect.data.Date.builder().optional().build(), (Object)java.util.Date.from(LocalDate.of(2018, 7, 13).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant())), new SchemaAndValueField("val_time_p2", Time.builder().optional().build(), (Object)java.util.Date.from(LocalTime.of(10, 23, 45, 680000000).atDate(LocalDate.ofEpochDay(0L)).atOffset(ZoneOffset.UTC).toInstant())), new SchemaAndValueField("val_time", Time.builder().optional().build(), (Object)java.util.Date.from(LocalTime.of(10, 23, 45, 678900000).atDate(LocalDate.ofEpochDay(0L)).atOffset(ZoneOffset.UTC).toInstant())), new SchemaAndValueField("val_datetime2", org.apache.kafka.connect.data.Timestamp.builder().optional().build(), (Object)java.util.Date.from(LocalDateTime.of(2018, 7, 13, 11, 23, 45, 340000000).atOffset(ZoneOffset.UTC).toInstant())), new SchemaAndValueField("val_datetimeoffset", ZonedTimestamp.builder().optional().build(), (Object)"2018-07-13T12:23:45.456+11:00"), new SchemaAndValueField("val_datetime", org.apache.kafka.connect.data.Timestamp.builder().optional().build(), (Object)java.util.Date.from(LocalDateTime.of(2018, 7, 13, 13, 23, 45, 780000000).atOffset(ZoneOffset.UTC).toInstant())), new SchemaAndValueField("val_smalldatetime", org.apache.kafka.connect.data.Timestamp.builder().optional().build(), (Object)java.util.Date.from(LocalDateTime.of(2018, 7, 13, 14, 24, 0).atOffset(ZoneOffset.UTC).toInstant())));
    private static final List<SchemaAndValueField> EXPECTED_XML = Arrays.asList(new SchemaAndValueField("val_xml", Schema.OPTIONAL_STRING_SCHEMA, (Object)"<a>b</a>"));
    private static final String[] ALL_TABLES = new String[]{"type_int", "type_fp", "type_string", "type_time", "type_xml"};
    private static final String[] ALL_DDLS = new String[]{"create table type_int (  id int not null,   val_bit bit,   val_tinyint tinyint,   val_smallint smallint,   val_int int,   val_bigint bigint,   primary key (id))", "create table type_fp (  id int not null,   val_decimal decimal(6,3),   val_numeric numeric,   val_float float,   val_real real,   val_smallmoney smallmoney,   val_money money   primary key (id))", "create table type_string (  id int not null,   val_char char(3),   val_varchar varchar(1000),   val_text text,   val_nchar nchar(3),   val_nvarchar nvarchar(1000),   val_ntext ntext,   primary key (id))", "create table type_time (  id int not null,   val_date date,   val_time_p2 time(2),   val_time time(4),   val_datetime2 datetime2,   val_datetimeoffset datetimeoffset,   val_datetime datetime,   val_smalldatetime smalldatetime,   primary key (id))", "create table type_xml (  id int not null,   val_xml xml,   primary key (id))"};
    private static final int EXPECTED_RECORD_COUNT = ALL_DDLS.length;

    @AfterClass
    public static void dropTables() throws SQLException {
        TestHelper.dropTestDatabase();
    }

    @BeforeClass
    public static void createTables() throws SQLException {
        TestHelper.createTestDatabase();
        try (SqlServerConnection connection = TestHelper.testConnection();){
            connection.execute(ALL_DDLS);
            for (String table : ALL_TABLES) {
                TestHelper.enableTableCdc(connection, table);
            }
            connection.execute(new String[]{"INSERT INTO type_int VALUES (0, 1, 22, 333, 4444, 55555)", "INSERT INTO type_fp VALUES (0, 1.123, 2, 3.323, 4.323, 5.323, 6.323)", "INSERT INTO type_string VALUES (0, 'c\u010d', 'vc\u010d', 't\u010d', N'c\u010d', N'vc\u010d', N't\u010d')", "INSERT INTO type_time VALUES (0, '2018-07-13', '10:23:45.678', '10:23:45.6789', '2018-07-13 11:23:45.34', '2018-07-13 12:23:45.456+11:00', '2018-07-13 13:23:45.78', '2018-07-13 14:23:45')", "INSERT INTO type_xml VALUES (0, '<a>b</a>')"});
            TestHelper.waitForCdcRecord(connection, "type_xml", rs -> rs.getInt("id") == 0);
        }
    }

    @Test
    public void intTypes() throws Exception {
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_int");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_INT);
    }

    @Test
    public void fpTypes() throws Exception {
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_fp");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_FP);
    }

    @Test
    public void stringTypes() throws Exception {
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_string");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_STRING);
    }

    @Test
    public void dateTimeTypes() throws Exception {
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_time");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_DATE_TIME);
    }

    @Test
    public void dateTimeTypesAsConnect() throws Exception {
        this.stopConnector();
        this.init(TemporalPrecisionMode.CONNECT);
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_time");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_DATE_TIME_AS_CONNECT);
    }

    @Test
    public void otherTypes() throws Exception {
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(EXPECTED_RECORD_COUNT);
        List testTableRecords = records.recordsForTopic("server1.testDB1.dbo.type_xml");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_XML);
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }

    public void init(TemporalPrecisionMode temporalPrecisionMode) throws Exception {
        this.initializeConnectorTestFramework();
        Testing.Debug.enable();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)temporalPrecisionMode)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
    }
}

