/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.spi.SnapshotQuery;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class SnapshotQueryProvider
implements ServiceProvider<SnapshotQuery> {
    @Override
    public SnapshotQuery createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        CommonConnectorConfig.SnapshotQueryMode configuredSnapshotQueryMode = commonConnectorConfig.snapshotQueryMode();
        String snapshotQueryModeCustomName = commonConnectorConfig.snapshotQueryModeCustomName();
        String snapshotQueryMode = CommonConnectorConfig.SnapshotQueryMode.CUSTOM.equals(configuredSnapshotQueryMode) && !snapshotQueryModeCustomName.isEmpty() ? snapshotQueryModeCustomName : configuredSnapshotQueryMode.getValue();
        Optional<SnapshotQuery> snapshotQuery = StreamSupport.stream(ServiceLoader.load(SnapshotQuery.class).spliterator(), false).filter(s -> s.name().equals(snapshotQueryMode)).findAny();
        return snapshotQuery.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)((Object)s)).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot query mode. Please check your configuration.", snapshotQueryMode)));
    }

    @Override
    public Class<SnapshotQuery> getServiceClass() {
        return SnapshotQuery.class;
    }
}

