/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.snapshot.spi.SnapshotLock;
import io.debezium.snapshot.spi.SnapshotQuery;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public abstract class SnapshotterServiceProvider
implements ServiceProvider<SnapshotterService> {
    @Override
    public SnapshotterService createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        Predicate<Snapshotter> implementationFilter;
        String snapshotMode;
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        String configuredSnapshotMode = this.snapshotMode(beanRegistry);
        String snapshotModeCustomName = commonConnectorConfig.getSnapshotModeCustomName();
        if ("custom".equals(configuredSnapshotMode) && !snapshotModeCustomName.isEmpty()) {
            snapshotMode = snapshotModeCustomName;
            implementationFilter = s -> s.name().equals(snapshotMode);
        } else {
            snapshotMode = configuredSnapshotMode;
            implementationFilter = s -> s.name().equals(snapshotMode) && this.isForCurrentConnector(configuration, (Snapshotter)s);
        }
        Optional<Snapshotter> snapshotter = StreamSupport.stream(ServiceLoader.load(Snapshotter.class).spliterator(), false).filter(implementationFilter).findAny();
        SnapshotQuery snapshotQueryService = serviceRegistry.tryGetService(SnapshotQuery.class);
        SnapshotLock snapshotLockService = serviceRegistry.tryGetService(SnapshotLock.class);
        return snapshotter.map(s -> SnapshotterServiceProvider.getSnapshotterService(configuration, s, beanRegistry, snapshotQueryService, snapshotLockService)).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshotter. Please check your configuration.", snapshotMode)));
    }

    private boolean isForCurrentConnector(Configuration configuration, Snapshotter s) {
        return s.getClass().getCanonicalName().contains(this.getConnectorClassPackage(configuration));
    }

    private String getConnectorClassPackage(Configuration config) {
        try {
            return Class.forName(config.getString("connector.class")).getPackageName();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static SnapshotterService getSnapshotterService(Configuration configuration, Snapshotter s, BeanRegistry beanRegistry, SnapshotQuery snapshotQueryService, SnapshotLock snapshotLockService) {
        s.configure(configuration.asMap());
        if (s instanceof BeanRegistryAware) {
            ((BeanRegistryAware)s).injectBeanRegistry(beanRegistry);
        }
        return new SnapshotterService(s, snapshotQueryService, snapshotLockService);
    }

    @Override
    public Class<SnapshotterService> getServiceClass() {
        return SnapshotterService.class;
    }

    public abstract String snapshotMode(BeanRegistry var1);
}

