/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.rest;

import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.rest.DebeziumSqlServerConnectRestExtension;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class DebeziumSqlServerConnectorResourceIT {
    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumSqlServerConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() throws URISyntaxException {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumSqlServerConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.SQLSERVER);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testValidConnection() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testInvalidHostnameConnection() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]).with(SqlServerConnectorConfig.HOSTNAME.name(), "zzzzzzzzzz");
        Locale.setDefault(new Locale("en", "US"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.is((Object)SqlServerConnectorConfig.HOSTNAME.name()), new Object[0])).body("message", CoreMatchers.startsWith((String)"Unable to connect. Check this and other connection properties. Error: The TCP/IP connection to the host zzzzzzzzzz, port 1433 has failed."), new Object[0]);
    }

    @Test
    public void testInvalidConnection() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body("{\"connector.class\": \"" + SqlServerConnector.class.getName() + "\"}").put("/debezium/sqlserver/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)3), new Object[0])).body("validationResults", CoreMatchers.hasItems((Object[])new Map[]{Map.of("property", SqlServerConnectorConfig.DATABASE_NAMES.name(), "message", "The 'database.names' value is invalid: Cannot be empty"), Map.of("property", SqlServerConnectorConfig.TOPIC_PREFIX.name(), "message", "The 'topic.prefix' value is invalid: A value is required"), Map.of("property", SqlServerConnectorConfig.HOSTNAME.name(), "message", "The 'database.hostname' value is invalid: A value is required")}), new Object[0]);
    }

    @Test
    public void testFiltersWithEmptyFilters() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)5), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("realm", "testDB", "namespace", "inventory", "name", "products_on_hand", "identifier", "testDB.inventory.products_on_hand"), Map.of("realm", "testDB", "namespace", "inventory", "name", "customers", "identifier", "testDB.inventory.customers"), Map.of("realm", "testDB", "namespace", "inventory", "name", "orders", "identifier", "testDB.inventory.orders"), Map.of("realm", "testDB", "namespace", "inventory", "name", "products", "identifier", "testDB.inventory.products"), Map.of("realm", "testDB2", "namespace", "inventory", "name", "products", "identifier", "testDB2.inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidTableIncludeList() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST.name(), "inventory\\.product.*");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)3), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("realm", "testDB", "namespace", "inventory", "name", "products_on_hand", "identifier", "testDB.inventory.products_on_hand"), Map.of("realm", "testDB", "namespace", "inventory", "name", "products", "identifier", "testDB.inventory.products"), Map.of("realm", "testDB2", "namespace", "inventory", "name", "products", "identifier", "testDB2.inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidTableIncludeList() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST.name(), "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"table.include.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'table.include.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidSchemaExcludeList() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]).with(SqlServerConnectorConfig.TABLE_EXCLUDE_LIST.name(), "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/sqlserver/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"table.exclude.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'table.exclude.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testMetricsEndpoint() {
        ConnectorConfiguration config = DebeziumSqlServerConnectorResourceIT.getSqlServerConnectorConfiguration(1, new String[0]);
        String connectorName = "my-sqlserver-connector";
        RestExtensionTestInfrastructure.getDebeziumContainer().registerConnector(connectorName, config);
        RestExtensionTestInfrastructure.getDebeziumContainer().ensureConnectorState(connectorName, Connector.State.RUNNING);
        RestExtensionTestInfrastructure.waitForConnectorTaskStatus((String)connectorName, (int)0, (Connector.State)Connector.State.RUNNING);
        RestExtensionTestInfrastructure.getDebeziumContainer().waitForStreamingRunning("sql_server", config.asProperties().getProperty("topic.prefix"), "streaming", String.valueOf(0));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).get("/debezium/sqlserver/connectors/{connector-name}/metrics", new Object[]{connectorName})).then()).log().all()).statusCode(200)).body("name", CoreMatchers.equalTo((Object)connectorName), new Object[0])).body("connector.metrics.Connected", CoreMatchers.equalTo((Object)"true"), new Object[0])).body("tasks[0].namespaces[0].name", CoreMatchers.equalTo((Object)"testDB"), new Object[0])).body("tasks[0].namespaces[0].metrics.MilliSecondsSinceLastEvent", CoreMatchers.equalTo((Object)"-1"), new Object[0])).body("tasks[0].namespaces[0].metrics.TotalNumberOfEventsSeen", CoreMatchers.equalTo((Object)"0"), new Object[0])).body("tasks[0].namespaces[1].name", CoreMatchers.equalTo((Object)"testDB2"), new Object[0])).body("tasks[0].namespaces[1].metrics.MilliSecondsSinceLastEvent", CoreMatchers.equalTo((Object)"-1"), new Object[0])).body("tasks[0].namespaces[1].metrics.TotalNumberOfEventsSeen", CoreMatchers.equalTo((Object)"0"), new Object[0]);
    }

    public static ConnectorConfiguration getSqlServerConnectorConfiguration(int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer((JdbcDatabaseContainer)RestExtensionTestInfrastructure.getSqlServerContainer()).with("database.user", "sa").with("database.password", "Password!").with(KafkaSchemaHistory.BOOTSTRAP_SERVERS.name(), "kafka-dbz-ui:9092").with(KafkaSchemaHistory.TOPIC.name(), "dbhistory.inventory").with(SqlServerConnectorConfig.DATABASE_NAMES.name(), "testDB,testDB2").with(SqlServerConnectorConfig.SNAPSHOT_MODE.name(), "initial").with(SqlServerConnectorConfig.TOPIC_PREFIX.name(), "dbserver" + id).with("driver.encrypt", Boolean.valueOf(false)).with("database.encrypt", Boolean.valueOf(false));
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

