/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SqlServerSkipMessagesWithNoUpdateConfigIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;
    private final Configuration.Builder configBuilder = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.skip_messages_test")).with(SqlServerConnectorConfig.COLUMN_INCLUDE_LIST, "dbo.skip_messages_test.id, dbo.skip_messages_test.white");

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE skip_messages_test (id int primary key, white int, black int)"});
        TestHelper.enableTableCdc(this.connection, "skip_messages_test");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabled() throws Exception {
        Configuration config = ((Configuration.Builder)this.configBuilder.with(SqlServerConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).build();
        this.start(SqlServerConnector.class, config);
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO skip_messages_test VALUES (1, 1, 1);"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET black=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=3,black=3 where id=1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List tableMessages = records.recordsForTopic("server1.testDB1.dbo.skip_messages_test");
        Assertions.assertThat((List)tableMessages).hasSize(3);
        Struct secondMessage = (Struct)((SourceRecord)tableMessages.get(1)).value();
        Assertions.assertThat((Object)((Struct)secondMessage.get("after")).get("white")).isEqualTo((Object)2);
        Struct thirdMessage = (Struct)((SourceRecord)tableMessages.get(2)).value();
        Assertions.assertThat((Object)((Struct)thirdMessage.get("after")).get("white")).isEqualTo((Object)3);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabledWithExcludeConfig() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.skip_messages_test")).with(SqlServerConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(SqlServerConnectorConfig.COLUMN_EXCLUDE_LIST, "dbo.skip_messages_test.black")).build();
        this.start(SqlServerConnector.class, config);
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO skip_messages_test VALUES (1, 1, 1);"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET black=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=3,black=3 where id=1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List tableMessages = records.recordsForTopic("server1.testDB1.dbo.skip_messages_test");
        Assertions.assertThat((List)tableMessages).hasSize(3);
        Struct secondMessage = (Struct)((SourceRecord)tableMessages.get(1)).value();
        Assertions.assertThat((Object)((Struct)secondMessage.get("after")).get("white")).isEqualTo((Object)2);
        Struct thirdMessage = (Struct)((SourceRecord)tableMessages.get(2)).value();
        Assertions.assertThat((Object)((Struct)thirdMessage.get("after")).get("white")).isEqualTo((Object)3);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldNotSkipEventsWithNoChangeInIncludedColumnsWhenSkipDisabled() throws Exception {
        Configuration config = ((Configuration.Builder)this.configBuilder.with(SqlServerConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, false)).build();
        this.start(SqlServerConnector.class, config);
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO skip_messages_test VALUES (1, 1, 1);"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET black=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=2 where id=1"});
        this.connection.execute(new String[]{"UPDATE skip_messages_test SET white=3,black=3 where id=1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableMessages = records.recordsForTopic("server1.testDB1.dbo.skip_messages_test");
        Assertions.assertThat((List)tableMessages).hasSize(4);
        Struct secondMessage = (Struct)((SourceRecord)tableMessages.get(1)).value();
        Assertions.assertThat((Object)((Struct)secondMessage.get("after")).get("white")).isEqualTo((Object)1);
        Struct thirdMessage = (Struct)((SourceRecord)tableMessages.get(2)).value();
        Assertions.assertThat((Object)((Struct)thirdMessage.get("after")).get("white")).isEqualTo((Object)2);
        Struct forthMessage = (Struct)((SourceRecord)tableMessages.get(3)).value();
        Assertions.assertThat((Object)((Struct)forthMessage.get("after")).get("white")).isEqualTo((Object)3);
        this.stopConnector();
    }
}

