/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.AbstractReselectProcessorTest;
import io.debezium.processors.reselect.ReselectColumnsPostProcessor;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.junit.After;
import org.junit.Before;

public class SqlServerReselectColumnsProcessorIT
extends AbstractReselectProcessorTest<SqlServerConnector> {
    private SqlServerConnection connection;

    @Before
    public void beforeEach() throws Exception {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.setAutoCommit(false);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected Class<SqlServerConnector> getConnectorClass() {
        return SqlServerConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.dbz4321")).with(SqlServerConnectorConfig.CUSTOM_POST_PROCESSORS, "reselector")).with("reselector.type", ReselectColumnsPostProcessor.class.getName());
    }

    protected String topicName() {
        return "server1.testDB1.dbo.dbz4321";
    }

    protected String tableName() {
        return "dbo.dbz4321";
    }

    protected String reselectColumnsList() {
        return this.tableName() + ":data";
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE dbz4321 (id int identity(1,1) primary key, data varchar(50), data2 int)"});
        TestHelper.enableTableCdc(this.connection, "dbz4321");
    }

    protected void dropTable() throws Exception {
    }

    protected String getInsertWithValue() {
        return "INSERT INTO dbo.dbz4321 (data,data2) values ('one',1)";
    }

    protected String getInsertWithNullValue() {
        return "INSERT INTO dbo.dbz4321 (data,data2) values (null,1)";
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        TestHelper.waitForStreamingStarted();
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNullSnapshot() throws InterruptedException {
        return this.consumeRecordsByTopic(3);
    }
}

