/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SQLServerNumericColumnIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablenuma (id int IDENTITY(1,1) primary key, cola DECIMAL(8, 4),colb DECIMAL, colc numeric(8,1), cold numeric)", "CREATE TABLE tablenumb (id int IDENTITY(1,1) primary key, cola DECIMAL(8, 4),colb DECIMAL, colc numeric(8,1), cold numeric)", "CREATE TABLE tablenumc (id int IDENTITY(1,1) primary key, cola DECIMAL(8, 4),colb DECIMAL, colc numeric(8,1), cold numeric)", "CREATE TABLE tablenumd (id int IDENTITY(1,1) primary key, cola DECIMAL(8, 4),colb DECIMAL, colc numeric(8,1), cold numeric)"});
        TestHelper.enableTableCdc(this.connection, "tablenuma");
        TestHelper.enableTableCdc(this.connection, "tablenumb");
        TestHelper.enableTableCdc(this.connection, "tablenumc");
        TestHelper.enableTableCdc(this.connection, "tablenumd");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void decimalModeConfigString() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tablenuma")).with(SqlServerConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.connection.execute(new String[]{"INSERT INTO tablenuma VALUES (111.1111, 1111111, 1111111.1, 1111111 );"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableA = records.recordsForTopic("server1.testDB1.dbo.tablenuma");
        Assertions.assertThat((List)tableA).hasSize(1);
        Struct valueA = (Struct)((SourceRecord)tableA.get(0)).value();
        this.assertSchema(valueA, Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cola")).isEqualTo((Object)"111.1111");
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colb")).isEqualTo((Object)"1111111");
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colc")).isEqualTo((Object)"1111111.1");
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cold")).isEqualTo((Object)"1111111");
        this.stopConnector();
    }

    @Test
    public void decimalModeConfigDouble() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tablenumb")).with(SqlServerConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.connection.execute(new String[]{"INSERT INTO tablenumb VALUES (222.2222, 22222, 22222.2, 2222222 );"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List results = records.recordsForTopic("server1.testDB1.dbo.tablenumb");
        Assertions.assertThat((List)results).hasSize(1);
        Struct valueA = (Struct)((SourceRecord)results.get(0)).value();
        this.assertSchema(valueA, Schema.OPTIONAL_FLOAT64_SCHEMA);
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cola")).isEqualTo((Object)222.2222);
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colb")).isEqualTo((Object)22222.0);
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colc")).isEqualTo((Object)22222.2);
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cold")).isEqualTo((Object)2222222.0);
        this.stopConnector();
    }

    @Test
    public void decimalModeConfigPrecise() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tablenumc")).with(SqlServerConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.connection.execute(new String[]{"INSERT INTO tablenumc VALUES (333.3333, 3333, 3333.3, 33333333 );"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List results = records.recordsForTopic("server1.testDB1.dbo.tablenumc");
        Assertions.assertThat((List)results).hasSize(1);
        Struct valueA = (Struct)((SourceRecord)results.get(0)).value();
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("cola").schema()).isEqualTo((Object)Decimal.builder((int)4).parameter("connect.decimal.precision", "8").optional().schema());
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("colb").schema()).isEqualTo((Object)Decimal.builder((int)0).parameter("connect.decimal.precision", "18").optional().schema());
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("colc").schema()).isEqualTo((Object)Decimal.builder((int)1).parameter("connect.decimal.precision", "8").optional().schema());
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("cold").schema()).isEqualTo((Object)Decimal.builder((int)0).parameter("connect.decimal.precision", "18").optional().schema());
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cola")).isEqualTo((Object)BigDecimal.valueOf(333.3333));
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colb")).isEqualTo((Object)BigDecimal.valueOf(3333L));
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("colc")).isEqualTo((Object)BigDecimal.valueOf(3333.3));
        Assertions.assertThat((Object)((Struct)valueA.get("after")).get("cold")).isEqualTo((Object)BigDecimal.valueOf(33333333L));
        this.stopConnector();
    }

    private void assertSchema(Struct valueA, Schema expected) {
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("cola").schema()).isEqualTo((Object)expected);
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("colb").schema()).isEqualTo((Object)expected);
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("colc").schema()).isEqualTo((Object)expected);
        Assertions.assertThat((Object)valueA.schema().field("after").schema().field("cold").schema()).isEqualTo((Object)expected);
    }
}

