/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.data.ValueWrapper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.IncrementalSnapshotNotificationService;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalPayload;
import io.debezium.pipeline.signal.actions.snapshotting.SnapshotConfiguration;
import io.debezium.pipeline.source.snapshot.incremental.DataCollection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.Key;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.Tables;
import io.debezium.schema.DatabaseSchema;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractIncrementalSnapshotChangeEventSource<P extends Partition, T extends DataCollectionId>
implements IncrementalSnapshotChangeEventSource<P, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIncrementalSnapshotChangeEventSource.class);
    protected final RelationalDatabaseConnectorConfig connectorConfig;
    private final Clock clock;
    private final RelationalDatabaseSchema databaseSchema;
    private final SnapshotProgressListener<P> progressListener;
    private final DataChangeEventListener<P> dataListener;
    private long totalRowsScanned = 0L;
    private Table currentTable;
    protected EventDispatcher<P, T> dispatcher;
    protected IncrementalSnapshotContext<T> context = null;
    protected JdbcConnection jdbcConnection;
    protected Tables.ColumnNameFilter columnFilter;
    protected final Map<Struct, Object[]> window = new LinkedHashMap<Struct, Object[]>();
    protected final NotificationService<P, ? extends OffsetContext> notificationService;

    public AbstractIncrementalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<P, T> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener<P> progressListener, DataChangeEventListener<P> dataChangeEventListener, NotificationService<P, ? extends OffsetContext> notificationService) {
        this.connectorConfig = config;
        this.jdbcConnection = jdbcConnection;
        this.columnFilter = config.getColumnFilter();
        this.dispatcher = dispatcher;
        this.databaseSchema = (RelationalDatabaseSchema)databaseSchema;
        this.clock = clock;
        this.progressListener = progressListener;
        this.dataListener = dataChangeEventListener;
        this.notificationService = notificationService;
    }

    @Override
    public void closeWindow(P partition, String id, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        LOGGER.trace("Closing Window {}", (Object)this.context.toString());
        if (!this.context.closeWindow(id)) {
            return;
        }
        this.sendWindowEvents(partition, offsetContext);
        this.readChunk(partition, offsetContext);
    }

    @Override
    public void pauseSnapshot(P partition, OffsetContext offsetContext) {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context.snapshotRunning() && !this.context.isSnapshotPaused()) {
            this.context.pauseSnapshot();
            this.progressListener.snapshotPaused(partition);
            this.notificationService.incrementalSnapshotNotificationService().notifyPaused(this.context, partition, offsetContext);
        }
    }

    @Override
    public void resumeSnapshot(P partition, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context.snapshotRunning() && this.context.isSnapshotPaused()) {
            this.context.resumeSnapshot();
            this.progressListener.snapshotResumed(partition);
            this.notificationService.incrementalSnapshotNotificationService().notifyResumed(this.context, partition, offsetContext);
            this.readChunk(partition, offsetContext);
        }
    }

    @Override
    public void processSchemaChange(P partition, OffsetContext offsetContext, DataCollectionId dataCollectionId) throws InterruptedException {
        if (dataCollectionId != null && this.context.currentDataCollectionId() != null && dataCollectionId.equals(this.context.currentDataCollectionId().getId())) {
            this.rereadChunk(partition, offsetContext);
        }
    }

    public void rereadChunk(P partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.context == null) {
            return;
        }
        if (!this.context.snapshotRunning() || !this.context.deduplicationNeeded() || this.window.isEmpty()) {
            return;
        }
        this.window.clear();
        this.context.revertChunk();
        this.readChunk(partition, offsetContext);
    }

    protected String getSignalTableName(String dataCollectionId) {
        if (Strings.isNullOrEmpty(dataCollectionId)) {
            return dataCollectionId;
        }
        return this.jdbcConnection.quotedTableIdString(TableId.parse(dataCollectionId));
    }

    protected void sendWindowEvents(P partition, OffsetContext offsetContext) throws InterruptedException {
        LOGGER.debug("Sending {} events from window buffer", (Object)this.window.size());
        offsetContext.incrementalSnapshotEvents();
        for (Object[] row : this.window.values()) {
            this.sendEvent(partition, this.dispatcher, offsetContext, row);
        }
        offsetContext.postSnapshotCompletion();
        this.window.clear();
    }

    protected void sendEvent(P partition, EventDispatcher<P, T> dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        this.context.sendEvent(this.keyFromRow(row));
        offsetContext.event((DataCollectionId)this.context.currentDataCollectionId().getId(), this.clock.currentTimeAsInstant());
        dispatcher.dispatchSnapshotEvent(partition, (DataCollectionId)this.context.currentDataCollectionId().getId(), this.getChangeRecordEmitter(partition, (DataCollectionId)this.context.currentDataCollectionId().getId(), offsetContext, row), dispatcher.getIncrementalSnapshotChangeEventReceiver(this.dataListener));
    }

    protected ChangeRecordEmitter<P> getChangeRecordEmitter(P partition, T dataCollectionId, OffsetContext offsetContext, Object[] row) {
        return new SnapshotChangeRecordEmitter<P>(partition, offsetContext, row, this.clock, this.connectorConfig);
    }

    protected void deduplicateWindow(DataCollectionId dataCollectionId, Object key) {
        if (this.context.currentDataCollectionId() == null || !((DataCollectionId)this.context.currentDataCollectionId().getId()).equals(dataCollectionId)) {
            return;
        }
        if (key instanceof Struct && this.window.remove((Struct)key) != null) {
            LOGGER.info("Removed '{}' from window", key);
        }
    }

    protected abstract void emitWindowOpen() throws SQLException;

    protected abstract void emitWindowClose(P var1, OffsetContext var2) throws SQLException, InterruptedException;

    protected String buildChunkQuery(Table table, Optional<String> additionalCondition) {
        return this.buildChunkQuery(table, this.connectorConfig.getIncrementalSnapshotChunkSize(), additionalCondition);
    }

    protected String buildChunkQuery(Table table, int limit, Optional<String> additionalCondition) {
        String condition = null;
        if (this.context.isNonInitialChunk()) {
            StringBuilder sql = new StringBuilder();
            this.addLowerBound(table, sql);
            sql.append(" AND NOT ");
            this.addLowerBound(table, sql);
            condition = sql.toString();
        }
        String orderBy = this.getQueryColumns(table).stream().map(c -> this.jdbcConnection.quotedColumnIdString(c.name())).collect(Collectors.joining(", "));
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), limit, this.buildProjection(table), Optional.ofNullable(condition), additionalCondition, orderBy);
    }

    protected String buildProjection(Table table) {
        String projection = "*";
        if (this.connectorConfig.isColumnsFiltered()) {
            TableId tableId = table.id();
            projection = table.columns().stream().filter(column -> this.columnFilter.matches(tableId.catalog(), tableId.schema(), tableId.table(), column.name())).map(column -> this.jdbcConnection.quotedColumnIdString(column.name())).collect(Collectors.joining(", "));
        }
        return projection;
    }

    private void addLowerBound(Table table, StringBuilder sql) {
        List<Column> pkColumns = this.getQueryColumns(table);
        if (pkColumns.size() > 1) {
            sql.append('(');
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            boolean isLastIterationForI = i == pkColumns.size() - 1;
            sql.append('(');
            for (int j = 0; j < i + 1; ++j) {
                boolean isLastIterationForJ = i == j;
                sql.append(this.jdbcConnection.quotedColumnIdString(pkColumns.get(j).name()));
                sql.append(isLastIterationForJ ? " > ?" : " = ?");
                if (isLastIterationForJ) continue;
                sql.append(" AND ");
            }
            sql.append(")");
            if (isLastIterationForI) continue;
            sql.append(" OR ");
        }
        if (pkColumns.size() > 1) {
            sql.append(')');
        }
    }

    protected String buildMaxPrimaryKeyQuery(Table table, Optional<String> additionalCondition) {
        String orderBy = this.getQueryColumns(table).stream().map(c -> this.jdbcConnection.quotedColumnIdString(c.name())).collect(Collectors.joining(" DESC, ")) + " DESC";
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), 1, this.buildProjection(table), Optional.empty(), additionalCondition, orderBy);
    }

    @Override
    public void init(P partition, OffsetContext offsetContext) {
        if (offsetContext == null) {
            LOGGER.info("Empty incremental snapshot change event source started, no action needed");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.snapshotRunning()) {
            LOGGER.info("No incremental snapshot in progress, no action needed on start");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        LOGGER.info("Incremental snapshot in progress, need to read new chunk on start");
        try {
            this.progressListener.snapshotStarted(partition);
            this.readChunk(partition, offsetContext);
        }
        catch (InterruptedException e) {
            throw new DebeziumException("Reading of an initial chunk after connector restart has been interrupted");
        }
        LOGGER.info("Incremental snapshot in progress, loading of initial chunk completed");
    }

    protected void readChunk(P partition, OffsetContext offsetContext) throws InterruptedException {
        if (!this.context.snapshotRunning()) {
            LOGGER.info("Skipping read chunk because snapshot is not running");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        if (this.context.isSnapshotPaused()) {
            LOGGER.info("Incremental snapshot was paused.");
            return;
        }
        try {
            this.preReadChunk(this.context);
            this.jdbcConnection.commit();
            this.context.startNewChunk();
            this.emitWindowOpen();
            while (this.context.snapshotRunning()) {
                if (this.isTableInvalid(partition, offsetContext)) continue;
                if (this.connectorConfig.isIncrementalSnapshotSchemaChangesEnabled() && !this.schemaHistoryIsUpToDate()) break;
                TableId currentTableId = (TableId)this.context.currentDataCollectionId().getId();
                if (!this.context.maximumKey().isPresent()) {
                    this.currentTable = this.refreshTableSchema(this.currentTable);
                    try {
                        Object[] maximumKey = this.jdbcConnection.queryAndMap(this.buildMaxPrimaryKeyQuery(this.currentTable, this.context.currentDataCollectionId().getAdditionalCondition()), rs -> {
                            if (!rs.next()) {
                                return null;
                            }
                            return this.keyFromRow(this.jdbcConnection.rowToArray(this.currentTable, rs, ColumnUtils.toArray(rs, this.currentTable)));
                        });
                        this.context.maximumKey(maximumKey);
                    }
                    catch (SQLException e) {
                        LOGGER.error("Failed to read maximum key for table {}", (Object)currentTableId, (Object)e);
                        this.notificationService.incrementalSnapshotNotificationService().notifyTableScanCompleted(this.context, partition, offsetContext, this.totalRowsScanned, IncrementalSnapshotNotificationService.TableScanCompletionStatus.SQL_EXCEPTION);
                        this.nextDataCollection(partition, offsetContext);
                        continue;
                    }
                    if (!this.context.maximumKey().isPresent()) {
                        LOGGER.info("No maximum key returned by the query, incremental snapshotting of table '{}' finished as it is empty", (Object)currentTableId);
                        this.notificationService.incrementalSnapshotNotificationService().notifyTableScanCompleted(this.context, partition, offsetContext, this.totalRowsScanned, IncrementalSnapshotNotificationService.TableScanCompletionStatus.EMPTY);
                        this.nextDataCollection(partition, offsetContext);
                        continue;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incremental snapshot for table '{}' will end at position {}", (Object)currentTableId, (Object)this.context.maximumKey().orElse(new Object[0]));
                    }
                }
                if (this.createDataEventsForTable(partition)) {
                    if (this.window.isEmpty()) {
                        LOGGER.info("No data returned by the query, incremental snapshotting of table '{}' finished", (Object)currentTableId);
                        this.notificationService.incrementalSnapshotNotificationService().notifyTableScanCompleted(this.context, partition, offsetContext, this.totalRowsScanned, IncrementalSnapshotNotificationService.TableScanCompletionStatus.SUCCEEDED);
                        this.tableScanCompleted(partition);
                        this.nextDataCollection(partition, offsetContext);
                        continue;
                    }
                    this.notificationService.incrementalSnapshotNotificationService().notifyInProgress(this.context, partition, offsetContext);
                    break;
                }
                this.context.revertChunk();
                break;
            }
            this.emitWindowClose(partition, offsetContext);
        }
        catch (SQLException e) {
            throw new DebeziumException(String.format("Database error while executing incremental snapshot for table '%s'", this.context.currentDataCollectionId()), (Throwable)e);
        }
        finally {
            this.postReadChunk(this.context);
            if (!this.context.snapshotRunning()) {
                this.postIncrementalSnapshotCompleted();
            }
        }
    }

    private boolean isTableInvalid(P partition, OffsetContext offsetContext) {
        TableId currentTableId = (TableId)this.context.currentDataCollectionId().getId();
        this.currentTable = this.databaseSchema.tableFor(currentTableId);
        if (this.currentTable == null) {
            LOGGER.warn("Schema not found for table '{}', known tables {}", (Object)currentTableId, this.databaseSchema.tableIds());
            this.notificationService.incrementalSnapshotNotificationService().notifyTableScanCompleted(this.context, partition, offsetContext, this.totalRowsScanned, IncrementalSnapshotNotificationService.TableScanCompletionStatus.UNKNOWN_SCHEMA);
            this.nextDataCollection(partition, offsetContext);
            return true;
        }
        if (this.getQueryColumns(this.currentTable).isEmpty()) {
            LOGGER.warn("Incremental snapshot for table '{}' skipped cause the table has no primary keys", (Object)currentTableId);
            this.notificationService.incrementalSnapshotNotificationService().notifyTableScanCompleted(this.context, partition, offsetContext, this.totalRowsScanned, IncrementalSnapshotNotificationService.TableScanCompletionStatus.NO_PRIMARY_KEY);
            this.nextDataCollection(partition, offsetContext);
            return true;
        }
        return false;
    }

    private boolean schemaHistoryIsUpToDate() {
        if (this.context.isSchemaVerificationPassed()) {
            return true;
        }
        this.verifySchemaUnchanged();
        return this.context.isSchemaVerificationPassed();
    }

    private void verifySchemaUnchanged() {
        Table tableSchemaInDatabase = this.readSchema();
        if (this.context.getSchema() != null) {
            this.context.setSchemaVerificationPassed(this.context.getSchema().equals(tableSchemaInDatabase));
        }
        this.context.setSchema(tableSchemaInDatabase);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Table readSchema() {
        String selectStatement = this.buildChunkQuery(this.currentTable, 0, Optional.empty());
        LOGGER.debug("Reading schema for table '{}' using select statement: '{}'", (Object)this.currentTable.id(), (Object)selectStatement);
        try (PreparedStatement statement = this.readTableChunkStatement(selectStatement);){
            Table table;
            block14: {
                ResultSet rs = statement.executeQuery();
                try {
                    table = this.getTable(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return table;
        }
        catch (SQLException e) {
            throw new DebeziumException("Snapshotting of table " + this.currentTable.id() + " failed", (Throwable)e);
        }
    }

    private void nextDataCollection(P partition, OffsetContext offsetContext) {
        this.context.nextDataCollection();
        if (!this.context.snapshotRunning()) {
            this.progressListener.snapshotCompleted(partition);
            this.notificationService.incrementalSnapshotNotificationService().notifyCompleted(this.context, partition, offsetContext);
            this.context.unsetCorrelationId();
        }
    }

    @Override
    public void addDataCollectionNamesToSnapshot(SignalPayload<P> signalPayload, SnapshotConfiguration snapshotConfiguration) throws InterruptedException {
        OffsetContext offsetContext = signalPayload.offsetContext;
        Object partition = signalPayload.partition;
        String correlationId = signalPayload.id;
        this.context = offsetContext.getIncrementalSnapshotContext();
        boolean shouldReadChunk = !this.context.snapshotRunning();
        List<String> expandedDataCollectionIds = this.expandDataCollectionIds(snapshotConfiguration.getDataCollections());
        if (expandedDataCollectionIds.size() > snapshotConfiguration.getDataCollections().size()) {
            LOGGER.info("Data-collections to snapshot have been expanded from {} to {}", snapshotConfiguration.getDataCollections(), expandedDataCollectionIds);
        }
        List<DataCollection<T>> newDataCollectionIds = this.context.addDataCollectionNamesToSnapshot(correlationId, expandedDataCollectionIds, snapshotConfiguration.getAdditionalConditions(), snapshotConfiguration.getSurrogateKey());
        if (shouldReadChunk) {
            List monitoredDataCollections = newDataCollectionIds.stream().map(DataCollection::getId).collect(Collectors.toList());
            this.progressListener.snapshotStarted(partition);
            this.notificationService.incrementalSnapshotNotificationService().notifyStarted(this.context, partition, offsetContext);
            this.progressListener.monitoredDataCollectionsDetermined(partition, monitoredDataCollections);
            this.readChunk(partition, offsetContext);
        }
    }

    @Override
    public void stopSnapshot(P partition, OffsetContext offsetContext, Map<String, Object> additionalData, List<String> dataCollectionIds) {
        this.context = offsetContext.getIncrementalSnapshotContext();
        LOGGER.trace("Stopping incremental snapshot with context {}", this.context);
        if (this.context.snapshotRunning()) {
            if (dataCollectionIds == null || dataCollectionIds.isEmpty()) {
                LOGGER.info("Stopping incremental snapshot.");
                try {
                    this.context.stopSnapshot();
                    this.window.clear();
                    this.closeWindow(partition, this.context.currentChunkId(), offsetContext);
                    this.progressListener.snapshotAborted(partition);
                    this.notificationService.incrementalSnapshotNotificationService().notifyAborted(this.context, partition, offsetContext);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Failed to stop snapshot successfully.", (Throwable)e);
                }
            } else {
                List<String> expandedDataCollectionIds = this.expandDataCollectionIds(dataCollectionIds);
                LOGGER.info("Removing '{}' collections from incremental snapshot", expandedDataCollectionIds);
                TableId stopCurrentTableId = null;
                for (String dataCollectionId : expandedDataCollectionIds) {
                    TableId collectionId = TableId.parse(dataCollectionId);
                    if (this.currentTable != null && this.currentTable.id().equals(collectionId)) {
                        stopCurrentTableId = this.currentTable.id();
                        continue;
                    }
                    if (this.context.removeDataCollectionFromSnapshot(dataCollectionId)) {
                        LOGGER.info("Removed '{}' from incremental snapshot collection list.", (Object)collectionId);
                        continue;
                    }
                    LOGGER.warn("Could not remove '{}', collection is not part of the incremental snapshot.", (Object)collectionId);
                }
                if (stopCurrentTableId != null) {
                    this.window.clear();
                    LOGGER.info("Removed '{}' from incremental snapshot collection list.", stopCurrentTableId);
                    this.tableScanCompleted(partition);
                    if (!this.context.snapshotRunning()) {
                        LOGGER.info("Incremental snapshot has stopped.");
                        this.progressListener.snapshotAborted(partition);
                    } else {
                        LOGGER.info("Advancing to next available collection in the incremental snapshot.");
                        this.nextDataCollection(partition, offsetContext);
                    }
                }
                this.notificationService.incrementalSnapshotNotificationService().notifyAborted(this.context, partition, offsetContext, expandedDataCollectionIds);
            }
        } else {
            LOGGER.warn("No active incremental snapshot, stop ignored");
        }
    }

    protected void addKeyColumnsToCondition(Table table, StringBuilder sql, String predicate) {
        Iterator<Column> i = this.getQueryColumns(table).iterator();
        while (i.hasNext()) {
            Column key = i.next();
            sql.append(this.jdbcConnection.quotedColumnIdString(key.name())).append(predicate);
            if (!i.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private List<String> expandDataCollectionIds(List<String> dataCollectionIds) {
        return dataCollectionIds.stream().flatMap(x -> {
            List ids = this.databaseSchema.tableIds().stream().map(TableId::identifier).filter(t -> Pattern.compile(x).matcher((CharSequence)t).matches()).collect(Collectors.toList());
            return ids.isEmpty() ? Stream.of(x) : ids.stream();
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createDataEventsForTable(P partition) {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.debug("Exporting data chunk from table '{}' (total {} tables)", (Object)this.currentTable.id(), (Object)this.context.dataCollectionsToBeSnapshottedCount());
        String selectStatement = this.buildChunkQuery(this.currentTable, this.context.currentDataCollectionId().getAdditionalCondition());
        LOGGER.debug("\t For table '{}' using select statement: '{}', key: '{}', maximum key: '{}'", new Object[]{this.currentTable.id(), selectStatement, this.context.chunkEndPosititon(), this.context.maximumKey().get()});
        TableSchema tableSchema = this.databaseSchema.schemaFor(this.currentTable.id());
        try (PreparedStatement statement = this.readTableChunkStatement(selectStatement);
             ResultSet rs = statement.executeQuery();){
            if (this.checkSchemaChanges(rs)) {
                boolean bl = false;
                return bl;
            }
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, this.currentTable);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            Object[] lastRow = null;
            Object[] firstRow = null;
            while (rs.next()) {
                ++rows;
                Object[] row = this.jdbcConnection.rowToArray(this.currentTable, rs, columnArray);
                if (firstRow == null) {
                    firstRow = row;
                }
                Struct keyStruct = tableSchema.keyFromColumnData(row);
                this.window.put(keyStruct, row);
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOGGER.debug("\t Exported {} records for table '{}' after {}", new Object[]{rows, this.currentTable.id(), Strings.duration(stop - exportStart)});
                    logTimer = this.getTableScanLogTimer();
                }
                lastRow = row;
            }
            Object[] firstKey = this.keyFromRow(firstRow);
            Object[] lastKey = this.keyFromRow(lastRow);
            if (this.context.isNonInitialChunk()) {
                this.progressListener.currentChunk(partition, this.context.currentChunkId(), firstKey, lastKey);
            } else {
                this.progressListener.currentChunk(partition, this.context.currentChunkId(), firstKey, lastKey, this.context.maximumKey().orElse(null));
            }
            this.context.nextChunkPosition(lastKey);
            if (lastRow != null) {
                LOGGER.debug("\t Next window will resume from {}", (Object)this.context.chunkEndPosititon());
            }
            LOGGER.debug("\t Finished exporting {} records for window of table table '{}'; total duration '{}'", new Object[]{rows, this.currentTable.id(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.incrementTableRowsScanned(partition, rows);
            return true;
        }
        catch (SQLException e) {
            throw new DebeziumException("Snapshotting of table " + this.currentTable.id() + " failed", (Throwable)e);
        }
    }

    private boolean checkSchemaChanges(ResultSet rs) throws SQLException {
        if (!this.connectorConfig.isIncrementalSnapshotSchemaChangesEnabled()) {
            return false;
        }
        Table schema = this.getTable(rs);
        if (!schema.equals(this.context.getSchema())) {
            this.context.setSchemaVerificationPassed(false);
            Table oldSchema = this.context.getSchema();
            this.context.setSchema(schema);
            LOGGER.info("Schema has changed during the incremental snapshot: Old Schema: {} New Schema: {}", (Object)oldSchema, (Object)schema);
            return true;
        }
        return false;
    }

    private Table getTable(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            Column column = Column.editor().name(metaData.getColumnName(i)).jdbcType(metaData.getColumnType(i)).type(metaData.getColumnTypeName(i)).optional(metaData.isNullable(i) > 0).length(metaData.getPrecision(i)).scale(metaData.getScale(i)).create();
            columns.add(column);
        }
        Collections.sort(columns);
        return Table.editor().tableId(this.currentTable.id()).addColumns(columns).create();
    }

    private void incrementTableRowsScanned(P partition, long rows) {
        this.totalRowsScanned += rows;
        this.progressListener.rowsScanned(partition, this.currentTable.id(), this.totalRowsScanned);
    }

    private void tableScanCompleted(P partition) {
        this.progressListener.dataCollectionSnapshotCompleted(partition, this.currentTable.id(), this.totalRowsScanned);
        this.totalRowsScanned = 0L;
        this.progressListener.currentChunk(partition, null, null, null, null);
    }

    protected PreparedStatement readTableChunkStatement(String sql) throws SQLException {
        PreparedStatement statement = this.jdbcConnection.readTablePreparedStatement(this.connectorConfig, sql, OptionalLong.empty());
        if (this.context.isNonInitialChunk()) {
            int j;
            int i;
            Object[] maximumKey = this.context.maximumKey().get();
            Object[] chunkEndPosition = this.context.chunkEndPosititon();
            int pos = 0;
            for (i = 0; i < chunkEndPosition.length; ++i) {
                for (j = 0; j < i + 1; ++j) {
                    statement.setObject(++pos, chunkEndPosition[j]);
                }
            }
            for (i = 0; i < chunkEndPosition.length; ++i) {
                for (j = 0; j < i + 1; ++j) {
                    statement.setObject(++pos, maximumKey[j]);
                }
            }
        }
        return statement;
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, RelationalSnapshotChangeEventSource.LOG_INTERVAL);
    }

    private Object[] keyFromRow(Object[] row) {
        if (row == null) {
            return null;
        }
        List<Column> keyColumns = this.getQueryColumns(this.currentTable);
        Object[] key = new Object[keyColumns.size()];
        for (int i = 0; i < keyColumns.size(); ++i) {
            Object fieldValue = row[keyColumns.get(i).position() - 1];
            key[i] = fieldValue instanceof ValueWrapper ? ((ValueWrapper)fieldValue).getWrappedValue() : fieldValue;
        }
        return key;
    }

    protected void setContext(IncrementalSnapshotContext<T> context) {
        this.context = context;
    }

    protected void preReadChunk(IncrementalSnapshotContext<T> context) {
        try {
            if (!this.jdbcConnection.isValid()) {
                this.jdbcConnection.connect();
            }
        }
        catch (SQLException e) {
            throw new DebeziumException("Database error while checking jdbcConnection in preReadChunk", (Throwable)e);
        }
    }

    protected void postReadChunk(IncrementalSnapshotContext<T> context) {
    }

    protected void postIncrementalSnapshotCompleted() {
    }

    protected Table refreshTableSchema(Table table) throws SQLException {
        return table;
    }

    private Key.KeyMapper getKeyMapper() {
        return this.connectorConfig.getKeyMapper() == null ? table -> table.primaryKeyColumns() : this.connectorConfig.getKeyMapper();
    }

    private List<Column> getQueryColumns(Table table) {
        Optional<String> surrogateKey;
        if (this.context != null && this.context.currentDataCollectionId() != null && (surrogateKey = this.context.currentDataCollectionId().getSurrogateKey()).isPresent()) {
            return Collections.singletonList(table.columnWithName(surrogateKey.get()));
        }
        return this.getKeyMapper().getKeyKolumns(table);
    }
}

