/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SqlServerSchemaNameAdjustmentModeIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE [name-adjustment] (id INT)", "INSERT INTO [name-adjustment] (id) VALUES (1);"});
        TestHelper.enableTableCdc(this.connection, "name-adjustment");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldAdjustNamesForAvro() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO);
        Assertions.assertThat((String)data.schema().name()).contains(new CharSequence[]{"name_adjustment"});
    }

    @Test
    public void shouldNotAdjustNames() throws InterruptedException {
        this.skipAvroValidation();
        Struct data = this.consume(CommonConnectorConfig.SchemaNameAdjustmentMode.NONE);
        Assertions.assertThat((String)data.schema().name()).contains(new CharSequence[]{"name-adjustment"});
    }

    private Struct consume(CommonConnectorConfig.SchemaNameAdjustmentMode adjustmentMode) throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.name-adjustment")).with(SqlServerConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)adjustmentMode)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List results = records.recordsForTopic("server1.testDB1.dbo.name-adjustment");
        Assertions.assertThat((List)results).hasSize(1);
        return (Struct)((SourceRecord)results.get(0)).value();
    }
}

