/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public class NotificationsIT
extends AbstractNotificationsIT<SqlServerConnector> {
    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        SqlServerConnection sqlServerConnection = TestHelper.testConnection();
        sqlServerConnection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb varchar(30))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(sqlServerConnection, "tablea");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() {
        this.stopConnector();
        TestHelper.dropTestDatabase();
    }

    protected Class<SqlServerConnector> connectorClass() {
        return SqlServerConnector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY);
    }

    protected String connector() {
        return "sql_server";
    }

    protected String server() {
        return "server1";
    }

    protected String task() {
        return "0";
    }

    protected String database() {
        return "testDB1";
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }
}

