/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.Nullable;
import io.debezium.util.Strings;
import java.util.Arrays;

public class Lsn
implements Comparable<Lsn>,
Nullable {
    private static final String NULL_STRING = "NULL";
    public static final Lsn NULL = new Lsn(null);
    private final byte[] binary;
    private int[] unsignedBinary;
    private String string;

    private Lsn(byte[] binary) {
        this.binary = binary;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public boolean isAvailable() {
        return this.binary != null;
    }

    private int[] getUnsignedBinary() {
        if (this.unsignedBinary != null || this.binary == null) {
            return this.unsignedBinary;
        }
        this.unsignedBinary = new int[this.binary.length];
        for (int i = 0; i < this.binary.length; ++i) {
            this.unsignedBinary[i] = Byte.toUnsignedInt(this.binary[i]);
        }
        return this.unsignedBinary;
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        StringBuilder sb = new StringBuilder();
        if (this.binary == null) {
            return NULL_STRING;
        }
        int[] unsigned = this.getUnsignedBinary();
        for (int i = 0; i < unsigned.length; ++i) {
            String byteStr = Integer.toHexString(unsigned[i]);
            if (byteStr.length() == 1) {
                sb.append('0');
            }
            sb.append(byteStr);
            if (i != 3 && i != 7) continue;
            sb.append(':');
        }
        this.string = sb.toString();
        return this.string;
    }

    public static Lsn valueOf(String lsnString) {
        return lsnString == null || NULL_STRING.equals(lsnString) ? NULL : new Lsn(Strings.hexStringToByteArray((String)lsnString.replace(":", "")));
    }

    public static Lsn valueOf(byte[] lsnBinary) {
        return lsnBinary == null ? NULL : new Lsn(lsnBinary);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.binary);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lsn other = (Lsn)obj;
        return Arrays.equals(this.binary, other.binary);
    }

    @Override
    public int compareTo(Lsn o) {
        if (this == o) {
            return 0;
        }
        if (!this.isAvailable()) {
            if (!o.isAvailable()) {
                return 0;
            }
            return -1;
        }
        if (!o.isAvailable()) {
            return 1;
        }
        int[] thisU = this.getUnsignedBinary();
        int[] thatU = o.getUnsignedBinary();
        for (int i = 0; i < thisU.length; ++i) {
            int diff = thisU[i] - thatU[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean isBetween(Lsn from, Lsn to) {
        return this.compareTo(from) >= 0 && this.compareTo(to) < 0;
    }
}

