/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.util;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerJdbcConfiguration;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.utils.Sanitizer;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    public static final String TEST_DATABASE_1 = "testDB1";
    public static final String TEST_DATABASE_2 = "testDB2";
    public static final String TEST_SERVER_NAME = "server1";
    private static final String TEST_PROPERTY_PREFIX = "debezium.test.";
    private static final String TEST_TASK_ID = "0";
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String SCHEMA_PLACEHOLDER = "%";
    private static final String ENABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=0)\nEXEC sys.sp_cdc_enable_db";
    private static final String DISABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=1)\nEXEC sys.sp_cdc_disable_db";
    private static final String ENABLE_TABLE_CDC = "IF EXISTS(select 1 from sys.tables where name = '#' AND is_tracked_by_cdc=0)\nEXEC sys.sp_cdc_enable_table @source_schema = N'%', @source_name = N'#', @role_name = NULL, @supports_net_changes = 0";
    private static final String IS_CDC_ENABLED = "SELECT COUNT(1) FROM sys.databases WHERE name = '#' AND is_cdc_enabled=1";
    private static final String IS_CDC_TABLE_ENABLED = "SELECT COUNT(*) FROM sys.tables tb WHERE tb.is_tracked_by_cdc = 1 AND tb.name='#'";
    private static final String ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE = "EXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'%s', @capture_instance = N'%s', @role_name = NULL, @supports_net_changes = 0, @captured_column_list = %s";
    private static final String DISABLE_TABLE_CDC = "EXEC sys.sp_cdc_disable_table @source_schema = N'dbo', @source_name = N'#', @capture_instance = 'all'";
    private static final String ADJUST_CDC_POLLING_INTERVAL = "EXEC sys.sp_cdc_change_job @job_type = 'capture', @pollinginterval = #";
    private static final String CDC_WRAPPERS_DML;
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static JdbcConfiguration jdbcConfig(String user, String password) {
        return (JdbcConfiguration)JdbcConfiguration.copy((Configuration)TestHelper.defaultJdbcConfig()).withUser(user).withPassword(password).build();
    }

    public static Configuration.Builder defaultConnectorConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(CommonConnectorConfig.TOPIC_PREFIX, TEST_SERVER_NAME)).with(SqlServerConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static Configuration.Builder defaultConfig() {
        return TestHelper.defaultConfig(TEST_DATABASE_1);
    }

    public static Configuration.Builder defaultConfig(String ... databaseNames) {
        return TestHelper.defaultConnectorConfig().with(SqlServerConnectorConfig.DATABASE_NAMES.name(), String.join((CharSequence)",", databaseNames));
    }

    public static void createTestDatabase() {
        TestHelper.createTestDatabase(TEST_DATABASE_1);
    }

    public static void createTestDatabases(String ... databaseNames) {
        for (String databaseName : databaseNames) {
            TestHelper.createTestDatabase(databaseName);
        }
    }

    public static void createTestDatabase(String databaseName) {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            TestHelper.dropTestDatabase(connection, databaseName);
            String sql = String.format("CREATE DATABASE [%s]\n", databaseName);
            connection.execute(new String[]{sql});
            connection.execute(new String[]{String.format("USE [%s]", databaseName)});
            connection.execute(new String[]{String.format("ALTER DATABASE [%s] SET ALLOW_SNAPSHOT_ISOLATION ON", databaseName)});
            TestHelper.enableDbCdc(connection, databaseName);
        }
        catch (SQLException e) {
            LOGGER.error("Error while initiating test database", (Throwable)e);
            throw new IllegalStateException("Error while initiating test database", e);
        }
    }

    public static void dropTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            TestHelper.dropTestDatabase(connection, TEST_DATABASE_1);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while dropping test database", e);
        }
    }

    private static void dropTestDatabase(SqlServerConnection connection, String databaseName) throws SQLException {
        try {
            Awaitility.await((String)"Disabling CDC").atMost(60L, TimeUnit.SECONDS).until(() -> {
                try {
                    connection.execute(new String[]{String.format("USE [%s]", databaseName)});
                }
                catch (SQLException e) {
                    return true;
                }
                try {
                    TestHelper.disableDbCdc(connection, databaseName);
                    return true;
                }
                catch (SQLException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException(String.format("Failed to disable CDC on %s", databaseName), e);
        }
        connection.execute(new String[]{"USE master"});
        try {
            Awaitility.await((String)String.format("Dropping database %s", databaseName)).atMost(60L, TimeUnit.SECONDS).until(() -> {
                try {
                    String sql = String.format("IF EXISTS(select 1 from sys.databases where name = '%s') DROP DATABASE [%s]", databaseName, databaseName);
                    connection.execute(new String[]{sql});
                    return true;
                }
                catch (SQLException e) {
                    LOGGER.warn(String.format("DROP DATABASE %s failed (will be retried): {}", databaseName), (Object)e.getMessage());
                    try {
                        connection.execute(new String[]{String.format("ALTER DATABASE [%s] SET SINGLE_USER WITH ROLLBACK IMMEDIATE;", databaseName)});
                    }
                    catch (SQLException e2) {
                        LOGGER.error("Failed to rollback immediately", (Throwable)e2);
                    }
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Failed to drop test database", e);
        }
    }

    public static SqlServerConnection adminConnection() {
        return new SqlServerConnection(SqlServerJdbcConfiguration.adapt((Configuration)TestHelper.defaultJdbcConfig()), new SqlServerValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, null), Collections.emptySet(), false);
    }

    public static SqlServerConnection testConnection() {
        return TestHelper.testConnection(TEST_DATABASE_1);
    }

    public static SqlServerConnection multiPartitionTestConnection() {
        return TestHelper.testConnection(TestHelper.defaultJdbcConfig());
    }

    public static SqlServerConnection testConnection(String databaseName) {
        JdbcConfiguration config = JdbcConfiguration.adapt((Configuration)((Configuration.Builder)TestHelper.defaultJdbcConfig().edit().with(JdbcConfiguration.ON_CONNECT_STATEMENTS, "USE [" + databaseName + "]")).build());
        return TestHelper.testConnection(config);
    }

    public static SqlServerConnection testConnection(JdbcConfiguration config) {
        return new SqlServerConnection(SqlServerJdbcConfiguration.adapt((Configuration)config), new SqlServerValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, null), Collections.emptySet(), false);
    }

    public static SqlServerConnection testConnectionWithOptionRecompile() {
        JdbcConfiguration config = JdbcConfiguration.adapt((Configuration)((Configuration.Builder)TestHelper.defaultJdbcConfig().edit().with(JdbcConfiguration.DATABASE, TEST_DATABASE_1)).build());
        return new SqlServerConnection(SqlServerJdbcConfiguration.adapt((Configuration)config), new SqlServerValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, null), Collections.emptySet(), true, true);
    }

    public static void enableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        try {
            Objects.requireNonNull(name);
            connection.execute(new String[]{ENABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> {
                String sql = IS_CDC_ENABLED.replace(STATEMENTS_PLACEHOLDER, name);
                return (Long)connection.queryAndMap(sql, connection.singleResultMapper(rs -> rs.getLong(1), "")) == 1L;
            });
        }
        catch (SQLException e) {
            LOGGER.error("Failed to enable CDC on database " + name);
            throw e;
        }
    }

    protected static void disableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        connection.execute(new String[]{DISABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    public static void enableSchemaTableCdc(SqlServerConnection connection, TableId tableId) throws SQLException {
        Objects.requireNonNull(tableId.schema());
        Objects.requireNonNull(tableId.table());
        String enableCdcForTableStmt = ENABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, tableId.table()).replace(SCHEMA_PLACEHOLDER, tableId.schema());
        String generateWrapperFunctionsStmts = CDC_WRAPPERS_DML.replaceAll(STATEMENTS_PLACEHOLDER, tableId.table().replaceAll("\\$", "\\\\\\$"));
        connection.execute(new String[]{enableCdcForTableStmt, generateWrapperFunctionsStmts});
    }

    public static void enableTableCdc(SqlServerConnection connection, String name) throws SQLException {
        TestHelper.enableSchemaTableCdc(connection, new TableId(null, "dbo", name));
    }

    public static boolean isCdcEnabled(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String tableEnabledStmt = IS_CDC_TABLE_ENABLED.replace(STATEMENTS_PLACEHOLDER, name);
        return (Boolean)connection.queryAndMap(tableEnabledStmt, connection.singleResultMapper(rs -> rs.getInt(1) > 0, "Cannot get CDC status of the table"));
    }

    public static void enableTableCdc(SqlServerConnection connection, String tableName, String captureName) throws SQLException {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(captureName);
        String enableCdcForTableStmt = String.format(ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE, tableName, captureName, "NULL");
        connection.execute(new String[]{enableCdcForTableStmt});
    }

    public static void enableTableCdc(JdbcConnection connection, String tableName, String captureName, List<String> captureColumnList) throws SQLException {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(captureName);
        Objects.requireNonNull(captureColumnList);
        String captureColumnListParam = String.format("N'%s'", Strings.join((CharSequence)",", captureColumnList));
        String enableCdcForTableStmt = String.format(ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE, tableName, captureName, captureColumnListParam);
        connection.execute(new String[]{enableCdcForTableStmt});
    }

    public static void disableTableCdc(JdbcConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String disableCdcForTableStmt = DISABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        connection.execute(new String[]{disableCdcForTableStmt});
    }

    public static void adjustCdcPollingInterval(JdbcConnection connection, int interval) throws SQLException {
        String adjustCdcPollingIntervalStmt = ADJUST_CDC_POLLING_INTERVAL.replace(STATEMENTS_PLACEHOLDER, Integer.toString(interval));
        connection.execute(new String[]{adjustCdcPollingIntervalStmt});
    }

    public static void waitForSnapshotToBeCompleted() {
        TestHelper.waitForDatabaseSnapshotToBeCompleted(TEST_DATABASE_1);
    }

    public static void waitForDatabaseSnapshotToBeCompleted(String databaseName) {
        TestHelper.waitForSnapshotToBeCompleted(TestHelper.getObjectName("snapshot", TEST_SERVER_NAME, databaseName));
    }

    public static void waitForDatabaseSnapshotsToBeCompleted(String ... databaseNames) {
        for (String databaseName : databaseNames) {
            TestHelper.waitForDatabaseSnapshotToBeCompleted(databaseName);
        }
    }

    private static void waitForSnapshotToBeCompleted(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Awaitility.await((String)"Snapshot not completed").atMost(Duration.ofSeconds(60L)).until(() -> {
                try {
                    return (boolean)((Boolean)mbeanServer.getAttribute(objectName, "SnapshotCompleted"));
                }
                catch (InstanceNotFoundException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("Snapshot did not complete", e);
        }
    }

    public static void waitForTaskStreamingStarted(String taskId) {
        TestHelper.waitForStreamingStarted(TestHelper.getObjectName(Collect.linkMapOf((Object)"server", (Object)TEST_SERVER_NAME, (Object)"task", (Object)taskId, (Object)"context", (Object)"streaming")));
    }

    public static void waitForStreamingStarted() {
        TestHelper.waitForTaskStreamingStarted(TEST_TASK_ID);
    }

    public static void waitForStreamingStarted(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Awaitility.await((String)"Streaming never started").atMost(Duration.ofSeconds(60L)).until(() -> {
                try {
                    return (boolean)((Boolean)mbeanServer.getAttribute(objectName, "Connected"));
                }
                catch (InstanceNotFoundException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("Streaming did not start", e);
        }
    }

    public static void waitForMaxLsnAvailable(SqlServerConnection connection) throws Exception {
        TestHelper.waitForMaxLsnAvailable(connection, TEST_DATABASE_1);
    }

    public static void waitForMaxLsnAvailable(SqlServerConnection connection, String databaseName) throws Exception {
        try {
            Awaitility.await((String)"Max LSN not available").atMost(60L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> connection.getMaxLsn(databaseName).isAvailable());
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("A max LSN was not available", e);
        }
    }

    private static ObjectName getObjectName(String context, String serverName) {
        return TestHelper.getObjectName(Collect.linkMapOf((Object)"context", (Object)context, (Object)"server", (Object)serverName));
    }

    private static ObjectName getObjectName(String context, String serverName, String databaseName) {
        return TestHelper.getObjectName(Collect.linkMapOf((Object)"server", (Object)serverName, (Object)"task", (Object)TEST_TASK_ID, (Object)"context", (Object)context, (Object)"database", (Object)databaseName));
    }

    private static ObjectName getObjectName(Map<String, String> tags) {
        String metricName = "debezium.sql_server:type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + Sanitizer.jmxSanitize((String)((String)e.getValue()))).collect(Collectors.joining(","));
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e2) {
            throw new IllegalArgumentException("Unable to build object name", e2);
        }
    }

    public static int waitTimeForRecords() {
        return Integer.parseInt(System.getProperty("debezium.test.records.waittime", "5"));
    }

    public static int waitTimeForLogEntries() {
        return Integer.parseInt(System.getProperty("debezium.test.log.waittime", "15"));
    }

    public static void waitForCdcRecord(SqlServerConnection connection, String tableName, CdcRecordHandler handler) {
        try {
            Awaitility.await((String)("Checking for expected record in CDC table for " + tableName)).atMost(60L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> {
                if (!connection.getMaxLsn(TEST_DATABASE_1).isAvailable()) {
                    return false;
                }
                for (SqlServerChangeTable ct : connection.getChangeTables(TEST_DATABASE_1)) {
                    String ctTableName = ct.getChangeTableId().table();
                    if (!ctTableName.endsWith("dbo_" + connection.getNameOfChangeTable(tableName))) continue;
                    try {
                        Lsn minLsn = connection.getMinLsn(TEST_DATABASE_1, ctTableName);
                        Lsn maxLsn = connection.getMaxLsn(TEST_DATABASE_1);
                        CdcRecordFoundBlockingMultiResultSetConsumer consumer = new CdcRecordFoundBlockingMultiResultSetConsumer(handler);
                        SqlServerChangeTable[] tables = Collections.singletonList(ct).toArray(new SqlServerChangeTable[0]);
                        connection.getChangesForTables(TEST_DATABASE_1, tables, minLsn, maxLsn, (JdbcConnection.BlockingMultiResultSetConsumer)consumer);
                        return consumer.isFound();
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("An insufficient number of arguments were supplied")) {
                            return false;
                        }
                        throw new AssertionError("Failed to fetch changes for " + tableName, e);
                    }
                }
                return false;
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Expected record never appeared in the CDC table", e);
        }
    }

    public static void waitForEnabledCdc(SqlServerConnection connection, String table) throws SQLException, InterruptedException {
        Awaitility.await((String)("CDC " + table)).atMost(1L, TimeUnit.MINUTES).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> TestHelper.isCdcEnabled(connection, table));
    }

    public static void waitForDisabledCdc(SqlServerConnection connection, String table) throws SQLException, InterruptedException {
        Awaitility.await((String)("CDC " + table)).atMost(1L, TimeUnit.MINUTES).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> !TestHelper.isCdcEnabled(connection, table));
    }

    public static void waitForCdcRecord(SqlServerConnection connection, String tableName, String captureInstanceName, CdcRecordHandler handler) {
        try {
            Awaitility.await((String)("Checking for expected record in CDC table for " + tableName)).atMost(30L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> {
                if (!connection.getMaxLsn(TEST_DATABASE_1).isAvailable()) {
                    return false;
                }
                for (SqlServerChangeTable ct : connection.getChangeTables(TEST_DATABASE_1)) {
                    String ctTableName = ct.getChangeTableId().table();
                    if (!ctTableName.endsWith(connection.getNameOfChangeTable(captureInstanceName))) continue;
                    try {
                        Lsn minLsn = connection.getMinLsn(TEST_DATABASE_1, ctTableName);
                        Lsn maxLsn = connection.getMaxLsn(TEST_DATABASE_1);
                        CdcRecordFoundBlockingMultiResultSetConsumer consumer = new CdcRecordFoundBlockingMultiResultSetConsumer(handler);
                        SqlServerChangeTable[] tables = Collections.singletonList(ct).toArray(new SqlServerChangeTable[0]);
                        connection.getChangesForTables(TEST_DATABASE_1, tables, minLsn, maxLsn, (JdbcConnection.BlockingMultiResultSetConsumer)consumer);
                        return consumer.isFound();
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("An insufficient number of arguments were supplied")) {
                            return false;
                        }
                        throw new AssertionError("Failed to fetch changes for " + tableName, e);
                    }
                }
                return false;
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Expected record never appeared in the CDC table", e);
        }
    }

    public static void waitForCdcTransactionPropagation(SqlServerConnection connection, String dbName, int expectedTransactions) throws SQLException {
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            int transactions = (Integer)connection.queryAndMap(String.format("SELECT COUNT(start_lsn) FROM [%s].cdc.lsn_time_mapping WHERE tran_id <> 0x00", dbName), rs -> {
                rs.next();
                return rs.getInt(1);
            });
            return expectedTransactions == transactions;
        });
    }

    public static String topicName(String databaseName, String tableName) {
        return String.join((CharSequence)".", TEST_SERVER_NAME, databaseName, "dbo", tableName);
    }

    static {
        try {
            ClassLoader classLoader = TestHelper.class.getClassLoader();
            CDC_WRAPPERS_DML = IoUtil.read((InputStream)classLoader.getResourceAsStream("generate_cdc_wrappers.sql"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load SQL Server statements", e);
        }
    }

    @FunctionalInterface
    public static interface CdcRecordHandler {
        public boolean apply(ResultSet var1) throws SQLException;
    }

    static class CdcRecordFoundBlockingMultiResultSetConsumer
    implements JdbcConnection.BlockingMultiResultSetConsumer {
        private final CdcRecordHandler handler;
        private boolean found;

        CdcRecordFoundBlockingMultiResultSetConsumer(CdcRecordHandler handler) {
            this.handler = handler;
        }

        public void accept(ResultSet[] rs) throws SQLException, InterruptedException {
            if (rs.length == 1) {
                ResultSet resultSet = rs[0];
                while (resultSet.next()) {
                    if (!this.handler.apply(resultSet)) continue;
                    this.found = true;
                    break;
                }
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }
}

