/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Test;

public class SpecialCharsInNamesIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1546"})
    public void shouldParseWhitespaceChars() throws Exception {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.UAT WAG CZ\\$Fixed Asset.*, dbo\\.UAT WAG CZ\\$Fixed Prop.*")).build();
        this.connection.execute(new String[]{"CREATE TABLE [UAT WAG CZ$Fixed Asset] (id int primary key, [my col$a] varchar(30))", "CREATE TABLE [UAT WAG CZ$Fixed Prop] (id int primary key, [my col$a] varchar(30))", "INSERT INTO [UAT WAG CZ$Fixed Asset] VALUES(1, 'asset')", "INSERT INTO [UAT WAG CZ$Fixed Prop] VALUES(1, 'prop')"});
        TestHelper.enableTableCdc(this.connection, "UAT WAG CZ$Fixed Asset");
        TestHelper.enableTableCdc(this.connection, "person");
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords actualRecords = this.consumeRecordsByTopic(2, false);
        Assertions.assertThat((List)actualRecords.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset")).hasSize(1);
        Assertions.assertThat((List)actualRecords.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Prop")).hasSize(1);
        List carRecords = actualRecords.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset");
        Assertions.assertThat((int)carRecords.size()).isEqualTo(1);
        SourceRecord carRecord = (SourceRecord)carRecords.get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)carRecord.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Value").field("id", Schema.INT32_SCHEMA).field("my col$a", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)carRecord.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((String)((Struct)carRecord.value()).getStruct("after").getString("my col$a")).isEqualTo((Object)"asset");
        List personRecords = actualRecords.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Prop");
        Assertions.assertThat((int)personRecords.size()).isEqualTo(1);
        SourceRecord personRecord = (SourceRecord)personRecords.get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)personRecord.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Prop.Value").field("id", Schema.INT32_SCHEMA).field("my col$a", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)personRecord.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Prop.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((String)((Struct)personRecord.value()).getStruct("after").getString("my col$a")).isEqualTo((Object)"prop");
    }

    @Test
    @FixFor(value={"DBZ-1153"})
    public void shouldParseSpecialChars() throws Exception {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.UAT WAG CZ\\$Fixed Asset.*")).with(SqlServerConnectorConfig.SANITIZE_FIELD_NAMES, true)).build();
        this.connection.execute(new String[]{"CREATE TABLE [UAT WAG CZ$Fixed Asset] (id int primary key, [my col$a] varchar(30))", "INSERT INTO [UAT WAG CZ$Fixed Asset] VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "UAT WAG CZ$Fixed Asset");
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset")).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Value").field("id", Schema.INT32_SCHEMA).field("my_col_a", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)record.value()).getStruct("after").getInt32("id")).isEqualTo(1);
        this.connection.execute(new String[]{"INSERT INTO [UAT WAG CZ$Fixed Asset] VALUES(2, 'b')"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Value").field("id", Schema.INT32_SCHEMA).field("my_col_a", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)record.value()).getStruct("after").getInt32("id")).isEqualTo(2);
        this.connection.execute(new String[]{"CREATE TABLE [UAT WAG CZ$Fixed Asset Two] (id int primary key, [my col$] varchar(30), Description varchar(30) NOT NULL)"});
        TestHelper.enableTableCdc(this.connection, "UAT WAG CZ$Fixed Asset Two");
        this.connection.execute(new String[]{"INSERT INTO [UAT WAG CZ$Fixed Asset Two] VALUES(3, 'b', 'empty')"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two.Value").field("id", Schema.INT32_SCHEMA).field("my_col_", Schema.OPTIONAL_STRING_SCHEMA).field("Description", Schema.STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)record.value()).getStruct("after").getInt32("id")).isEqualTo(3);
        this.connection.execute(new String[]{"UPDATE [UAT WAG CZ$Fixed Asset Two] SET Description='c1' WHERE id=3"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two.Value").field("id", Schema.INT32_SCHEMA).field("my_col_", Schema.OPTIONAL_STRING_SCHEMA).field("Description", Schema.STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("before"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset_Two.Value").field("id", Schema.INT32_SCHEMA).field("my_col_", Schema.OPTIONAL_STRING_SCHEMA).field("Description", Schema.STRING_SCHEMA).build());
        Assertions.assertThat((String)((Struct)record.value()).getStruct("after").getString("Description")).isEqualTo((Object)"c1");
        Assertions.assertThat((String)((Struct)record.value()).getStruct("before").getString("Description")).isEqualTo((Object)"empty");
        this.stopConnector();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.connection.execute(new String[]{"INSERT INTO [UAT WAG CZ$Fixed Asset] VALUES(4, 'b')"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Value").field("id", Schema.INT32_SCHEMA).field("my_col_a", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.UAT_WAG_CZ_Fixed_Asset.Key").field("id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)record.value()).getStruct("after").getInt32("id")).isEqualTo(4);
    }

    @Test
    @FixFor(value={"DBZ-4125"})
    public void shouldHandleSpecialCharactersInDatabaseNames() throws Exception {
        String databaseName = "test-db";
        TestHelper.createTestDatabase("test-db");
        this.connection = TestHelper.testConnection("test-db");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig("test-db").with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.SANITIZE_FIELD_NAMES, false)).with(CommonConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO)).build();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords recordsByTopic = this.consumeRecordsByTopic(1);
        List records = recordsByTopic.recordsForTopic("server1.test-db.dbo.tablea");
        Assertions.assertThat((List)records).hasSize(1);
        Struct source = (Struct)((Struct)((SourceRecord)records.get(0)).value()).get("source");
        Assertions.assertThat((Object)source.get("db")).isEqualTo((Object)"test-db");
        TestHelper.waitForMaxLsnAvailable(this.connection, "test-db");
    }
}

