/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SqlServerChangeTableSetIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb varchar(30))", "CREATE TABLE tablec (id int primary key, colc varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        TestHelper.enableTableCdc(this.connection, "tableb");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void addTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        TestHelper.enableTableCdc(this.connection, "tablec");
        this.connection.execute(new String[]{"CREATE TABLE tabled (id int primary key, cold varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "tabled");
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablec VALUES(" + id + ", 'c')"});
            this.connection.execute(new String[]{"INSERT INTO tabled VALUES(" + id + ", 'd')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablec")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tabled")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tablec").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tablec.Value").field("id", Schema.INT32_SCHEMA).field("colc", Schema.OPTIONAL_STRING_SCHEMA).build()));
        records.recordsForTopic("server1.testDB1.dbo.tabled").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tabled.Value").field("id", Schema.INT32_SCHEMA).field("cold", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }

    @Test
    public void removeTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        TestHelper.disableTableCdc((JdbcConnection)this.connection, "tableb");
        for (int i = 0; i < 5; ++i) {
            int id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b2')"});
        }
        records = this.consumeRecordsByTopic(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).isNullOrEmpty();
    }

    @Test
    public void addColumnToTableEndOfBatchWithoutLsnLimit() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.addColumnToTable(config, true);
    }

    @Test
    @FixFor(value={"DBZ-3992"})
    public void addColumnToTableEndOfBatchWithLsnLimit() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.MAX_TRANSACTIONS_PER_ITERATION, 1)).build();
        this.addColumnToTable(config, true);
    }

    @Test
    public void addColumnToTableMiddleOfBatchWithoutLsnLimit() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.addColumnToTable(config, false);
    }

    @Test
    @FixFor(value={"DBZ-3992"})
    public void addColumnToTableMiddleOfBatchWithLsnLimit() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.MAX_TRANSACTIONS_PER_ITERATION, 1)).build();
        this.addColumnToTable(config, true);
    }

    private void addColumnToTable(Configuration config, boolean pauseAfterCaptureChange) throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        int ID_START_4 = 10000;
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = 10 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ADD newcol INT NOT NULL DEFAULT 0"});
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b2', 2)"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        if (pauseAfterCaptureChange) {
            Thread.sleep(5000L);
        }
        for (i = 0; i < 5; ++i) {
            id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b3', 3)"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).field("newcol", SchemaBuilder.int32().defaultValue((Object)0).build()).build()));
        for (i = 0; i < 5; ++i) {
            id = 10000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a4')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b4', 4)"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).field("newcol", SchemaBuilder.int32().defaultValue((Object)0).build()).build()));
    }

    @Test
    public void removeColumnFromTable() throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = 10 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb DROP COLUMN colb"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ")"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).build()));
        for (i = 0; i < 5; ++i) {
            id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ")"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).build()));
    }

    @Test
    @FixFor(value={"DBZ-2716"})
    public void removeColumnFromTableWithoutChangingCapture() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE tableb2 (colb1 varchar(30), id int primary key, colb2 varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "tableb2");
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb2 DROP COLUMN colb1"});
        int RECORDS_PER_TABLE = 5;
        boolean TABLES = true;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tableb2")).with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.COLUMN_INCLUDE_LIST, ".*id")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tableb2 VALUES(" + id + ", 'b2')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb2")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb2").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb2.Value").field("id", Schema.INT32_SCHEMA).build()));
    }

    @Test
    public void addColumnToTableWithParallelWrites() throws Exception {
        int RECORDS_PER_TABLE = 20;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i = 0; i < 20; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(40);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(20);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(20);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        Executors.newSingleThreadExecutor().submit(() -> {
            try (SqlServerConnection connection = TestHelper.testConnection();){
                for (int i = 0; i < 20; ++i) {
                    int id = 100 + i;
                    connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
                    connection.execute(new String[]{"INSERT INTO tableb(id,colb) VALUES(" + id + ",'b')"});
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        });
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ADD colb2 VARCHAR(32)"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        records = this.consumeRecordsByTopic(40);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(20);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(20);
        AtomicInteger beforeChangeCount = new AtomicInteger();
        AtomicInteger afterChangeCount = new AtomicInteger();
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> {
            if (((Struct)record.value()).getStruct("after").schema().field("colb2") != null) {
                afterChangeCount.incrementAndGet();
            } else {
                beforeChangeCount.incrementAndGet();
                Assertions.assertThat((int)afterChangeCount.intValue()).isZero();
            }
        });
        Assertions.assertThat((int)beforeChangeCount.intValue()).isPositive();
        Assertions.assertThat((int)afterChangeCount.intValue()).isPositive();
        for (int i = 0; i < 20; ++i) {
            int id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b1', 'b2')"});
        }
        records = this.consumeRecordsByTopic(40);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(20);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(20);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).field("colb2", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }

    @Test
    public void readHistoryAfterRestart() throws Exception {
        int id;
        int i;
        boolean RECORDS_PER_TABLE = true;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        for (int i2 = 0; i2 < 1; ++i2) {
            int id2 = 10 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(1);
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb DROP COLUMN colb"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        for (i = 0; i < 1; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ")"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(1);
        this.stopConnector();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        for (i = 0; i < 1; ++i) {
            id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ")"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(1);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).build()));
        DocumentReader reader = DocumentReader.defaultReader();
        ArrayList changes = new ArrayList();
        IoUtil.readLines((Path)TestHelper.SCHEMA_HISTORY_PATH, line -> {
            try {
                changes.add(reader.read(line));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        Assertions.assertThat(changes).hasSize(4);
        changes.subList(0, 3).forEach(change -> {
            Array changeArray = change.getArray((CharSequence)"tableChanges");
            Assertions.assertThat((int)changeArray.size()).isEqualTo(1);
            String type = changeArray.get(0).asDocument().getString((CharSequence)"type");
            Assertions.assertThat((String)type).isEqualTo((Object)"CREATE");
        });
        Array changeArray = ((Document)changes.get(3)).getArray((CharSequence)"tableChanges");
        Assertions.assertThat((int)changeArray.size()).isEqualTo(1);
        String type = changeArray.get(0).asDocument().getString((CharSequence)"type");
        String tableIid = changeArray.get(0).asDocument().getString((CharSequence)"id");
        Assertions.assertThat((String)type).isEqualTo((Object)"ALTER");
        Assertions.assertThat((String)tableIid).isEqualTo((Object)"\"testDB1\".\"dbo\".\"tableb\"");
    }

    @Test
    public void renameColumn() throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = 10 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        TestHelper.disableTableCdc((JdbcConnection)this.connection, "tableb");
        this.connection.execute(new String[]{"exec sp_rename 'tableb.colb', 'newcolb';"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb(id,newcolb) VALUES(" + id + ", 'b2')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("newcolb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        for (i = 0; i < 5; ++i) {
            id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b3')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("newcolb", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }

    @Test
    public void changeColumn() throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = 10 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", '" + id2 + "')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> {
            this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build());
            Struct value = ((Struct)record.value()).getStruct("after");
            int id = value.getInt32("id");
            String colb = value.getString("colb");
            Assertions.assertThat((String)Integer.toString(id)).isEqualTo((Object)colb);
        });
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ALTER COLUMN colb INT"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", '" + id + " ')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> {
            this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_INT32_SCHEMA).build());
            Struct value = ((Struct)record.value()).getStruct("after");
            int id = value.getInt32("id");
            int colb = value.getInt32("colb");
            Assertions.assertThat((int)id).isEqualTo(colb);
        });
        for (i = 0; i < 5; ++i) {
            id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", '" + id + " ')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.testDB1.dbo.tableb").forEach(record -> {
            this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_INT32_SCHEMA).build());
            Struct value = ((Struct)record.value()).getStruct("after");
            int id = value.getInt32("id");
            int colb = value.getInt32("colb");
            Assertions.assertThat((int)id).isEqualTo(colb);
        });
    }

    @Test
    @FixFor(value={"DBZ-1491"})
    public void addDefaultValue() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        TestHelper.waitForStreamingStarted();
        TestHelper.waitForMaxLsnAvailable(this.connection);
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ADD DEFAULT ('default_value') FOR colb"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES('1', 'some_value')"});
        TestHelper.waitForCdcRecord(this.connection, "tableb", "after_change", rs -> rs.getInt("id") == 1);
        List records = this.consumeRecordsByTopic(1).recordsForTopic("server1.testDB1.dbo.tableb");
        Assertions.assertThat((List)records).hasSize(1);
        Testing.debug((Object)("Records: " + records));
        Testing.debug((Object)("Value Schema: " + ((SourceRecord)records.get(0)).valueSchema()));
        Testing.debug((Object)("Fields: " + ((SourceRecord)records.get(0)).valueSchema().fields()));
        Testing.debug((Object)("After Schema: " + ((SourceRecord)records.get(0)).valueSchema().field("after").schema()));
        Testing.debug((Object)("After Columns: " + ((SourceRecord)records.get(0)).valueSchema().field("after").schema().fields()));
        Schema colbSchema = ((SourceRecord)records.get(0)).valueSchema().field("after").schema().field("colb").schema();
        Testing.debug((Object)("ColumnB Schema: " + colbSchema));
        Testing.debug((Object)("ColumnB Schema Default Value: " + colbSchema.defaultValue()));
        Assertions.assertThat((Object)colbSchema.defaultValue()).isNotNull();
        Assertions.assertThat((Object)colbSchema.defaultValue()).isEqualTo((Object)"default_value");
    }

    @Test
    @FixFor(value={"DBZ-1491"})
    public void alterDefaultValue() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE table_dv (id int primary key, colb varchar(30))"});
        this.connection.execute(new String[]{"ALTER TABLE dbo.table_dv ADD CONSTRAINT DV_colb DEFAULT ('default_value') FOR colb"});
        TestHelper.enableTableCdc(this.connection, "table_dv");
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.connection.execute(new String[]{"INSERT INTO table_dv VALUES('1', 'some_value')"});
        this.consumeRecordsByTopic(1);
        this.connection.execute(new String[]{"ALTER TABLE dbo.table_dv DROP CONSTRAINT DV_colb"});
        this.connection.execute(new String[]{"ALTER TABLE dbo.table_dv ADD DEFAULT ('new_default_value') FOR colb"});
        TestHelper.enableTableCdc(this.connection, "table_dv", "after_change");
        this.connection.execute(new String[]{"INSERT INTO table_dv VALUES('2', 'some_value2')"});
        List records = this.consumeRecordsByTopic(1).recordsForTopic("server1.testDB1.dbo.table_dv");
        Assertions.assertThat((List)records).hasSize(1);
        Schema colbSchema = ((SourceRecord)records.get(0)).valueSchema().field("after").schema().field("colb").schema();
        Assertions.assertThat((Object)colbSchema.defaultValue()).isNotNull();
        Assertions.assertThat((Object)colbSchema.defaultValue()).isEqualTo((Object)"new_default_value");
    }
}

