/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TablesWithoutPrimaryKeyIT
extends AbstractConnectorTest {
    private static final String DDL_STATEMENTS = "CREATE TABLE t1 (pk INT UNIQUE, val INT);CREATE TABLE t2 (pk INT UNIQUE, val INT UNIQUE);CREATE TABLE t3 (pk INT, val INT);";
    private static final String DML_STATEMENTS = "INSERT INTO t1 VALUES (1,10);INSERT INTO t2 VALUES (2,20);INSERT INTO t3 VALUES (3,30);";
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldProcessFromSnapshot() throws Exception {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE t1 (pk INT UNIQUE, val INT);CREATE TABLE t2 (pk INT UNIQUE, val INT UNIQUE);CREATE TABLE t3 (pk INT, val INT);INSERT INTO t1 VALUES (1,10);INSERT INTO t2 VALUES (2,20);INSERT INTO t3 VALUES (3,30);"});
        TestHelper.enableTableCdc(this.connection, "t1");
        TestHelper.enableTableCdc(this.connection, "t2");
        TestHelper.enableTableCdc(this.connection, "t3");
        this.start(SqlServerConnector.class, ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.t[123]")).build());
        this.assertConnectorIsRunning();
        int expectedRecordsCount = 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("pk")).isNotNull();
        Assertions.assertThat((List)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().fields()).hasSize(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().field("pk")).isNotNull();
        Assertions.assertThat((List)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().fields()).hasSize(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t3").get(0)).keySchema()).isNull();
    }

    @Test
    public void shouldProcessFromStreaming() throws Exception {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE init (pk INT PRIMARY KEY);", "INSERT INTO init VALUES (1);"});
        TestHelper.enableTableCdc(this.connection, "init");
        TestHelper.waitForDisabledCdc(this.connection, "t1");
        TestHelper.waitForDisabledCdc(this.connection, "t2");
        TestHelper.waitForDisabledCdc(this.connection, "t3");
        this.start(SqlServerConnector.class, ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build());
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.consumeRecordsByTopic(1);
        TestHelper.waitForStreamingStarted();
        TestHelper.waitForMaxLsnAvailable(this.connection);
        this.connection.execute(new String[]{DDL_STATEMENTS});
        Testing.Print.enable();
        TestHelper.enableTableCdc(this.connection, "t1");
        TestHelper.enableTableCdc(this.connection, "t2");
        TestHelper.enableTableCdc(this.connection, "t3");
        TestHelper.waitForEnabledCdc(this.connection, "t1");
        TestHelper.waitForEnabledCdc(this.connection, "t2");
        TestHelper.waitForEnabledCdc(this.connection, "t3");
        this.connection.execute(new String[]{"INSERT INTO t1 VALUES (1,10);"});
        this.connection.execute(new String[]{"INSERT INTO t2 VALUES (2,20);"});
        this.connection.execute(new String[]{"INSERT INTO t3 VALUES (3,30);"});
        TestHelper.waitForCdcRecord(this.connection, "t1", rs -> rs.getInt("pk") == 1);
        TestHelper.waitForCdcRecord(this.connection, "t2", rs -> rs.getInt("pk") == 2);
        TestHelper.waitForCdcRecord(this.connection, "t3", rs -> rs.getInt("pk") == 3);
        int expectedRecordsCount = 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3, 24);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("pk")).isNotNull();
        Assertions.assertThat((List)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().fields()).hasSize(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().field("pk")).isNotNull();
        Assertions.assertThat((List)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().fields()).hasSize(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t3").get(0)).keySchema()).isNull();
    }
}

