/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TablesWithUniqueIndexOnlyIT
extends AbstractConnectorTest {
    private static final String DDL_STATEMENTS = "CREATE TABLE t1 (key1 INT NOT NULL, key2 INT NOT NULL, data VARCHAR(255) NOT NULL, col4 INT NOT NULL);CREATE UNIQUE NONCLUSTERED INDEX indexa ON t1 (col4)CREATE UNIQUE NONCLUSTERED INDEX indexb ON t1 (key1, key2)";
    private static final String DDL_STATEMENTS_STREAM = "CREATE TABLE t2 (key1 INT NOT NULL, key2 INT NOT NULL, data VARCHAR(255) NOT NULL, col4 INT NOT NULL);CREATE UNIQUE NONCLUSTERED INDEX indexb ON t2 (key1, key2)CREATE UNIQUE NONCLUSTERED INDEX indexa ON t2 (col4)";
    private static final String DML_STATEMENTS = "INSERT INTO t1 VALUES (1, 10, 'data1', 100);";
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldProcessFromSnapshot() throws Exception {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE t1 (key1 INT NOT NULL, key2 INT NOT NULL, data VARCHAR(255) NOT NULL, col4 INT NOT NULL);CREATE UNIQUE NONCLUSTERED INDEX indexa ON t1 (col4)CREATE UNIQUE NONCLUSTERED INDEX indexb ON t1 (key1, key2)INSERT INTO t1 VALUES (1, 10, 'data1', 100);"});
        TestHelper.enableTableCdc((JdbcConnection)this.connection, "t1", "t1_CT", Collect.arrayListOf((Object)"key1", (Object[])new String[]{"key2", "data"}));
        this.start(SqlServerConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.t1")).with(SqlServerConnectorConfig.MSG_KEY_COLUMNS, "dbo.t1:key1,key2;")).build());
        this.assertConnectorIsRunning();
        boolean expectedRecordsCount = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key1")).isNotNull();
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key2")).isNotNull();
    }

    @Test
    public void shouldProcessFromStreaming() throws Exception {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE t1 (key1 INT NOT NULL, key2 INT NOT NULL, data VARCHAR(255) NOT NULL, col4 INT NOT NULL);CREATE UNIQUE NONCLUSTERED INDEX indexa ON t1 (col4)CREATE UNIQUE NONCLUSTERED INDEX indexb ON t1 (key1, key2)INSERT INTO t1 VALUES (1, 10, 'data1', 100);"});
        TestHelper.enableTableCdc((JdbcConnection)this.connection, "t1", "t1_CT", Collect.arrayListOf((Object)"key1", (Object[])new String[]{"key2", "data"}));
        this.start(SqlServerConnector.class, ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.MSG_KEY_COLUMNS, "dbo.t1:key1,key2;dbo.t2:key1,key2")).build());
        this.assertConnectorIsRunning();
        boolean expectedRecordsCount = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key1")).isNotNull();
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key2")).isNotNull();
        this.connection.execute(new String[]{"INSERT INTO t1 VALUES (2, 20, 'data2', 200);"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key1")).isNotNull();
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t1").get(0)).keySchema().field("key2")).isNotNull();
        this.connection.execute(new String[]{DDL_STATEMENTS_STREAM});
        TestHelper.enableTableCdc((JdbcConnection)this.connection, "t2", "t2_CT", Collect.arrayListOf((Object)"key1", (Object[])new String[]{"key2"}));
        TestHelper.waitForEnabledCdc(this.connection, "t2");
        this.connection.execute(new String[]{"INSERT INTO t2 VALUES (2, 20, 'data2', 200);"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().field("key1")).isNotNull();
        Assertions.assertThat((Object)((SourceRecord)records.recordsForTopic("server1.testDB1.dbo.t2").get(0)).keySchema().field("key2")).isNotNull();
    }
}

