/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlServerBinaryModeIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE binary_mode_test (id INT IDENTITY (1, 1) PRIMARY KEY, binary_col BINARY(3) NOT NULL, varbinary_col VARBINARY(3) NOT NULL)", "INSERT INTO binary_mode_test (binary_col, varbinary_col) VALUES (0x010203, 0x010203)"});
        TestHelper.enableTableCdc(this.connection, "binary_mode_test");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReceiveRawBinary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.BYTES);
        ByteBuffer expectedValue = ByteBuffer.wrap(new byte[]{1, 2, 3});
        Assert.assertEquals((Object)expectedValue, (Object)data.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)data.get("varbinary_col"));
    }

    @Test
    public void shouldReceiveHexBinary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.HEX);
        String expectedValue = "010203";
        Assert.assertEquals((Object)expectedValue, (Object)data.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)data.get("varbinary_col"));
    }

    @Test
    public void shouldReceiveBase64Binary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.BASE64);
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)data.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)data.get("varbinary_col"));
    }

    private Struct consume(CommonConnectorConfig.BinaryHandlingMode binaryMode) throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.binary_mode_test")).with(SqlServerConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)binaryMode)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List results = records.recordsForTopic("server1.testDB1.dbo.binary_mode_test");
        Assertions.assertThat((List)results).hasSize(1);
        return (Struct)((Struct)((SourceRecord)results.get(0)).value()).get("after");
    }
}

