/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.SkipTestRule;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotWithSchemaChangesSupportTest;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public class IncrementalSnapshotIT
extends AbstractIncrementalSnapshotWithSchemaChangesSupportTest<SqlServerConnector> {
    private SqlServerConnection connection;
    @Rule
    public SkipTestRule skipRule = new SkipTestRule();

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE a (pk int primary key, aa int)", "CREATE TABLE b (pk int primary key, aa int)", "CREATE TABLE debezium_signal (id varchar(64), type varchar(32), data varchar(2048))"});
        TestHelper.enableTableCdc(this.connection, "debezium_signal");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected void populateTable() throws SQLException {
        super.populateTable();
        TestHelper.enableTableCdc(this.connection, "a");
    }

    protected void populateTables() throws SQLException {
        super.populateTables();
        TestHelper.enableTableCdc(this.connection, "a");
        TestHelper.enableTableCdc(this.connection, "b");
    }

    protected Class<SqlServerConnector> connectorClass() {
        return SqlServerConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "server1.testDB1.dbo.a";
    }

    protected List<String> topicNames() {
        return List.of("server1.testDB1.dbo.a", "server1.testDB1.dbo.b");
    }

    protected String tableName() {
        return "testDB1.dbo.a";
    }

    protected List<String> tableNames() {
        return List.of("testDB1.dbo.a", "testDB1.dbo.b");
    }

    protected String tableName(String table) {
        return "testDB1.dbo." + table;
    }

    protected String signalTableName() {
        return "dbo.debezium_signal";
    }

    protected String alterColumnStatement(String table, String column, String type) {
        return String.format("ALTER TABLE %s ALTER COLUMN %s %s", table, column, type);
    }

    protected String alterColumnSetNotNullStatement(String table, String column, String type) {
        return String.format("ALTER TABLE %s ALTER COLUMN %s %s NOT NULL", table, column, type);
    }

    protected String alterColumnDropNotNullStatement(String table, String column, String type) {
        return String.format("ALTER TABLE %s ALTER COLUMN %s %s NULL", table, column, type);
    }

    protected String alterColumnSetDefaultStatement(String table, String column, String type, String defaultValue) {
        return String.format("ALTER TABLE %s ADD CONSTRAINT df_%s DEFAULT %s FOR %s", table, column, defaultValue, column);
    }

    protected String alterColumnDropDefaultStatement(String table, String column, String type) {
        return String.format("ALTER TABLE %s DROP CONSTRAINT df_%s", table, column);
    }

    protected void executeRenameTable(JdbcConnection connection, String newTable) throws SQLException {
        TestHelper.disableTableCdc(connection, "a");
        connection.setAutoCommit(false);
        this.logger.info(String.format("exec sp_rename '%s', '%s'", this.tableName(), "old_table"));
        connection.executeWithoutCommitting(new String[]{String.format("exec sp_rename '%s', '%s'", this.tableName(), "old_table")});
        this.logger.info(String.format("exec sp_rename '%s', '%s'", this.tableName(newTable), "a"));
        connection.executeWithoutCommitting(new String[]{String.format("exec sp_rename '%s', '%s'", this.tableName(newTable), "a")});
        TestHelper.enableTableCdc(connection, "a", "a", Arrays.asList("pk", "aa", "c"));
        connection.commit();
    }

    protected String createTableStatement(String newTable, String copyTable) {
        return String.format("CREATE TABLE %s (pk int primary key, aa int)", newTable);
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.SIGNAL_DATA_COLLECTION, "testDB1.dbo.debezium_signal")).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250)).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, true);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        String tableIncludeList = signalTableOnly ? "dbo.b,dbo.debezium_signal" : "dbo.a,dbo.b,dbo.debezium_signal";
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.SIGNAL_DATA_COLLECTION, "testDB1.dbo.debezium_signal")).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, tableIncludeList)).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250)).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, true)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, storeOnlyCapturedDdl);
    }
}

