/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CaseSensitivenessIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1051"})
    public void caseInsensitiveDatabase() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE MyTableOne (Id int primary key, ColA varchar(30))", "INSERT INTO MyTableOne VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "MyTableOne");
        this.testDatabase();
    }

    @Test
    @FixFor(value={"DBZ-1051"})
    public void caseSensitiveDatabase() throws Exception {
        this.connection.execute(new String[]{"ALTER DATABASE testDB1 COLLATE Latin1_General_BIN", "CREATE TABLE MyTableOne (Id int primary key, ColA varchar(30))", "INSERT INTO MyTableOne VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "MyTableOne");
        this.testDatabase();
    }

    private void testDatabase() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.MyTableOne")).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.MyTableOne").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.MyTableOne.Value").field("Id", Schema.INT32_SCHEMA).field("ColA", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.MyTableOne.Key").field("Id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)((Struct)record.value()).get("after")).getInt32("Id")).isEqualTo(1);
        this.connection.execute(new String[]{"INSERT INTO MyTableOne VALUES(2, 'b')"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.MyTableOne")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.MyTableOne").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.MyTableOne.Value").field("Id", Schema.INT32_SCHEMA).field("ColA", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.MyTableOne.Key").field("Id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)((Struct)record.value()).get("after")).getInt32("Id")).isEqualTo(2);
        this.connection.execute(new String[]{"CREATE TABLE MyTableTwo (Id int primary key, ColB varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "MyTableTwo");
        this.connection.execute(new String[]{"INSERT INTO MyTableTwo VALUES(3, 'b')"});
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.MyTableTwo")).hasSize(1);
        record = (SourceRecord)records.recordsForTopic("server1.testDB1.dbo.MyTableTwo").get(0);
        this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.testDB1.dbo.MyTableTwo.Value").field("Id", Schema.INT32_SCHEMA).field("ColB", Schema.OPTIONAL_STRING_SCHEMA).build());
        this.assertSchemaMatchesStruct((Struct)record.key(), SchemaBuilder.struct().name("server1.testDB1.dbo.MyTableTwo.Key").field("Id", Schema.INT32_SCHEMA).build());
        Assertions.assertThat((Integer)((Struct)((Struct)record.value()).get("after")).getInt32("Id")).isEqualTo(3);
    }
}

